/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtils {
    private DateUtils() {
    }

    public static Date fromMillisUtc(long millisecondsFromEpoch) {
        return new Date(millisecondsFromEpoch);
    }

    public static String toUTCString(Date date) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        sd.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sd.format(date);
    }

    public static Date fromISODateString(String isoFormattedDate) throws InvalidFormatException {
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        isoDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return isoDateFormat.parse(isoFormattedDate);
        }
        catch (ParseException e) {
            throw new InvalidFormatException("Error parsing as date", (Object)isoFormattedDate, Date.class);
        }
    }

    public static Date fromISO8601DateString(String iso8601FormattedDate) throws InvalidFormatException {
        SimpleDateFormat iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        try {
            return iso8601Format.parse(iso8601FormattedDate);
        }
        catch (ParseException e) {
            throw new InvalidFormatException("Error parsing as date", (Object)iso8601FormattedDate, Date.class);
        }
    }

    public static Date fromRfc1123DateString(String rfc1123FormattedDate, Locale locale) throws InvalidFormatException {
        SimpleDateFormat rfc1123DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", locale);
        try {
            return rfc1123DateFormat.parse(rfc1123FormattedDate);
        }
        catch (ParseException e) {
            throw new InvalidFormatException("Error parsing as date", (Object)rfc1123FormattedDate, Date.class);
        }
    }

    public static long toUnixTime(long javaTime) {
        return javaTime / 1000L;
    }

    public static long toUnixTime(Date time) {
        return time.getTime() / 1000L;
    }

    public static Long toUnixTimeNullSafe(Date time) {
        return time == null ? null : Long.valueOf(time.getTime() / 1000L);
    }

    public static Long toMillisNullSafe(Date time) {
        return time == null ? null : Long.valueOf(time.getTime());
    }

    public static Date fromUnixTime(long unix) {
        return new Date(unix * 1000L);
    }
}

