/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;

public class ObjectMapperHelper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private ObjectMapperHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readValue(URL src, Class<T> valueType) throws IOException {
        try (InputStream inputStream = null;){
            inputStream = src.openStream();
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
            Object object = objectMapper.readValue((Reader)reader, valueType);
            return (T)object;
        }
    }

    public static <T> String toJSON(T valueType) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        String json = "Problem serializing " + valueType.getClass();
        try {
            json = objectMapper.writeValueAsString(valueType);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

