/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.retries;

import java.util.concurrent.Callable;
import org.knowm.xchange.utils.retries.IPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retries {
    private static final Logger log = LoggerFactory.getLogger(Retries.class);

    public static <V> V callWithRetries(int nAttempts, int initialRetrySec, Callable<V> action, IPredicate<Exception> retryableException) throws Exception {
        int retryDelaySec = initialRetrySec;
        for (int attemptsLeftAfterThis = nAttempts - 1; attemptsLeftAfterThis >= 0; --attemptsLeftAfterThis) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (!retryableException.test(e)) {
                    throw e;
                }
                if (attemptsLeftAfterThis <= 0) {
                    throw new RuntimeException("Ultimately failed after " + nAttempts + " attempts.", e);
                }
                log.warn("Failed; {} attempts left: {}", (Object)e.toString(), (Object)attemptsLeftAfterThis);
                retryDelaySec = Retries.pauseAndIncrease(retryDelaySec);
                continue;
            }
        }
        throw new RuntimeException("Failed; total attempts allowed: " + nAttempts);
    }

    private static int pauseAndIncrease(int retryDelaySec) {
        Retries.pause(retryDelaySec);
        retryDelaySec = Math.min(retryDelaySec * 2 - (int)((double)retryDelaySec * 0.75), 3600);
        return retryDelaySec;
    }

    public static void pause(int sec) {
        try {
            log.debug("Pausing for {} sec", (Object)sec);
            Thread.sleep(sec * 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

