/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dsx.dto.account.DSXAccountInfo;
import org.knowm.xchange.dsx.dto.account.DSXCurrencyAmount;
import org.knowm.xchange.dsx.dto.marketdata.DSXExchangeInfo;
import org.knowm.xchange.dsx.dto.marketdata.DSXPairInfo;
import org.knowm.xchange.dsx.dto.marketdata.DSXTicker;
import org.knowm.xchange.dsx.dto.marketdata.DSXTrade;
import org.knowm.xchange.dsx.dto.meta.DSXMetaData;
import org.knowm.xchange.dsx.dto.trade.DSXOrder;
import org.knowm.xchange.dsx.dto.trade.DSXTradeHistoryResult;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.RateLimit;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSXAdapters {
    private static final Logger log = LoggerFactory.getLogger(DSXAdapters.class);

    private DSXAdapters() {
    }

    public static List<LimitOrder> adaptOrders(List<BigDecimal[]> dSXOrders, CurrencyPair currencyPair, String orderTypeString, String id) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        Order.OrderType orderType = orderTypeString.equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        for (BigDecimal[] dsxOrder : dSXOrders) {
            limitOrders.add(DSXAdapters.adaptOrders(dsxOrder[1], dsxOrder[0], currencyPair, orderType, id));
        }
        return limitOrders;
    }

    public static LimitOrder adaptOrders(BigDecimal amount, BigDecimal price, CurrencyPair currencyPair, Order.OrderType orderType, String id) {
        return new LimitOrder(orderType, amount, currencyPair, id, null, price);
    }

    public static Trade adaptTrade(DSXTrade dSXTrade, CurrencyPair currencyPair) {
        Order.OrderType orderType = dSXTrade.getTradeType().equalsIgnoreCase("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
        BigDecimal amount = dSXTrade.getAmount();
        BigDecimal price = dSXTrade.getPrice();
        Date date = DateUtils.fromMillisUtc((long)(dSXTrade.getDate() * 1000L));
        String tradeId = String.valueOf(dSXTrade.getTid());
        return new Trade(orderType, amount, currencyPair, price, date, tradeId);
    }

    public static Trades adaptTrades(DSXTrade[] dSXTrades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>();
        long lastTradeId = 0L;
        for (DSXTrade dSXTrade : dSXTrades) {
            long tradeId = dSXTrade.getTid();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(0, DSXAdapters.adaptTrade(dSXTrade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Ticker adaptTicker(DSXTicker dSXTicker, CurrencyPair currencyPair) {
        BigDecimal last = dSXTicker.getLast();
        BigDecimal bid = dSXTicker.getSell();
        BigDecimal ask = dSXTicker.getBuy();
        BigDecimal high = dSXTicker.getHigh();
        BigDecimal low = dSXTicker.getAvg();
        BigDecimal avg = dSXTicker.getVolCur();
        BigDecimal volume = dSXTicker.getVolCur();
        Date timestamp = DateUtils.fromMillisUtc((long)(dSXTicker.getUpdated() * 1000L));
        return new Ticker.Builder().currencyPair(currencyPair).last(last).bid(bid).ask(ask).high(high).low(low).vwap(avg).volume(volume).timestamp(timestamp).build();
    }

    public static Wallet adaptWallet(DSXAccountInfo dsxAccountInfo) {
        ArrayList<Balance> balances = new ArrayList<Balance>();
        for (Map.Entry<String, DSXCurrencyAmount> e : dsxAccountInfo.getFunds().entrySet()) {
            String currency = e.getKey();
            BigDecimal total = e.getValue().getTotal();
            BigDecimal available = e.getValue().getAvailable();
            if (available == null) {
                available = total;
            }
            balances.add(new Balance(Currency.getInstance((String)currency), total, available));
        }
        return new Wallet(balances);
    }

    public static OpenOrders adaptOrders(Map<Long, DSXOrder> dsxOrderMap) {
        ArrayList<LimitOrder> limitOrders = new ArrayList<LimitOrder>();
        for (Long id : dsxOrderMap.keySet()) {
            DSXOrder dsxOrder = dsxOrderMap.get(id);
            Order.OrderType orderType = dsxOrder.getType() == DSXOrder.Type.buy ? Order.OrderType.BID : Order.OrderType.ASK;
            BigDecimal price = dsxOrder.getRate();
            Date timestamp = DateUtils.fromMillisUtc((long)(dsxOrder.getTimestampCreated() * 1000L));
            CurrencyPair currencyPair = DSXAdapters.adaptCurrencyPair(dsxOrder.getPair());
            limitOrders.add(new LimitOrder(orderType, dsxOrder.getAmount(), currencyPair, Long.toString(id), timestamp, price));
        }
        return new OpenOrders(limitOrders);
    }

    public static UserTrades adaptTradeHistory(Map<Long, DSXTradeHistoryResult> tradeHistory) {
        ArrayList<UserTrade> trades = new ArrayList<UserTrade>(tradeHistory.size());
        for (Map.Entry<Long, DSXTradeHistoryResult> entry : tradeHistory.entrySet()) {
            DSXTradeHistoryResult result = entry.getValue();
            Order.OrderType type = result.getType() == DSXTradeHistoryResult.Type.buy ? Order.OrderType.BID : Order.OrderType.ASK;
            BigDecimal price = result.getRate();
            BigDecimal tradableAmount = result.getAmount();
            Date timeStamp = DateUtils.fromMillisUtc((long)(result.getTimestamp() * 1000L));
            String orderId = String.valueOf(result.getOrderId());
            String tradeId = String.valueOf(entry.getKey());
            CurrencyPair currencyPair = DSXAdapters.adaptCurrencyPair(result.getPair());
            BigDecimal feeAmount = result.getCommission();
            Currency feeCurrency = DSXAdapters.adaptCurrency(result.getCommissionCurrency());
            trades.add(new UserTrade(type, tradableAmount, currencyPair, price, timeStamp, tradeId, orderId, feeAmount, feeCurrency));
        }
        return new UserTrades(trades, Trades.TradeSortType.SortByTimestamp);
    }

    public static CurrencyPair adaptCurrencyPair(String dsxCurrencyPair) {
        String currencyOne = dsxCurrencyPair.substring(0, 3);
        String currencyTwo = dsxCurrencyPair.substring(3, 6);
        return new CurrencyPair(currencyOne.toUpperCase(), currencyTwo.toUpperCase());
    }

    public static Currency adaptCurrency(String dsxCurrency) {
        return new Currency(dsxCurrency.toUpperCase());
    }

    public static List<CurrencyPair> adaptCurrencyPair(Iterable<String> dsxPairs) {
        ArrayList<CurrencyPair> pairs = new ArrayList<CurrencyPair>();
        for (String dsxPair : dsxPairs) {
            pairs.add(DSXAdapters.adaptCurrencyPair(dsxPair));
        }
        return pairs;
    }

    public static String getPair(CurrencyPair currencyPair) {
        String base = currencyPair.base.getCurrencyCode();
        String counter = currencyPair.counter.getCurrencyCode();
        return (base + counter).toLowerCase();
    }

    public static ExchangeMetaData toMetaData(DSXExchangeInfo dsxExchangeInfo, DSXMetaData dsxMetaData) {
        HashMap<CurrencyPair, CurrencyPairMetaData> currencyPairs = new HashMap<CurrencyPair, CurrencyPairMetaData>();
        HashMap<Currency, CurrencyMetaData> currencies = new HashMap<Currency, CurrencyMetaData>();
        if (dsxExchangeInfo != null) {
            for (Map.Entry<String, DSXPairInfo> e : dsxExchangeInfo.getPairs().entrySet()) {
                CurrencyPair pair = DSXAdapters.adaptCurrencyPair(e.getKey());
                CurrencyPairMetaData marketMetaData = DSXAdapters.toMarketMetaData(e.getValue());
                currencyPairs.put(pair, marketMetaData);
                DSXAdapters.addCurrencyMetaData(pair.base, currencies, dsxMetaData);
                DSXAdapters.addCurrencyMetaData(pair.counter, currencies, dsxMetaData);
            }
        }
        RateLimit[] publicRateLimits = new RateLimit[]{new RateLimit(dsxMetaData.publicInfoCacheSeconds, 1, TimeUnit.SECONDS)};
        return new ExchangeMetaData(currencyPairs, currencies, publicRateLimits, null, Boolean.valueOf(false));
    }

    private static void addCurrencyMetaData(Currency symbol, Map<Currency, CurrencyMetaData> currencies, DSXMetaData dsxMetaData) {
        if (!currencies.containsKey(symbol)) {
            currencies.put(symbol, new CurrencyMetaData(dsxMetaData.amountScale));
        }
    }

    public static CurrencyPairMetaData toMarketMetaData(DSXPairInfo info) {
        int priceScale = info.getDecimalsPrice();
        BigDecimal minimumAmount = DSXAdapters.withScale(info.getMinAmount(), info.getDecimalVolume());
        BigDecimal maximumAmount = DSXAdapters.withScale(info.getMaxPrice(), info.getDecimalVolume());
        BigDecimal feeFraction = info.getFee().movePointLeft(2);
        return new CurrencyPairMetaData(feeFraction, minimumAmount, maximumAmount, Integer.valueOf(priceScale));
    }

    private static BigDecimal withScale(BigDecimal value, int priceScale) {
        try {
            return value.setScale(priceScale, RoundingMode.UNNECESSARY);
        }
        catch (ArithmeticException e) {
            log.debug("Could not round {} to {} decimal places: {}", new Object[]{value, priceScale, e.getMessage()});
            return value.setScale(priceScale, RoundingMode.CEILING);
        }
    }

    public static LimitOrder createLimitOrder(MarketOrder marketOrder, DSXExchangeInfo dsxExchangeInfo) {
        DSXPairInfo dsxPairInfo = dsxExchangeInfo.getPairs().get(DSXAdapters.getPair(marketOrder.getCurrencyPair()));
        BigDecimal limitPrice = marketOrder.getType() == Order.OrderType.BID ? dsxPairInfo.getMaxPrice() : dsxPairInfo.getMinPrice();
        return LimitOrder.Builder.from((Order)marketOrder).limitPrice(limitPrice).build();
    }
}

