/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dsx.dto.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DSXTransaction {
    private final long id;
    private final Date timestamp;
    private final Type type;
    private final BigDecimal amount;
    private final String currency;
    private final String address;
    private final Status status;
    private final BigDecimal commission;
    private final String txId;

    public DSXTransaction(@JsonProperty(value="id") long id, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="type") Type type, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="currency") String currency, @JsonProperty(value="address") String address, @JsonProperty(value="status") Status status, @JsonProperty(value="commission") BigDecimal commission, @JsonProperty(value="txid") String txId) {
        this.id = id;
        this.timestamp = new Date(timestamp * 1000L);
        this.type = type;
        this.amount = amount;
        this.currency = currency;
        this.address = address;
        this.status = status;
        this.commission = commission;
        this.txId = txId;
    }

    public long getId() {
        return this.id;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getAddress() {
        return this.address;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getCommission() {
        return this.commission;
    }

    public String getTxId() {
        return this.txId;
    }

    public String toString() {
        return "DSXTransaction [id=" + this.id + ", timestamp=" + this.timestamp + ", type=" + (Object)((Object)this.type) + ", amount=" + this.amount + ", currency=" + this.currency + ", address=" + this.address + ", status=" + (Object)((Object)this.status) + ", commission=" + this.commission + ", txId=" + this.txId + "]";
    }

    public static enum Status {
        Failed(1),
        Completed(2),
        Processing(3),
        Rejected(4),
        Cancelling(5);

        private final int status;
        private static final Map<Integer, Status> STATUS_MAP;

        private Status(int status) {
            this.status = status;
        }

        @JsonCreator
        public static Status create(int status) {
            Status result = STATUS_MAP.get(status);
            if (result == null) {
                throw new RuntimeException("Unknown transaction status: " + status + ", known are: " + STATUS_MAP.keySet());
            }
            return result;
        }

        static {
            STATUS_MAP = new HashMap<Integer, Status>();
            for (Status s : Status.values()) {
                STATUS_MAP.put(s.status, s);
            }
        }
    }

    public static enum Type {
        Withdraw,
        Incoming;

    }
}

