/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.knowm.xchange.exceptions.ExchangeException;

public final class GatecoinUtils {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private GatecoinUtils() {
    }

    public static Date parseDate(String dateString) {
        try {
            return DATE_FORMAT.parse(dateString);
        }
        catch (ParseException e) {
            throw new ExchangeException("Illegal date/time format", (Throwable)e);
        }
    }

    public static Date parseUnixTSToDateTime(String dateString) {
        try {
            long unixSeconds = Long.valueOf(dateString);
            Date date = new Date(unixSeconds * 1000L);
            return DATE_FORMAT.parse(DATE_FORMAT.format(date));
        }
        catch (ParseException e) {
            throw new ExchangeException("Illegal date/time format", (Throwable)e);
        }
    }
}

