/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.gatecoin.GatecoinAdapters;
import org.knowm.xchange.gatecoin.dto.account.GatecoinDepositAddress;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinDepositAddressResult;
import org.knowm.xchange.gatecoin.dto.account.Results.GatecoinWithdrawResult;
import org.knowm.xchange.gatecoin.service.GatecoinAccountServiceRaw;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class GatecoinAccountService
extends GatecoinAccountServiceRaw
implements AccountService {
    public GatecoinAccountService(Exchange exchange) {
        super(exchange);
    }

    public AccountInfo getAccountInfo() throws IOException {
        return new AccountInfo(this.exchange.getExchangeSpecification().getUserName(), new Wallet[]{GatecoinAdapters.adaptWallet(this.getGatecoinBalance().getBalances())});
    }

    public String requestDepositAddress(Currency currency, String ... arguments) throws IOException {
        GatecoinDepositAddressResult result = this.getGatecoinDepositAddress();
        if (result.getResponseStatus().getMessage().equalsIgnoreCase("ok")) {
            GatecoinDepositAddress[] addresses = result.getAddresses();
            if (addresses.length > 0) {
                return addresses[0].getAddress();
            }
            return null;
        }
        return null;
    }

    public String withdrawFunds(WithdrawFundsParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        if (params instanceof DefaultWithdrawFundsParams) {
            DefaultWithdrawFundsParams defaultParams = (DefaultWithdrawFundsParams)params;
            return this.withdrawFunds(defaultParams.currency, defaultParams.amount, defaultParams.address);
        }
        throw new IllegalStateException("Don't know how to withdraw: " + params);
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        GatecoinWithdrawResult result = this.withdrawGatecoinFunds(currency.toString(), amount, address);
        if (result.getResponseStatus().getMessage().equalsIgnoreCase("ok")) {
            return "Ok";
        }
        return result.getResponseStatus().getMessage();
    }

    public TradeHistoryParams createFundingHistoryParams() {
        throw new NotAvailableFromExchangeException();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        throw new NotYetImplementedForExchangeException();
    }
}

