/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.gatecoin.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.gatecoin.GatecoinAdapters;
import org.knowm.xchange.gatecoin.service.GatecoinMarketDataServiceRaw;
import org.knowm.xchange.service.marketdata.MarketDataService;

public class GatecoinMarketDataService
extends GatecoinMarketDataServiceRaw
implements MarketDataService {
    public GatecoinMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws IOException {
        return GatecoinAdapters.adaptTicker(this.getGatecoinTicker().getTicker(), currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        return GatecoinAdapters.adaptOrderBook(this.getGatecoinOrderBook(currencyPair.toString()), currencyPair, 1000);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        if (args.length == 0) {
            return GatecoinAdapters.adaptTrades(this.getGatecoinTransactions(currencyPair.toString()).getTransactions(), currencyPair);
        }
        if (args.length == 1) {
            return GatecoinAdapters.adaptTrades(this.getGatecoinTransactions(currencyPair.toString(), (Integer)args[0], 0L).getTransactions(), currencyPair);
        }
        if (args.length == 2) {
            return GatecoinAdapters.adaptTrades(this.getGatecoinTransactions(currencyPair.toString(), (Integer)args[0], (Long)args[1]).getTransactions(), currencyPair);
        }
        throw new IllegalArgumentException("Illegal number of arguments: " + args.length);
    }
}

