/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.yobit.dto.marketdata.YoBitAsksBidsData;

@JsonDeserialize(using=YoBitOrderBookDeserializer.class)
public class YoBitOrderBook {
    private List<YoBitAsksBidsData> asks;
    private List<YoBitAsksBidsData> bids;

    public YoBitOrderBook(List<YoBitAsksBidsData> asks, List<YoBitAsksBidsData> bids) {
        this.asks = asks;
        this.bids = bids;
    }

    public List<YoBitAsksBidsData> getAsks() {
        return this.asks;
    }

    public List<YoBitAsksBidsData> getBids() {
        return this.bids;
    }

    static class YoBitOrderBookDeserializer
    extends JsonDeserializer<YoBitOrderBook> {
        YoBitOrderBookDeserializer() {
        }

        public YoBitOrderBook deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<YoBitAsksBidsData> asks = new ArrayList<YoBitAsksBidsData>();
            ArrayList<YoBitAsksBidsData> bids = new ArrayList<YoBitAsksBidsData>();
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            if (node.isObject()) {
                Iterator priceEntryIter = node.fields();
                while (priceEntryIter.hasNext()) {
                    Map.Entry priceEntryNode = (Map.Entry)priceEntryIter.next();
                    JsonNode priceNode = (JsonNode)priceEntryNode.getValue();
                    if (!priceNode.isObject()) continue;
                    Iterator data = priceNode.fields();
                    while (data.hasNext()) {
                        Map.Entry tmp = (Map.Entry)data.next();
                        Iterator dd = ((JsonNode)tmp.getValue()).elements();
                        while (dd.hasNext()) {
                            JsonNode arrNode = (JsonNode)dd.next();
                            if (!arrNode.isArray()) continue;
                            if (((String)tmp.getKey()).equals("asks")) {
                                asks.add(new YoBitAsksBidsData(BigDecimal.valueOf(arrNode.get(1).asDouble()), BigDecimal.valueOf(arrNode.get(0).asDouble())));
                                continue;
                            }
                            bids.add(new YoBitAsksBidsData(BigDecimal.valueOf(arrNode.get(1).asDouble()), BigDecimal.valueOf(arrNode.get(0).asDouble())));
                        }
                    }
                }
            }
            return new YoBitOrderBook(asks, bids);
        }
    }
}

