/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.dto.marketdata.YoBitPair;

@JsonDeserialize(using=YoBitPricesDeserializer.class)
public class YoBitPairs {
    private final Map<CurrencyPair, YoBitPair> pair;

    private YoBitPairs(Map<CurrencyPair, YoBitPair> pair) {
        this.pair = pair;
    }

    public Map<CurrencyPair, YoBitPair> getPrice() {
        return this.pair;
    }

    public String toString() {
        return "YoBitPairs [pair=" + this.pair + "]";
    }

    static class YoBitPricesDeserializer
    extends JsonDeserializer<YoBitPairs> {
        YoBitPricesDeserializer() {
        }

        public YoBitPairs deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            HashMap<CurrencyPair, YoBitPair> priceMap = new HashMap<CurrencyPair, YoBitPair>();
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            if (node.isObject()) {
                Iterator priceEntryIter = node.fields();
                while (priceEntryIter.hasNext()) {
                    Map.Entry priceEntryNode = (Map.Entry)priceEntryIter.next();
                    String pairString = (String)priceEntryNode.getKey();
                    CurrencyPair pair = YoBitAdapters.adaptCurrencyPair(pairString);
                    JsonNode priceNode = (JsonNode)priceEntryNode.getValue();
                    YoBitPair price = YoBitPair.YoBitPairDeserializer.deserializeFromNode(priceNode);
                    priceMap.put(pair, price);
                }
            }
            return new YoBitPairs(priceMap);
        }
    }
}

