/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.marketdata.MarketDataService;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTickerReturn;
import org.knowm.xchange.yobit.service.YoBitMarketDataServiceRaw;

public class YoBitMarketDataService
extends YoBitMarketDataServiceRaw
implements MarketDataService {
    public YoBitMarketDataService(Exchange exchange) {
        super(exchange);
    }

    public Ticker getTicker(CurrencyPair currencyPair, Object ... args) throws ExchangeException, NotAvailableFromExchangeException, NotYetImplementedForExchangeException, IOException {
        YoBitTickerReturn ticker = this.getYoBitTicker(currencyPair);
        return YoBitAdapters.adaptTicker(ticker, currencyPair);
    }

    public OrderBook getOrderBook(CurrencyPair currencyPair, Object ... args) throws IOException {
        long level = 50L;
        if (args != null && args.length > 0 && args[0] instanceof Number) {
            Number arg = (Number)args[0];
            level = arg.intValue();
        }
        return YoBitAdapters.adaptOrderBook(this.getOrderBookA(currencyPair, level), currencyPair);
    }

    public Trades getTrades(CurrencyPair currencyPair, Object ... args) throws IOException {
        return YoBitAdapters.adaptTrades(this.getTrades(currencyPair), currencyPair);
    }
}

