/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.exception.UnexpectedLiquibaseException;

public abstract class AbstractConfigurationContainer
implements liquibase.configuration.ConfigurationContainer {
    private ConfigurationContainer configurationContainer;

    protected AbstractConfigurationContainer(String namespace) {
        this.configurationContainer = new ConfigurationContainer(namespace);
    }

    protected ConfigurationContainer getContainer() {
        return this.configurationContainer;
    }

    @Override
    public ConfigurationProperty getProperty(String propertyName) {
        return this.getContainer().getProperty(propertyName);
    }

    @Override
    public Set<ConfigurationProperty> getProperties() {
        return new HashSet<ConfigurationProperty>(this.getContainer().properties.values());
    }

    @Override
    public <T> T getValue(String propertyName, Class<T> returnType) {
        return this.getContainer().getValue(propertyName, returnType);
    }

    @Override
    public void init(ConfigurationValueProvider ... configurationValueProviders) {
        if (configurationValueProviders != null) {
            for (ConfigurationProperty property : this.getContainer().properties.values()) {
                property.init(configurationValueProviders);
            }
        }
    }

    @Override
    public void setValue(String propertyName, Object value) {
        this.getContainer().setValue(propertyName, value);
    }

    protected static class ConfigurationContainer {
        private final String namespace;
        private final Map<String, ConfigurationProperty> properties = new HashMap<String, ConfigurationProperty>();

        protected ConfigurationContainer(String namespace) {
            this.namespace = namespace;
        }

        public ConfigurationProperty addProperty(String propertyName, Class type) {
            ConfigurationProperty property = new ConfigurationProperty(this.namespace, propertyName, type);
            this.properties.put(propertyName, property);
            return property;
        }

        public ConfigurationProperty getProperty(String propertyName) {
            ConfigurationProperty property = this.properties.get(propertyName);
            if (property == null) {
                throw new UnexpectedLiquibaseException("Unknown property on " + this.getClass().getName() + ": " + propertyName);
            }
            return property;
        }

        public <T> T getValue(String propertyName, Class<T> returnType) {
            ConfigurationProperty property = this.getProperty(propertyName);
            if (!property.getType().isAssignableFrom(returnType)) {
                throw new UnexpectedLiquibaseException("Property " + propertyName + " on " + this.getClass().getName() + " is of type " + property.getType().getName() + ", not " + returnType.getName());
            }
            return (T)property.getValue();
        }

        public void setValue(String propertyName, Object value) {
            ConfigurationProperty property = this.properties.get(propertyName);
            if (property == null) {
                throw new UnexpectedLiquibaseException("Unknown property on " + this.getClass().getName() + ": " + propertyName);
            }
            property.setValue(value);
        }
    }
}

