/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Rectangle;

public class BBoxCalculator {
    private final SpatialContext ctx;
    private double minY = Double.POSITIVE_INFINITY;
    private double maxY = Double.NEGATIVE_INFINITY;
    private double minX = Double.POSITIVE_INFINITY;
    private double maxX = Double.NEGATIVE_INFINITY;
    private TreeMap<Double, Double> ranges;

    public BBoxCalculator(SpatialContext ctx) {
        this.ctx = ctx;
    }

    public void expandRange(Rectangle rect) {
        this.expandRange(rect.getMinX(), rect.getMaxX(), rect.getMinY(), rect.getMaxY());
    }

    public void expandRange(double minX, double maxX, double minY, double maxY) {
        this.minY = Math.min(this.minY, minY);
        this.maxY = Math.max(this.maxY, maxY);
        this.expandXRange(minX, maxX);
    }

    public void expandXRange(double minX, double maxX) {
        if (!this.ctx.isGeo()) {
            this.minX = Math.min(this.minX, minX);
            this.maxX = Math.max(this.maxX, maxX);
            return;
        }
        if (this.doesXWorldWrap()) {
            return;
        }
        if (this.ranges == null) {
            this.ranges = new TreeMap();
            this.ranges.put(maxX, minX);
            return;
        }
        assert (!this.ranges.isEmpty());
        Iterator<Map.Entry<Object, Object>> entryIter = this.ranges.tailMap(minX, true).entrySet().iterator();
        if (!entryIter.hasNext()) {
            entryIter = this.ranges.entrySet().iterator();
        }
        Map.Entry<Object, Object> entry = entryIter.next();
        Double entryMin = (Double)entry.getValue();
        Double entryMax = (Double)entry.getKey();
        if (BBoxCalculator.rangeContains(entryMin, entryMax, maxX)) {
            if (BBoxCalculator.rangeContains(entryMin, entryMax, minX)) {
                if ((minX != entryMin || maxX != entryMax) && BBoxCalculator.rangeContains(minX, maxX, entryMin) && BBoxCalculator.rangeContains(minX, maxX, entryMax)) {
                    this.minX = -180.0;
                    this.maxX = 180.0;
                    this.ranges = null;
                }
            } else {
                entryIter.remove();
                this.ranges.put(entryMax, minX);
            }
        } else {
            Double newMinX = BBoxCalculator.rangeContains(entryMin, entryMax, minX) ? entryMin : minX;
            Double newMaxX = maxX;
            while (BBoxCalculator.rangeContains(newMinX, newMaxX, entryMin)) {
                entryIter.remove();
                if (!BBoxCalculator.rangeContains(minX, maxX, entryMax)) {
                    newMaxX = entryMax;
                    break;
                }
                if (!entryIter.hasNext()) {
                    if (this.ranges.isEmpty()) break;
                    entryIter = this.ranges.entrySet().iterator();
                }
                entry = entryIter.next();
                entryMin = (Double)entry.getValue();
                entryMax = (Double)entry.getKey();
            }
            this.ranges.put(newMaxX, newMinX);
        }
    }

    private void processRanges() {
        if (this.ranges.size() == 1) {
            Map.Entry<Double, Double> rangeEntry = this.ranges.firstEntry();
            this.minX = rangeEntry.getValue();
            this.maxX = rangeEntry.getKey();
        } else {
            Map.Entry<Double, Double> prevRange = this.ranges.lastEntry();
            double biggestGap = 0.0;
            double possibleRemainingGap = 360.0;
            for (Map.Entry<Double, Double> range : this.ranges.entrySet()) {
                double gap;
                double widthPlusGap = range.getKey() - prevRange.getKey();
                if (widthPlusGap < 0.0) {
                    widthPlusGap += 360.0;
                }
                if ((gap = range.getValue() - prevRange.getKey()) < 0.0) {
                    gap += 360.0;
                }
                possibleRemainingGap -= widthPlusGap;
                if (gap > biggestGap) {
                    biggestGap = gap;
                    this.minX = range.getValue();
                    this.maxX = prevRange.getKey();
                    if (possibleRemainingGap <= biggestGap) break;
                }
                prevRange = range;
            }
        }
        this.ranges = null;
    }

    private static boolean rangeContains(double minX, double maxX, double x) {
        if (minX <= maxX) {
            return x >= minX && x <= maxX;
        }
        return x >= minX || x <= maxX;
    }

    public boolean doesXWorldWrap() {
        assert (this.ctx.isGeo());
        return this.minX == -180.0 && this.maxX == 180.0;
    }

    public Rectangle getBoundary() {
        return this.ctx.makeRectangle(this.getMinX(), this.getMaxX(), this.getMinY(), this.getMaxY());
    }

    public double getMinX() {
        if (this.ranges != null) {
            this.processRanges();
        }
        return this.minX;
    }

    public double getMaxX() {
        if (this.ranges != null) {
            this.processRanges();
        }
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }
}

