/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.modelmapper.Converter;
import org.modelmapper.TypeMap;
import org.modelmapper.convention.MatchingStrategies;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.InternalMapping;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.Pair;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.PropertyNameInfoImpl;
import org.modelmapper.internal.TypeInfo;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.internal.TypeMapStore;
import org.modelmapper.internal.converter.ConverterStore;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.Strings;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MatchingStrategy;
import org.modelmapper.spi.NameableType;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

class ImplicitMappingBuilder<S, D> {
    private final TypeMapImpl<S, D> typeMap;
    private final TypeInfo<S> sourceTypeInfo;
    private final TypeMapStore typeMapStore;
    private final InheritingConfiguration configuration;
    private final ConverterStore converterStore;
    private final MatchingStrategy matchingStrategy;
    private final Errors errors = new Errors();
    private final PropertyNameInfoImpl propertyNameInfo;
    private final Set<Class<?>> sourceTypes = new HashSet();
    private final Set<Class<?>> destinationTypes = new HashSet();
    private final List<PropertyMappingImpl> mappings = new ArrayList<PropertyMappingImpl>();
    private final List<PropertyMappingImpl> partiallyMatchedMappings = new ArrayList<PropertyMappingImpl>();
    private final Map<PropertyInfo, PropertyMappingImpl> intermediateMappings = new HashMap<PropertyInfo, PropertyMappingImpl>();
    private final List<InternalMapping> mergedMappings = new ArrayList<InternalMapping>();

    static <S, D> void build(S source, TypeMapImpl<S, D> typeMap, TypeMapStore typeMapStore, ConverterStore converterStore) {
        new ImplicitMappingBuilder<S, D>(source, typeMap, typeMapStore, converterStore).build();
    }

    ImplicitMappingBuilder(S source, TypeMapImpl<S, D> typeMap, TypeMapStore typeMapStore, ConverterStore converterStore) {
        this.typeMap = typeMap;
        this.converterStore = converterStore;
        this.typeMapStore = typeMapStore;
        this.configuration = typeMap.configuration;
        this.sourceTypeInfo = TypeInfoRegistry.typeInfoFor(source, typeMap.getSourceType(), this.configuration);
        this.matchingStrategy = this.configuration.getMatchingStrategy();
        this.propertyNameInfo = new PropertyNameInfoImpl(typeMap.getSourceType(), this.configuration);
    }

    void build() {
        this.matchDestination(TypeInfoRegistry.typeInfoFor(this.typeMap.getDestinationType(), this.configuration));
    }

    private void matchDestination(TypeInfo<?> destinationTypeInfo) {
        this.destinationTypes.add(destinationTypeInfo.getType());
        for (Map.Entry<String, Mutator> entry : destinationTypeInfo.getMutators().entrySet()) {
            this.propertyNameInfo.pushDestination(entry.getKey(), entry.getValue());
            String destPath = Strings.join(this.propertyNameInfo.getDestinationProperties());
            Mutator mutator = entry.getValue();
            Mapping existingMapping = this.typeMap.mappingFor(destPath);
            if (existingMapping == null) {
                this.matchSource(this.sourceTypeInfo, mutator, false);
                this.propertyNameInfo.clearSource();
                this.sourceTypes.clear();
            }
            if (this.mappings.isEmpty()) {
                this.mappings.addAll(this.partiallyMatchedMappings);
            }
            if (!this.mappings.isEmpty()) {
                PropertyMappingImpl mapping;
                if (this.mappings.size() == 1) {
                    mapping = this.mappings.get(0);
                } else {
                    mapping = this.disambiguateMappings();
                    if (mapping == null && !this.configuration.isAmbiguityIgnored()) {
                        this.errors.ambiguousDestination(this.mappings);
                    }
                }
                if (mapping != null) {
                    this.typeMap.addMappingIfAbsent(mapping);
                    if (Iterables.isIterable(mapping.getLastDestinationProperty().getType())) {
                        for (PropertyInfo propertyInfo : mapping.getSourceProperties()) {
                            PropertyMappingImpl intermediateMapping = this.intermediateMappings.get(propertyInfo);
                            if (intermediateMapping == null || intermediateMapping.getPath().equals(mapping.getPath())) continue;
                            this.typeMap.addMappingIfAbsent(intermediateMapping);
                        }
                    }
                }
                this.mappings.clear();
                this.partiallyMatchedMappings.clear();
                this.intermediateMappings.clear();
            } else if (!this.mergedMappings.isEmpty()) {
                for (InternalMapping mapping : this.mergedMappings) {
                    this.typeMap.addMappingIfAbsent(mapping);
                }
                this.mergedMappings.clear();
            } else if (!this.destinationTypes.contains(mutator.getType()) && !this.typeMap.isSkipped(destPath) && Types.mightContainsProperties(mutator.getType()) && !this.isConvertable(existingMapping)) {
                this.matchDestination(mutator.getTypeInfo(this.configuration));
            }
            this.propertyNameInfo.popDestination();
        }
        this.destinationTypes.remove(destinationTypeInfo.getType());
        this.errors.throwConfigurationExceptionIfErrorsExist();
    }

    private void matchSource(TypeInfo<?> sourceTypeInfo, Mutator destinationMutator, boolean hitSameSourceType) {
        this.sourceTypes.add(sourceTypeInfo.getType());
        for (Map.Entry<String, Accessor> entry : sourceTypeInfo.getAccessors().entrySet()) {
            Accessor accessor = entry.getValue();
            this.propertyNameInfo.pushSource(entry.getKey(), entry.getValue());
            boolean doneMatching = false;
            if (this.matchingStrategy.matches(this.propertyNameInfo)) {
                if (this.destinationTypes.contains(destinationMutator.getType())) {
                    this.mappings.add(new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), true));
                } else if (!this.configuration.isPreferNestedProperties() && MatchingStrategies.STRICT.matches(this.propertyNameInfo)) {
                    this.mappings.add(new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), false));
                } else {
                    TypeMap<?, ?> propertyTypeMap = this.typeMapStore.get(accessor.getType(), destinationMutator.getType(), null);
                    PropertyMappingImpl mapping = null;
                    if (propertyTypeMap != null) {
                        Converter<?, ?> propertyConverter = propertyTypeMap.getConverter();
                        if (propertyConverter == null) {
                            this.mergeMappings(propertyTypeMap);
                        } else {
                            this.mappings.add(new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), propertyTypeMap.getProvider(), propertyConverter));
                        }
                        doneMatching = this.matchingStrategy.isExact();
                    } else {
                        for (ConditionalConverter<?, ?> converter : this.converterStore.getConverters()) {
                            ConditionalConverter.MatchResult matchResult = converter.match(accessor.getType(), destinationMutator.getType());
                            if (ConditionalConverter.MatchResult.NONE.equals((Object)matchResult)) continue;
                            mapping = new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), false);
                            if (ConditionalConverter.MatchResult.FULL.equals((Object)matchResult)) {
                                this.mappings.add(mapping);
                                doneMatching = this.matchingStrategy.isExact();
                                break;
                            }
                            if (this.configuration.isFullTypeMatchingRequired()) continue;
                            this.partiallyMatchedMappings.add(mapping);
                            break;
                        }
                    }
                    if (mapping == null) {
                        this.intermediateMappings.put(accessor, new PropertyMappingImpl(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties(), false));
                    }
                }
            }
            if (!doneMatching && !hitSameSourceType && Types.mightContainsProperties(accessor.getType())) {
                if (accessor instanceof PropertyInfoImpl.ValueReaderPropertyInfo) {
                    this.matchSource(accessor.getTypeInfo(this.configuration), destinationMutator, false);
                } else if (!this.sourceTypes.contains(accessor.getType())) {
                    this.matchSource(accessor.getTypeInfo(this.configuration), destinationMutator, false);
                } else {
                    this.matchSource(accessor.getTypeInfo(this.configuration), destinationMutator, true);
                }
            }
            this.propertyNameInfo.popSource();
            if (!doneMatching) continue;
            break;
        }
        if (!hitSameSourceType) {
            this.sourceTypes.remove(sourceTypeInfo.getType());
        }
    }

    private PropertyMappingImpl disambiguateMappings() {
        ArrayList<WeightPropertyMappingImpl> weightMappings = new ArrayList<WeightPropertyMappingImpl>(this.mappings.size());
        for (PropertyMappingImpl mapping : this.mappings) {
            SourceTokensMatcher matcher = this.createSourceTokensMatcher(mapping);
            DestTokenIterator destTokenIterator = new DestTokenIterator(mapping);
            while (destTokenIterator.hasNext()) {
                matcher.match(destTokenIterator.next());
            }
            double matchRatio = (double)matcher.matches() * matcher.orderMatchWeight() / ((double)matcher.total() + (double)destTokenIterator.total());
            weightMappings.add(new WeightPropertyMappingImpl(mapping, matchRatio));
        }
        Collections.sort(weightMappings);
        if (((WeightPropertyMappingImpl)weightMappings.get(0)).ratio == ((WeightPropertyMappingImpl)weightMappings.get(1)).ratio) {
            return null;
        }
        return ((WeightPropertyMappingImpl)weightMappings.get(0)).mapping;
    }

    private SourceTokensMatcher createSourceTokensMatcher(PropertyMappingImpl mapping) {
        LinkedHashMap<Pair<Integer, Integer>, String> sourceTokensMap = new LinkedHashMap<Pair<Integer, Integer>, String>();
        for (int i = 0; i < mapping.getSourceProperties().size(); ++i) {
            PropertyInfo source = mapping.getSourceProperties().get(i);
            NameableType nameableType = NameableType.forPropertyType(source.getPropertyType());
            String[] tokens = this.configuration.getSourceNameTokenizer().tokenize(source.getName(), nameableType);
            for (int j = 0; j < tokens.length; ++j) {
                sourceTokensMap.put(Pair.of(i, j), tokens[j]);
            }
        }
        return new SourceTokensMatcher(sourceTokensMap);
    }

    private void mergeMappings(TypeMap<?, ?> destinationMap) {
        for (Mapping mapping : destinationMap.getMappings()) {
            InternalMapping internalMapping = (InternalMapping)mapping;
            this.mergedMappings.add(internalMapping.createMergedCopy(this.propertyNameInfo.getSourceProperties(), this.propertyNameInfo.getDestinationProperties()));
        }
    }

    private boolean isConvertable(Mapping mapping) {
        if (mapping == null || mapping.getProvider() != null || !(mapping instanceof PropertyMapping)) {
            return false;
        }
        PropertyMapping propertyMapping = (PropertyMapping)mapping;
        boolean hasSupportConverter = this.converterStore.getFirstSupported(propertyMapping.getLastSourceProperty().getType(), mapping.getLastDestinationProperty().getType()) != null;
        boolean hasSupportTypeMap = this.typeMapStore.get(propertyMapping.getLastSourceProperty().getType(), mapping.getLastDestinationProperty().getType(), null) != null;
        return hasSupportConverter || hasSupportTypeMap;
    }

    static class WeightPropertyMappingImpl
    implements Comparable<WeightPropertyMappingImpl> {
        private PropertyMappingImpl mapping;
        private double ratio;

        WeightPropertyMappingImpl(PropertyMappingImpl mapping, double ratio) {
            this.mapping = mapping;
            this.ratio = ratio;
        }

        @Override
        public int compareTo(WeightPropertyMappingImpl o) {
            if (this.ratio == o.ratio) {
                return 0;
            }
            return this.ratio > o.ratio ? -1 : 1;
        }
    }

    class DestTokenIterator
    implements Iterator<String> {
        private PropertyMappingImpl mapping;
        private String[] destTokens = new String[0];
        private int total = 0;
        private int destIndex = -1;
        private int pos = -1;

        DestTokenIterator(PropertyMappingImpl mapping) {
            this.mapping = mapping;
        }

        @Override
        public boolean hasNext() {
            return this.destIndex < this.mapping.getDestinationProperties().size() - 1 || this.pos < this.destTokens.length - 1;
        }

        @Override
        public String next() {
            if (this.pos == this.destTokens.length - 1) {
                PropertyInfo dest = this.mapping.getDestinationProperties().get(++this.destIndex);
                NameableType nameableType = NameableType.forPropertyType(dest.getPropertyType());
                this.destTokens = ImplicitMappingBuilder.this.configuration.getDestinationNameTokenizer().tokenize(dest.getName(), nameableType);
                this.pos = -1;
            }
            ++this.total;
            return this.destTokens[++this.pos];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        int total() {
            return this.total;
        }
    }

    static class SourceTokensMatcher {
        private Map<Pair<Integer, Integer>, String> tokens;
        private List<Pair<Integer, Integer>> unmatched;
        private int orderMatches = 0;

        SourceTokensMatcher(Map<Pair<Integer, Integer>, String> tokens) {
            this.tokens = tokens;
            this.unmatched = new ArrayList<Pair<Integer, Integer>>(tokens.keySet());
        }

        void match(String token) {
            Iterator<Pair<Integer, Integer>> iterator = this.unmatched.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (this.tokens.get(iterator.next()).equalsIgnoreCase(token)) {
                    iterator.remove();
                    if (!first) break;
                    ++this.orderMatches;
                    break;
                }
                first = false;
            }
        }

        int matches() {
            return this.tokens.size() - this.unmatched.size();
        }

        int total() {
            return this.tokens.size();
        }

        double orderMatchWeight() {
            return 1.0 + (double)this.orderMatches * 0.1;
        }
    }
}

