/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.util;

import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Types;
import org.modelmapper.spi.Mapping;
import org.modelmapper.spi.MappingContext;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyMapping;

public final class MappingContextHelper {
    private MappingContextHelper() {
    }

    public static <T> Collection<T> createCollection(MappingContext<?, Collection<T>> context) {
        if (context.getDestinationType().isInterface()) {
            if (SortedSet.class.isAssignableFrom(context.getDestinationType())) {
                return new TreeSet();
            }
            if (Set.class.isAssignableFrom(context.getDestinationType())) {
                return new HashSet();
            }
            return new ArrayList();
        }
        return context.getMappingEngine().createDestination(context);
    }

    public static Class<?> resolveDestinationGenericType(MappingContext<?, ?> context) {
        PropertyInfo destInfo;
        Class<?> elementType;
        Mapping mapping = context.getMapping();
        if (mapping instanceof PropertyMapping && (elementType = TypeResolver.resolveRawArgument((destInfo = mapping.getLastDestinationProperty()).getGenericType(), destInfo.getInitialType())) != TypeResolver.Unknown.class) {
            return elementType;
        }
        if (context.getGenericDestinationType() instanceof ParameterizedType) {
            return Types.rawTypeFor(((ParameterizedType)context.getGenericDestinationType()).getActualTypeArguments()[0]);
        }
        return Object.class;
    }
}

