/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper;

import org.modelmapper.Condition;
import org.modelmapper.Converter;
import org.modelmapper.Provider;
import org.modelmapper.builder.ConverterExpression;
import org.modelmapper.builder.MapExpression;
import org.modelmapper.builder.ProviderExpression;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.internal.util.Assert;

public abstract class PropertyMap<S, D> {
    public S source;
    public D destination;
    Class<D> destinationType;
    Class<S> sourceType;
    private ExplicitMappingBuilder<S, D> builder;

    protected PropertyMap() {
        Class<?>[] typeArguments = TypeResolver.resolveRawArguments(PropertyMap.class, this.getClass());
        Assert.notNull(typeArguments, "Must declare source type argument <S> and destination type argument <D> for PropertyMap");
        this.sourceType = typeArguments[0];
        this.destinationType = typeArguments[1];
    }

    protected PropertyMap(Class<S> sourceType, Class<D> destinationType) {
        this.sourceType = sourceType;
        this.destinationType = destinationType;
    }

    protected abstract void configure();

    protected final D map() {
        this.assertBuilder();
        return this.builder.map();
    }

    protected final D map(Object subject) {
        this.assertBuilder();
        return this.builder.map(subject);
    }

    protected final void map(Object source, Object destination) {
        this.assertBuilder();
        this.builder.map(source, destination);
    }

    protected final D skip() {
        this.assertBuilder();
        return this.builder.skip();
    }

    protected final void skip(Object destination) {
        this.assertBuilder();
        this.builder.skip(destination);
    }

    protected final void skip(Object source, Object destination) {
        this.assertBuilder();
        this.builder.skip(source, destination);
    }

    protected <T> T source(String sourcePropertyPath) {
        this.assertBuilder();
        return this.builder.source(sourcePropertyPath);
    }

    protected Object destination(String destinationPropertyPath) {
        this.assertBuilder();
        return this.builder.destination(destinationPropertyPath);
    }

    protected final MapExpression<D> using(Converter<?, ?> converter) {
        this.assertBuilder();
        return this.builder.using((Converter)converter);
    }

    protected final ProviderExpression<S, D> when(Condition<?, ?> condition) {
        this.assertBuilder();
        return this.builder.when((Condition)condition);
    }

    protected final ConverterExpression<S, D> with(Provider<?> provider) {
        this.assertBuilder();
        return this.builder.with((Provider)provider);
    }

    private void assertBuilder() {
        Assert.state(this.builder != null, "PropertyMap should not be used outside the context of PropertyMap.configure().", new Object[0]);
    }

    private synchronized void configure(ExplicitMappingBuilder<S, D> builder) {
        this.builder = builder;
        try {
            builder.visitPropertyMap(this);
            this.source = builder.source;
            this.destination = builder.destination;
            this.configure();
        }
        finally {
            this.builder = null;
            this.source = null;
        }
    }
}

