/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.TypeInfo;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.typetools.TypeResolver;
import org.modelmapper.spi.PropertyInfo;
import org.modelmapper.spi.PropertyType;
import org.modelmapper.spi.ValueReader;
import org.modelmapper.spi.ValueWriter;

abstract class PropertyInfoImpl<M extends Member>
implements PropertyInfo {
    protected final Class<?> initialType;
    protected final M member;
    protected final Class<?> type;
    protected final String name;
    private final PropertyType propertyType;

    private PropertyInfoImpl(Class<?> initialType, M member, PropertyType propertyType, String name) {
        this.initialType = initialType;
        this.member = member;
        this.propertyType = propertyType;
        Type genericType = this.getGenericType();
        this.type = genericType == null ? initialType : TypeResolver.resolveRawClass(genericType, initialType);
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyInfoImpl that = (PropertyInfoImpl)o;
        if (this.member != null ? !this.member.equals(that.member) : that.member != null) {
            return false;
        }
        return this.name.equals(that.name);
    }

    @Override
    public Class<?> getInitialType() {
        return this.initialType;
    }

    public M getMember() {
        return this.member;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public int hashCode() {
        return (this.member == null ? 1 : this.member.getDeclaringClass().hashCode()) * 31 + this.name.hashCode();
    }

    public String toString() {
        return this.member == null ? this.name : this.member.getDeclaringClass().getSimpleName() + "." + this.name;
    }

    /* synthetic */ PropertyInfoImpl(Class x0, Member x1, PropertyType x2, String x3, 1 x4) {
        this(x0, x1, x2, x3);
    }

    static class ValueWriterPropertyInfo
    extends PropertyInfoImpl<Member>
    implements Mutator {
        private ValueWriter.Member<Object> valueWriterMember;

        ValueWriterPropertyInfo(ValueWriter.Member<?> valueWriterMember, Class<?> initialType, String name) {
            super(initialType, null, PropertyType.GENERIC, name, null);
            this.valueWriterMember = valueWriterMember;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Type getGenericType() {
            return this.type;
        }

        @Override
        public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
            return TypeInfoRegistry.typeInfoFor(this.type, configuration);
        }

        @Override
        public void setValue(Object subject, Object value) {
            this.valueWriterMember.setValue(subject, value);
        }

        static ValueWriterPropertyInfo fromMember(final ValueWriter.Member<?> valueWriterMember, String memberName) {
            if (valueWriterMember.getOrigin() != null) {
                return new ValueWriterPropertyInfo(valueWriterMember, valueWriterMember.getValueType(), memberName){

                    @Override
                    public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
                        return TypeInfoRegistry.typeInfoFor(valueWriterMember.getOrigin(), valueWriterMember.getValueType(), configuration);
                    }
                };
            }
            return new ValueWriterPropertyInfo(valueWriterMember, valueWriterMember.getValueType(), memberName);
        }

        static ValueWriterPropertyInfo create(ValueWriter<?> valueWriter, final String memberName) {
            final ValueWriter<?> uncheckedValueWriter = valueWriter;
            ValueWriter.Member<Object> valueWriterMember = new ValueWriter.Member<Object>(Object.class){

                @Override
                public void setValue(Object source, Object value) {
                    uncheckedValueWriter.setValue(source, value, memberName);
                }
            };
            return new ValueWriterPropertyInfo(valueWriterMember, valueWriterMember.getValueType(), memberName);
        }
    }

    static class ValueReaderPropertyInfo
    extends PropertyInfoImpl<Member>
    implements Accessor {
        private ValueReader.Member<Object> valueReaderMember;

        ValueReaderPropertyInfo(ValueReader.Member<?> valueReaderMember, Class<?> initialType, String name) {
            super(initialType, null, PropertyType.GENERIC, name, null);
            this.valueReaderMember = valueReaderMember;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Type getGenericType() {
            return this.type;
        }

        @Override
        public Object getValue(Object subject) {
            return this.valueReaderMember.get(subject, this.name);
        }

        @Override
        public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
            return TypeInfoRegistry.typeInfoFor(this.type, configuration);
        }

        static ValueReaderPropertyInfo fromMember(final ValueReader.Member<?> valueReaderMember, String memberName) {
            if (valueReaderMember.getOrigin() != null) {
                return new ValueReaderPropertyInfo(valueReaderMember, valueReaderMember.getValueType(), memberName){

                    @Override
                    public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
                        return TypeInfoRegistry.typeInfoFor(valueReaderMember.getOrigin(), valueReaderMember.getValueType(), configuration);
                    }
                };
            }
            return new ValueReaderPropertyInfo(valueReaderMember, valueReaderMember.getValueType(), memberName);
        }

        static ValueReaderPropertyInfo create(ValueReader<?> valueReader, String memberName) {
            final ValueReader<?> uncheckedValueReader = valueReader;
            ValueReader.Member<Object> valueReaderMember = new ValueReader.Member<Object>(Object.class){

                @Override
                public Object get(Object source, String memberName) {
                    return uncheckedValueReader.get(source, memberName);
                }
            };
            return new ValueReaderPropertyInfo(valueReaderMember, valueReaderMember.getValueType(), memberName);
        }
    }

    static class MethodMutator
    extends AbstractMethodInfo
    implements Mutator {
        MethodMutator(Class<?> initialType, Method method, String name) {
            super(initialType, method, name);
        }

        @Override
        public Type getGenericType() {
            return ((Method)this.member).getGenericParameterTypes()[0];
        }

        @Override
        public void setValue(Object subject, Object value) {
            try {
                ((Method)this.member).invoke(subject, value);
            }
            catch (Exception e) {
                throw new Errors().errorSettingValue(this.member, value, e).toMappingException();
            }
        }

        @Override
        public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
            return TypeInfoRegistry.typeInfoFor(this.type, configuration);
        }
    }

    static class MethodAccessor
    extends AbstractMethodInfo
    implements Accessor {
        MethodAccessor(Class<?> initialType, Method method, String name) {
            super(initialType, method, name);
        }

        @Override
        public Type getGenericType() {
            return ((Method)this.member).getGenericReturnType();
        }

        @Override
        public Object getValue(Object subject) {
            try {
                return ((Method)this.member).invoke(subject, new Object[0]);
            }
            catch (IllegalAccessException e) {
                new Errors().errorAccessingProperty(this).throwMappingExceptionIfErrorsExist();
                return null;
            }
            catch (Exception e) {
                throw new Errors().errorGettingValue(this.member, e).toMappingException();
            }
        }

        @Override
        public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
            return TypeInfoRegistry.typeInfoFor(this, configuration);
        }
    }

    static class FieldPropertyInfo
    extends PropertyInfoImpl<Field>
    implements Accessor,
    Mutator {
        FieldPropertyInfo(Class<?> initialType, Field field, String name) {
            super(initialType, field, PropertyType.FIELD, name, null);
            field.setAccessible(true);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return ((Field)this.member).getAnnotation(annotationClass);
        }

        @Override
        public Type getGenericType() {
            return ((Field)this.member).getGenericType();
        }

        @Override
        public Object getValue(Object subject) {
            try {
                return ((Field)this.member).get(subject);
            }
            catch (Exception e) {
                throw new Errors().errorGettingValue(this.member, e).toMappingException();
            }
        }

        @Override
        public void setValue(Object subject, Object value) {
            try {
                ((Field)this.member).set(subject, value);
            }
            catch (Exception e) {
                throw new Errors().errorSettingValue(this.member, value, e).toMappingException();
            }
        }

        @Override
        public TypeInfo<?> getTypeInfo(InheritingConfiguration configuration) {
            return TypeInfoRegistry.typeInfoFor(this, configuration);
        }
    }

    static abstract class AbstractMethodInfo
    extends PropertyInfoImpl<Method> {
        private AbstractMethodInfo(Class<?> initialType, Method method, String name) {
            super(initialType, method, PropertyType.METHOD, name, null);
            method.setAccessible(true);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return ((Method)this.member).getAnnotation(annotationClass);
        }
    }
}

