/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandMessage;
import com.mongodb.connection.CommandResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.event.CommandListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.RawBsonDocumentCodec;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.io.ByteBufferBsonInput;

class CommandProtocol<T>
implements Protocol<T> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.command");
    private static final Set<String> SECURITY_SENSITIVE_COMMANDS = new HashSet<String>(Arrays.asList("authenticate", "saslStart", "saslContinue", "getnonce", "createUser", "updateUser", "copydbgetnonce", "copydbsaslstart", "copydb"));
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final Decoder<T> commandResultDecoder;
    private final FieldNameValidator fieldNameValidator;
    private boolean slaveOk;
    private CommandListener commandListener;
    private volatile String commandName;

    public CommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> commandResultDecoder) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(database, "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public CommandProtocol<T> slaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    @Override
    public T execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        long startTimeNanos = System.nanoTime();
        CommandMessage commandMessage = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
        ResponseBuffers responseBuffers = null;
        try {
            Object responseDocumentForEvent;
            this.sendMessage(commandMessage, connection);
            responseBuffers = connection.receiveMessage(commandMessage.getId());
            if (!ProtocolHelper.isCommandOk((BsonReader)new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer())))) {
                throw ProtocolHelper.getCommandFailureException((BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, commandMessage, new BsonDocumentCodec()), connection.getDescription().getServerAddress());
            }
            T retval = CommandProtocol.getResponseDocument(responseBuffers, commandMessage, this.commandResultDecoder);
            if (this.commandListener != null) {
                responseDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.getCommandName()) ? new BsonDocument() : (BsonDocument)CommandProtocol.getResponseDocument(responseBuffers, commandMessage, new RawBsonDocumentCodec());
                ProtocolHelper.sendCommandSucceededEvent(commandMessage, this.getCommandName(), responseDocumentForEvent, connection.getDescription(), startTimeNanos, this.commandListener);
            }
            LOGGER.debug("Command execution completed");
            responseDocumentForEvent = retval;
            return responseDocumentForEvent;
        }
        catch (RuntimeException e) {
            if (this.commandListener != null) {
                RuntimeException commandEventException = e;
                if (e instanceof MongoCommandException && SECURITY_SENSITIVE_COMMANDS.contains(this.getCommandName())) {
                    commandEventException = new MongoCommandException(new BsonDocument(), connection.getDescription().getServerAddress());
                }
                ProtocolHelper.sendCommandFailedEvent(commandMessage, this.getCommandName(), connection.getDescription(), startTimeNanos, commandEventException, this.commandListener);
            }
            throw e;
        }
        finally {
            if (responseBuffers != null) {
                responseBuffers.close();
            }
        }
    }

    private static <D> D getResponseDocument(ResponseBuffers responseBuffers, CommandMessage commandMessage, Decoder<D> decoder) {
        responseBuffers.reset();
        ReplyMessage<D> replyMessage = new ReplyMessage<D>(responseBuffers, decoder, commandMessage.getId());
        return replyMessage.getDocuments().get(0);
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending command {%s : %s} to database %s on connection [%s] to server %s", this.getCommandName(), this.command.values().iterator().next(), this.namespace.getDatabaseName(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            CommandMessage message = new CommandMessage(this.namespace.getFullName(), this.command, this.slaveOk, this.fieldNameValidator, ProtocolHelper.getMessageSettings(connection.getDescription()));
            ProtocolHelper.encodeMessage(message, (BsonOutput)bsonOutput);
            CommandResultCallback<T> receiveCallback = new CommandResultCallback<T>(callback, this.commandResultDecoder, message.getId(), connection.getDescription().getServerAddress());
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SendMessageCallback<T>(connection, bsonOutput, message.getId(), callback, receiveCallback));
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    private String getCommandName() {
        return this.commandName != null ? this.commandName : (String)this.command.keySet().iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(CommandMessage message, InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            int documentPosition = message.encodeWithMetadata((BsonOutput)bsonOutput).getFirstDocumentPosition();
            if (this.commandListener != null) {
                ByteBufBsonDocument commandDocument;
                ByteBufBsonDocument byteBufBsonDocument = ByteBufBsonDocument.createOne(bsonOutput, documentPosition);
                if (byteBufBsonDocument.containsKey("$query")) {
                    commandDocument = byteBufBsonDocument.getDocument("$query");
                    this.commandName = (String)commandDocument.keySet().iterator().next();
                } else {
                    commandDocument = byteBufBsonDocument;
                    this.commandName = byteBufBsonDocument.getFirstKey();
                }
                ByteBufBsonDocument commandDocumentForEvent = SECURITY_SENSITIVE_COMMANDS.contains(this.commandName) ? new BsonDocument() : commandDocument;
                ProtocolHelper.sendCommandStartedEvent(message, this.namespace.getDatabaseName(), this.commandName, commandDocumentForEvent, connection.getDescription(), this.commandListener);
            }
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
        }
        finally {
            bsonOutput.close();
        }
    }
}

