/*
 * Copyright 2016 MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

//package com.mongodb.connection;
//
//import com.google.common.base.Charsets;
//import com.mongodb.AuthenticationMechanism;
//import com.mongodb.MongoCredential;
//import com.mongodb.MongoException;
//import com.mongodb.MongoSecurityException;
//import com.mongodb.ServerAddress;
//import com.pimco.popcorn.jdk.kerberos.WindowsCredentialsHandle;
//import com.pimco.popcorn.kerberos.WindowsSspiSession;
//import org.ietf.jgss.GSSCredential;
//import org.ietf.jgss.GSSException;
//import org.ietf.jgss.GSSManager;
//import org.ietf.jgss.GSSName;
//import org.ietf.jgss.MessageProp;
//import org.ietf.jgss.Oid;
//
//import javax.security.auth.Subject;
//import javax.security.sasl.Sasl;
//import javax.security.sasl.SaslClient;
//import javax.security.sasl.SaslException;
//import java.net.InetAddress;
//import java.net.UnknownHostException;
//import java.security.PrivilegedAction;
//import java.util.HashMap;
//import java.util.Locale;
//import java.util.Map;
//
///**
// * Patched Mongo Authenticator to allow for Windows and Application controlled LoginContexts
// */
//class PimcoGSSAPIAuthenticator extends SaslAuthenticator {
//    private static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
//    private static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
//    public static final String SERVICE_NAME_KEY = "SERVICE_NAME";
//    public static final String SERVICE_NAME_DEFAULT_VALUE = "mongodb";
//    public static final String CANONICALIZE_HOST_NAME_KEY = "CANONICALIZE_HOST_NAME";
//    public static final Boolean CANONICALIZE_HOST_NAME_DEFAULT_VALUE = false;
//
//    private boolean sspiMode = false;
//    private Subject subject = null;
//
//    PimcoGSSAPIAuthenticator(final MongoCredential credential) {
//        super(credential);
//
//        if (getCredential().getAuthenticationMechanism() != AuthenticationMechanism.GSSAPI) {
//            throw new MongoException("Incorrect mechanism: " + this.getCredential().getMechanism());
//        }
//
//        if ("SSPI".equalsIgnoreCase(credential.getMechanismProperty("popcornMode", ""))) {
//            sspiMode = true;
//        }
//        this.subject = (Subject) credential.getMechanismProperty("subject", null);
//    }
//
//    @Override
//    public String getMechanismName() {
//        return GSSAPI_MECHANISM_NAME;
//    }
//
//    class SspiSaslClient implements SaslClient {
//        private boolean finalHandshake = false;
//        private boolean firstCall = true;
//        private final byte[] defaultQop = new byte[]{(byte) 1 };
//        protected int recvMaxBufSize = 65536;
//        private WindowsCredentialsHandle credentialsHandle;
//        private WindowsSspiSession session;
//
//        SspiSaslClient(final ServerAddress serverAddress) throws UnknownHostException {
//            credentialsHandle = WindowsCredentialsHandle.getCurrent("Kerberos", true);
//            final String spn = "mongodb/" + getHostName(serverAddress);
//            session = new WindowsSspiSession(credentialsHandle, spn, false, true);
//        }
//
//        @Override
//        public String getMechanismName() {
//            return "Kerberos";
//        }
//
//        @Override
//        public boolean hasInitialResponse() {
//            return true;
//        }
//
//        protected byte findPreferredMask(final byte pref, final byte[] in) {
//            for (int i = 0; i < in.length; i++) {
//                if ((in[i] & pref) != 0) {
//                    return in[i];
//                }
//            }
//            return (byte) 0;
//        }
//        protected void intToNetworkByteOrder(final int num, final byte[] buf,
//                                             final int start, final int count) {
//            if (count > 4) {
//                throw new IllegalArgumentException("Cannot handle more than 4 bytes");
//            }
//            int innerNum = num;
//            for (int i = count - 1; i >= 0; i--) {
//                buf[start + i] = (byte) (innerNum & 0xff);
//                innerNum >>>= 8;
//            }
//        }
//        protected int networkByteOrderToInt(final byte[] buf, final int start, final int count) {
//            if (count > 4) {
//                throw new IllegalArgumentException("Cannot handle more than 4 bytes");
//            }
//
//            int answer = 0;
//
//            for (int i = 0; i < count; i++) {
//                answer <<= 8;
//                answer |= ((int) buf[start + i] & 0xff);
//            }
//            return answer;
//        }
//
//        @Override
//        public byte[] evaluateChallenge(final byte[] challenge) throws SaslException {
//            try {
//                if (firstCall) {
//                    firstCall = false;
//                    if (session.isEstablished()) {
//                        finalHandshake = true;
//                        return session.getToken();
//                    }
//                } else if (finalHandshake) {
//                    if (challenge.length == 0) {
//                        return new byte[0];
//                    } else {
//                        byte[] decodedMsg = session.unwrap(challenge, new MessageProp(0, false));
//                        byte pref = findPreferredMask(decodedMsg[0], defaultQop);
//                        // Get server limits
//                        int srvMaxBufSize = networkByteOrderToInt(decodedMsg, 1, 3);
//                        String authName = WindowsCredentialsHandle.getCurrentPrincipal();
//                        //.getUserName() + "@PIMCO.IMSWEST.SSCIMS.COM";
//                        int outLen = 4 + authName.length();
//                        byte[] outToken = new byte[outLen];
//                        outToken[0] = pref;
//                        intToNetworkByteOrder(recvMaxBufSize, outToken, 1, 3);
//                        // copy authorization id
//                        System.arraycopy(authName.getBytes(Charsets.UTF_8), 0, outToken, 4, authName.length());
//                        byte[] wrappedOut = session.wrap(outToken, null);
//                        return wrappedOut;
//                    }
//                } else {
//                    throw new RuntimeException("Bad protocol exchange!");
//                }
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//            return new byte[0];
//        }
//
//        @Override
//        public boolean isComplete() {
//            return session.isEstablished();
//        }
//
//        @Override
//        public byte[] unwrap(final byte[] incoming, final int offset, final int len) throws SaslException {
//            return new byte[0];
//        }
//
//        @Override
//        public byte[] wrap(final byte[] outgoing, final int offset, final int len) throws SaslException {
//            return new byte[0];
//        }
//
//        @Override
//        public Object getNegotiatedProperty(final String propName) {
//            return null;
//        }
//
//        @Override
//        public void dispose() throws SaslException {
//
//        }
//    }
//
//    protected SaslClient createSspiSaslClient(final ServerAddress serverAddress) {
//        try {
//            return new SspiSaslClient(serverAddress);
//        } catch (UnknownHostException e) {
//            throw new MongoException("Uknown Host!", e);
//        }
//    }
//
//
//    @Override
//    protected SaslClient createSaslClient(final ServerAddress serverAddress) {
//        if (sspiMode) {
//            return createSspiSaslClient(serverAddress);
//        }
//        return createGSSSaslClient(serverAddress);
//    }
//
//    protected SaslClient createGSSSaslClient(final ServerAddress serverAddress) {
//        MongoCredential credential = getCredential();
//        try {
//            Map<String, Object> props = new HashMap<String, Object>();
//            props.put(Sasl.CREDENTIALS, getGSSCredential(credential.getUserName()));
//
//            SaslClient saslClient = Sasl.createSaslClient(new String[]{AuthenticationMechanism.GSSAPI.getMechanismName()},
//                    credential.getUserName(),
//                    credential.getMechanismProperty(SERVICE_NAME_KEY, SERVICE_NAME_DEFAULT_VALUE),
//                    getHostName(serverAddress), props, null);
//            if (saslClient == null) {
//                throw new MongoSecurityException(credential, String.format(Locale.US, "No platform support for %s mechanism",
//                        AuthenticationMechanism.GSSAPI));
//            }
//
//            return saslClient;
//        } catch (SaslException e) {
//            throw new MongoSecurityException(credential, "Exception initializing SASL client", e);
//        } catch (GSSException e) {
//            throw new MongoSecurityException(credential, "Exception initializing GSSAPI credentials", e);
//        } catch (UnknownHostException e) {
//            throw new MongoSecurityException(credential, "Unable to canonicalize host name + " + serverAddress);
//        }
//    }
//
//    private GSSCredential getGSSCredential(final String userName) throws GSSException {
//        if (null != subject) {
//            return Subject.doAs(subject, new PrivilegedAction<GSSCredential>() {
//                @Override
//                public GSSCredential run() {
//                    return internalGetGSSCredential(userName);
//                }
//            });
//
//        } else {
//            return internalGetGSSCredential(userName);
//        }
//    }
//    private GSSCredential internalGetGSSCredential(final String userName) {
//        try {
//            Oid krb5Mechanism = new Oid(GSSAPI_OID);
//            GSSManager manager = GSSManager.getInstance();
//            GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
//            return manager.createCredential(name, GSSCredential.INDEFINITE_LIFETIME, krb5Mechanism,
//                    GSSCredential.INITIATE_ONLY);
//        } catch (GSSException e) {
//            throw new MongoException("Exception initializing GSSAPI credentials", e);
//        }
//
//    }
//
//    private String getHostName(final ServerAddress serverAddress) throws UnknownHostException {
//        return getCredential().getMechanismProperty(CANONICALIZE_HOST_NAME_KEY, CANONICALIZE_HOST_NAME_DEFAULT_VALUE)
//                       ? InetAddress.getByName(serverAddress.getHost()).getCanonicalHostName()
//                       : serverAddress.getHost();
//    }
//}
