/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.CursorType;
import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoQueryException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncSingleConnectionReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.SingleConnectionReadBinding;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;

public class FindOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String FIRST_BATCH = "firstBatch";
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private int batchSize;
    private int limit;
    private BsonDocument modifiers;
    private BsonDocument projection;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private int skip;
    private BsonDocument sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean slaveOk;
    private boolean oplogReplay;
    private boolean noCursorTimeout;
    private boolean partial;
    private ReadConcern readConcern = ReadConcern.DEFAULT;
    private Collation collation;
    private static final Map<String, String> META_OPERATOR_TO_COMMAND_FIELD_MAP = new HashMap<String, String>();

    public FindOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOperation<T> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public BsonDocument getModifiers() {
        return this.modifiers;
    }

    public FindOperation<T> modifiers(BsonDocument modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOperation<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOperation<T> skip(int skip) {
        this.skip = skip;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOperation<T> cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public FindOperation<T> slaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public FindOperation<T> oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOperation<T> noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOperation<T> partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public FindOperation<T> readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource source, Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                    try {
                        OperationHelper.validateReadConcernAndCollation(connection, FindOperation.this.readConcern, FindOperation.this.collation);
                        return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, FindOperation.this.namespace.getDatabaseName(), FindOperation.this.wrapInExplainIfNecessary(FindOperation.this.getCommand()), CommandResultDocumentCodec.create(FindOperation.this.decoder, FindOperation.FIRST_BATCH), connection, FindOperation.this.transformer(source, connection));
                    }
                    catch (MongoCommandException e) {
                        throw new MongoQueryException(e.getServerAddress(), e.getErrorCode(), e.getErrorMessage());
                    }
                }
                OperationHelper.validateReadConcernAndCollation(connection, FindOperation.this.readConcern, FindOperation.this.collation);
                QueryResult queryResult = connection.query(FindOperation.this.namespace, FindOperation.this.asDocument(connection.getDescription(), binding.getReadPreference()), FindOperation.this.projection, FindOperation.this.skip, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.isSlaveOk() || binding.getReadPreference().isSlaveOk(), FindOperation.this.isTailableCursor(), FindOperation.this.isAwaitData(), FindOperation.this.isNoCursorTimeout(), FindOperation.this.isPartial(), FindOperation.this.isOplogReplay(), FindOperation.this.decoder);
                return new QueryBatchCursor(queryResult, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, source, connection);
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

            @Override
            public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(FindOperation.exceptionTransformingCallback(errHandlingCallback), source, connection);
                    OperationHelper.validateReadConcernAndCollation(source, connection, FindOperation.this.readConcern, FindOperation.this.collation, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(AsyncConnectionSource source, AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, FindOperation.this.namespace.getDatabaseName(), FindOperation.this.wrapInExplainIfNecessary(FindOperation.this.getCommand()), CommandResultDocumentCodec.create(FindOperation.this.decoder, FindOperation.FIRST_BATCH), connection, FindOperation.this.asyncTransformer(source, connection), wrappedCallback);
                            }
                        }
                    });
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, source, connection);
                    OperationHelper.validateReadConcernAndCollation(source, connection, FindOperation.this.readConcern, FindOperation.this.collation, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                        @Override
                        public void call(final AsyncConnectionSource source, final AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                connection.queryAsync(FindOperation.this.namespace, FindOperation.this.asDocument(connection.getDescription(), binding.getReadPreference()), FindOperation.this.projection, FindOperation.this.skip, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.isSlaveOk() || binding.getReadPreference().isSlaveOk(), FindOperation.this.isTailableCursor(), FindOperation.this.isAwaitData(), FindOperation.this.isNoCursorTimeout(), FindOperation.this.isPartial(), FindOperation.this.isOplogReplay(), FindOperation.this.decoder, new SingleResultCallback<QueryResult<T>>(){

                                    @Override
                                    public void onResult(QueryResult<T> result, Throwable t) {
                                        if (t != null) {
                                            wrappedCallback.onResult(null, t);
                                        } else {
                                            wrappedCallback.onResult(new AsyncQueryBatchCursor(result, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, source, connection), null);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private static <T> SingleResultCallback<T> exceptionTransformingCallback(final SingleResultCallback<T> callback) {
        return new SingleResultCallback<T>(){

            @Override
            public void onResult(T result, Throwable t) {
                if (t != null) {
                    if (t instanceof MongoCommandException) {
                        MongoCommandException commandException = (MongoCommandException)t;
                        callback.onResult(result, new MongoQueryException(commandException.getServerAddress(), commandException.getErrorCode(), commandException.getErrorMessage()));
                    } else {
                        callback.onResult(result, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }
        };
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        Assertions.notNull("explainVerbosity", explainVerbosity);
        return new ReadOperation<BsonDocument>(){

            @Override
            public BsonDocument execute(final ReadBinding binding) {
                return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BsonDocument>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public BsonDocument call(ConnectionSource connectionSource, Connection connection) {
                        SingleConnectionReadBinding singleConnectionBinding = new SingleConnectionReadBinding(binding.getReadPreference(), connectionSource.getServerDescription(), connection);
                        if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                            try {
                                BsonDocument bsonDocument = (BsonDocument)new CommandReadOperation(FindOperation.this.getNamespace().getDatabaseName(), new BsonDocument("explain", (BsonValue)FindOperation.this.getCommand()), new BsonDocumentCodec()).execute(singleConnectionBinding);
                                return bsonDocument;
                            }
                            catch (MongoCommandException e) {
                                throw new MongoQueryException(e.getServerAddress(), e.getErrorCode(), e.getErrorMessage());
                            }
                        }
                        Object cursor = FindOperation.this.createExplainableQueryOperation().execute(singleConnectionBinding);
                        try {
                            BsonDocument bsonDocument = (BsonDocument)cursor.next().iterator().next();
                            cursor.close();
                            return bsonDocument;
                        }
                        catch (Throwable throwable) {
                            cursor.close();
                            throw throwable;
                        }
                        finally {
                            singleConnectionBinding.release();
                        }
                    }
                });
            }
        };
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        Assertions.notNull("explainVerbosity", explainVerbosity);
        return new AsyncReadOperation<BsonDocument>(){

            @Override
            public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<BsonDocument> callback) {
                OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnectionAndSource(){

                    @Override
                    public void call(AsyncConnectionSource connectionSource, AsyncConnection connection, Throwable t) {
                        SingleResultCallback<BsonDocument> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                        if (t != null) {
                            errHandlingCallback.onResult(null, t);
                        } else {
                            AsyncSingleConnectionReadBinding singleConnectionReadBinding = new AsyncSingleConnectionReadBinding(binding.getReadPreference(), connectionSource.getServerDescription(), connection);
                            if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(connection.getDescription())) {
                                new CommandReadOperation(FindOperation.this.namespace.getDatabaseName(), new BsonDocument("explain", (BsonValue)FindOperation.this.getCommand()), new BsonDocumentCodec()).executeAsync(singleConnectionReadBinding, OperationHelper.releasingCallback(FindOperation.exceptionTransformingCallback(errHandlingCallback), singleConnectionReadBinding, connectionSource, connection));
                            } else {
                                FindOperation.this.createExplainableQueryOperation().executeAsync((AsyncReadBinding)singleConnectionReadBinding, OperationHelper.releasingCallback(new ExplainResultCallback(errHandlingCallback), singleConnectionReadBinding, connectionSource, connection));
                            }
                        }
                    }
                });
            }
        };
    }

    private FindOperation<BsonDocument> createExplainableQueryOperation() {
        FindOperation<T> explainFindOperation = new FindOperation<T>(this.namespace, new BsonDocumentCodec());
        BsonDocument explainModifiers = new BsonDocument();
        if (this.modifiers != null) {
            explainModifiers.putAll((Map)this.modifiers);
        }
        explainModifiers.append("$explain", (BsonValue)BsonBoolean.TRUE);
        return explainFindOperation.filter(this.filter).projection(this.projection).sort(this.sort).skip(this.skip).limit(Math.abs(this.limit) * -1).modifiers(explainModifiers);
    }

    private BsonDocument asDocument(ConnectionDescription connectionDescription, ReadPreference readPreference) {
        BsonDocument document = new BsonDocument();
        if (this.modifiers != null) {
            document.putAll((Map)this.modifiers);
        }
        if (this.sort != null) {
            document.put("$orderby", (BsonValue)this.sort);
        }
        if (this.maxTimeMS > 0L) {
            document.put("$maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        if (connectionDescription.getServerType() == ServerType.SHARD_ROUTER && !readPreference.equals(ReadPreference.primary())) {
            document.put("$readPreference", (BsonValue)readPreference.toDocument());
        }
        if (document.isEmpty()) {
            document = this.filter != null ? this.filter : new BsonDocument();
        } else if (this.filter != null) {
            document.put("$query", (BsonValue)this.filter);
        } else if (!document.containsKey((Object)"$query")) {
            document.put("$query", (BsonValue)new BsonDocument());
        }
        return document;
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("find", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        if (this.modifiers != null) {
            for (Map.Entry cur : this.modifiers.entrySet()) {
                String commandFieldName = META_OPERATOR_TO_COMMAND_FIELD_MAP.get(cur.getKey());
                if (commandFieldName == null) continue;
                commandDocument.append(commandFieldName, (BsonValue)cur.getValue());
            }
        }
        if (this.filter != null) {
            commandDocument.put("filter", (BsonValue)this.filter);
        }
        if (this.sort != null) {
            commandDocument.put("sort", (BsonValue)this.sort);
        }
        if (this.projection != null) {
            commandDocument.put("projection", (BsonValue)this.projection);
        }
        if (this.skip > 0) {
            commandDocument.put("skip", (BsonValue)new BsonInt32(this.skip));
        }
        if (this.limit != 0) {
            commandDocument.put("limit", (BsonValue)new BsonInt32(Math.abs(this.limit)));
        }
        if (this.limit >= 0) {
            if (this.batchSize < 0 && Math.abs(this.batchSize) < this.limit) {
                commandDocument.put("limit", (BsonValue)new BsonInt32(Math.abs(this.batchSize)));
            } else if (this.batchSize != 0) {
                commandDocument.put("batchSize", (BsonValue)new BsonInt32(Math.abs(this.batchSize)));
            }
        }
        if (this.limit < 0 || this.batchSize < 0) {
            commandDocument.put("singleBatch", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", (BsonValue)new BsonInt64(this.maxTimeMS));
        }
        if (this.isTailableCursor()) {
            commandDocument.put("tailable", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.isAwaitData()) {
            commandDocument.put("awaitData", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.oplogReplay) {
            commandDocument.put("oplogReplay", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.noCursorTimeout) {
            commandDocument.put("noCursorTimeout", (BsonValue)BsonBoolean.TRUE);
        }
        if (this.partial) {
            commandDocument.put("allowPartialResults", (BsonValue)BsonBoolean.TRUE);
        }
        if (!this.readConcern.isServerDefault()) {
            commandDocument.put("readConcern", (BsonValue)this.readConcern.asDocument());
        }
        if (this.collation != null) {
            commandDocument.put("collation", (BsonValue)this.collation.asDocument());
        }
        return commandDocument;
    }

    private BsonDocument wrapInExplainIfNecessary(BsonDocument commandDocument) {
        if (this.isExplain()) {
            return new BsonDocument("explain", (BsonValue)commandDocument);
        }
        return commandDocument;
    }

    private boolean isExplain() {
        return this.modifiers != null && this.modifiers.get((Object)"$explain", (BsonValue)BsonBoolean.FALSE).equals(BsonBoolean.TRUE);
    }

    private boolean isTailableCursor() {
        return this.cursorType.isTailable();
    }

    private boolean isAwaitData() {
        return this.cursorType == CursorType.TailableAwait;
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = FindOperation.this.documentToQueryResult(result, serverAddress);
                return new QueryBatchCursor(queryResult, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, source, connection);
            }
        };
    }

    private long getMaxTimeForCursor() {
        return this.cursorType == CursorType.TailableAwait ? this.maxAwaitTimeMS : 0L;
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnectionSource source, final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result, ServerAddress serverAddress) {
                QueryResult queryResult = FindOperation.this.documentToQueryResult(result, serverAddress);
                return new AsyncQueryBatchCursor(queryResult, FindOperation.this.limit, FindOperation.this.batchSize, FindOperation.this.getMaxTimeForCursor(), FindOperation.this.decoder, source, connection);
            }
        };
    }

    private QueryResult<T> documentToQueryResult(BsonDocument result, ServerAddress serverAddress) {
        QueryResult<Object> queryResult;
        if (this.isExplain()) {
            Object decodedDocument = this.decoder.decode((BsonReader)new BsonDocumentReader(result), DecoderContext.builder().build());
            queryResult = new QueryResult<Object>(this.getNamespace(), Collections.singletonList(decodedDocument), 0L, serverAddress);
        } else {
            queryResult = OperationHelper.cursorDocumentToQueryResult(result.getDocument((Object)"cursor"), serverAddress);
        }
        return queryResult;
    }

    static {
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$query", "filter");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$orderby", "sort");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$hint", "hint");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$comment", "comment");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$maxScan", "maxScan");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$maxTimeMS", "maxTimeMS");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$max", "max");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$min", "min");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$returnKey", "returnKey");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$showDiskLoc", "showRecordId");
        META_OPERATOR_TO_COMMAND_FIELD_MAP.put("$snapshot", "snapshot");
    }

    private static class ExplainResultCallback
    implements SingleResultCallback<AsyncBatchCursor<BsonDocument>> {
        private final SingleResultCallback<BsonDocument> callback;

        public ExplainResultCallback(SingleResultCallback<BsonDocument> callback) {
            this.callback = callback;
        }

        @Override
        public void onResult(final AsyncBatchCursor<BsonDocument> cursor, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                cursor.next(new SingleResultCallback<List<BsonDocument>>(){

                    @Override
                    public void onResult(List<BsonDocument> result, Throwable t) {
                        cursor.close();
                        if (t != null) {
                            ExplainResultCallback.this.callback.onResult(null, t);
                        } else if (result == null || result.size() == 0) {
                            ExplainResultCallback.this.callback.onResult(null, new MongoInternalException("Expected explain result"));
                        } else {
                            ExplainResultCallback.this.callback.onResult(result.get(0), null);
                        }
                    }
                });
            }
        }
    }
}

