/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.asm;

import org.nutz.repo.org.objectweb.asm.MethodVisitor;
import org.nutz.repo.org.objectweb.asm.Opcodes;
import org.nutz.repo.org.objectweb.asm.Type;

final class AsmHelper
implements Opcodes {
    private static final String ORG_NUTZ_AOP_ASM_HELPER = "org/nutz/aop/asm/Helper";
    private static final String VALUE_OF = "valueOf";

    AsmHelper() {
    }

    static boolean packagePrivateData(Type type, MethodVisitor mv) {
        if (type.equals(Type.BOOLEAN_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Boolean", VALUE_OF, "(Z)Ljava/lang/Boolean;");
        } else if (type.equals(Type.BYTE_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Byte", VALUE_OF, "(B)Ljava/lang/Byte;");
        } else if (type.equals(Type.CHAR_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Character", VALUE_OF, "(C)Ljava/lang/Character;");
        } else if (type.equals(Type.SHORT_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Short", VALUE_OF, "(S)Ljava/lang/Short;");
        } else if (type.equals(Type.INT_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Integer", VALUE_OF, "(I)Ljava/lang/Integer;");
        } else if (type.equals(Type.LONG_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Long", VALUE_OF, "(J)Ljava/lang/Long;");
        } else if (type.equals(Type.FLOAT_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Float", VALUE_OF, "(F)Ljava/lang/Float;");
        } else if (type.equals(Type.DOUBLE_TYPE)) {
            mv.visitMethodInsn(184, "java/lang/Double", VALUE_OF, "(D)Ljava/lang/Double;");
        } else {
            return false;
        }
        return true;
    }

    static void unpackagePrivateData(Type type, MethodVisitor mv) {
        if (type.equals(Type.BOOLEAN_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Boolean;)Z");
        } else if (type.equals(Type.BYTE_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Byte;)B");
        } else if (type.equals(Type.CHAR_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Character;)C");
        } else if (type.equals(Type.SHORT_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Short;)S");
        } else if (type.equals(Type.INT_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Integer;)I");
        } else if (type.equals(Type.LONG_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Long;)J");
        } else if (type.equals(Type.FLOAT_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Float;)F");
        } else if (type.equals(Type.DOUBLE_TYPE)) {
            mv.visitMethodInsn(184, ORG_NUTZ_AOP_ASM_HELPER, VALUE_OF, "(Ljava/lang/Double;)D");
        }
    }

    static void checkCast(Type type, MethodVisitor mv) {
        if (type.getSort() == 9) {
            mv.visitTypeInsn(192, type.getDescriptor());
            return;
        }
        if (!type.equals(Type.getType(Object.class))) {
            if (type.getOpcode(172) != 176) {
                AsmHelper.checkCast2(type, mv);
                AsmHelper.unpackagePrivateData(type, mv);
            } else {
                mv.visitTypeInsn(192, type.getClassName().replace('.', '/'));
            }
        }
    }

    static void checkCast2(Type type, MethodVisitor mv) {
        if (type.equals(Type.BOOLEAN_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Boolean");
        } else if (type.equals(Type.BYTE_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Byte");
        } else if (type.equals(Type.CHAR_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Character");
        } else if (type.equals(Type.SHORT_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Short");
        } else if (type.equals(Type.INT_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Integer");
        } else if (type.equals(Type.LONG_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Long");
        } else if (type.equals(Type.FLOAT_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Float");
        } else if (type.equals(Type.DOUBLE_TYPE)) {
            mv.visitTypeInsn(192, "java/lang/Double");
        }
    }
}

