/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.nutz.dao.ConnCallback;
import org.nutz.dao.Dao;
import org.nutz.dao.DaoException;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.sql.run.NutDaoRunner;
import org.nutz.lang.random.R;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class NutTxDao
extends NutDao
implements Closeable {
    private static final Log log = Logs.get();
    protected Connection conn;
    protected String id;
    protected Savepoint sp;
    protected boolean debug;
    protected boolean _autoCommit;
    protected NutMap sps;

    public NutTxDao(Dao _dao) throws DaoException {
        NutDao dao = (NutDao)_dao;
        this.meta = dao.meta;
        this.sqlManager = dao.sqlManager;
        this.dataSource = dao.dataSource;
        this.executor = dao.executor;
        this.dataSource = dao.dataSource;
        this.expert = dao.expert;
        this.pojoMaker = dao.pojoMaker;
        this.holder = dao.holder;
        this.autoTransLevel = dao.autoTransLevel;
        this._interceptors = dao._interceptors;
        this.setRunner(new NutDaoRunner(){

            @Override
            public void _run(DataSource dataSource, ConnCallback callback) {
                try {
                    this.runCallback(NutTxDao.this.getConnection(), callback);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new DaoException(e);
                }
            }
        });
    }

    public NutTxDao beginRC() {
        return this.begin(2);
    }

    public NutTxDao beginSE() {
        return this.begin(8);
    }

    public NutTxDao begin(int transLevel) throws DaoException {
        if (this.conn != null) {
            throw new DaoException("NutTxDao has been begined!!");
        }
        this.id = R.UU32();
        if (this.debug) {
            log.debugf("begin level=%d id=%s", transLevel, this.id);
        }
        try {
            this.conn = this.dataSource.getConnection();
            this.conn.setTransactionIsolation(transLevel);
            if (this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(false);
                this._autoCommit = true;
            }
            this.setSavepoint(this.id);
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        return this;
    }

    public NutTxDao commit() {
        if (this.debug) {
            log.debugf("commit id=%s", this.id);
        }
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        return this;
    }

    public NutTxDao rollback() {
        return this.rollback(this.id);
    }

    public NutTxDao rollback(String id) {
        if (this.debug) {
            log.debugf("rollback id=%s", id);
        }
        try {
            Savepoint sp = null;
            if (this.id.equals(id)) {
                sp = this.sp;
            } else if (this.sps != null) {
                sp = this.sps.getAs(id, Savepoint.class);
            }
            if (sp != null) {
                this.conn.rollback(sp);
            } else {
                log.debug("Null Savepoint found, skip, id=" + id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    public NutTxDao setSavepoint(String spId) {
        try {
            Savepoint sp = this.conn.setSavepoint(spId);
            if (this.id.equals(spId)) {
                this.sp = sp;
            } else {
                if (this.sps == null) {
                    this.sps = new NutMap();
                }
                this.sps.put(spId, sp);
            }
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
        return this;
    }

    @Override
    public void close() {
        if (this.debug) {
            log.debugf("close id=%s", this.id);
        }
        try {
            if (this.conn == null) {
                return;
            }
            if (this._autoCommit) {
                this.conn.setAutoCommit(true);
            }
            this.conn.close();
            this.conn = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getId() {
        return this.id;
    }

    public NutTxDao setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

