/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.ext;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import org.nutz.aop.DefaultClassDefiner;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.asm.AsmClassAgent;
import org.nutz.aop.matcher.MethodMatcherFactory;
import org.nutz.dao.Dao;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.AnnotationEntityMaker;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.ioc.aop.config.InterceptorPair;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.BornContext;
import org.nutz.lang.born.Borns;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class LazyAnnotationEntityMaker
extends AnnotationEntityMaker {
    private static final Log log = Logs.get();
    private Dao dao;

    public LazyAnnotationEntityMaker(DataSource datasource, JdbcExpert expert, EntityHolder holder, Dao dao) {
        super(datasource, expert, holder);
        this.dao = dao;
    }

    @Override
    protected <T> NutEntity<T> _createNutEntity(Class<T> type) {
        return new LazyNutEntity<T>(type);
    }

    @Override
    public <T> Entity<T> make(Class<T> type) {
        LazyNutEntity en = (LazyNutEntity)super.make(type);
        en.init();
        return en;
    }

    static enum LazyStatus {
        CAN_FETCH,
        FETCHED,
        NO_NEED;

    }

    class LazyMethodInterceptor
    implements MethodInterceptor {
        private WeakHashMap<Object, LazyStatus> status = new WeakHashMap();
        private Method setter;
        private String fieldName;

        public LazyMethodInterceptor(Method setter, String fieldName) {
            this.setter = setter;
            this.fieldName = fieldName;
        }

        @Override
        public void filter(InterceptorChain chain) throws Throwable {
            LazyStatus stat = this.status.get(chain.getCallingObj());
            if (stat == null) {
                if (!chain.getCallingMethod().equals(this.setter)) {
                    LazyAnnotationEntityMaker.this.dao.fetchLinks(chain.getCallingObj(), this.fieldName);
                }
                this.status.put(chain.getCallingObj(), LazyStatus.NO_NEED);
            }
            chain.doChain();
        }
    }

    class LazyNutEntity<T>
    extends NutEntity<T> {
        public LazyNutEntity(Class<T> type) {
            super(type);
        }

        public void init() {
            ArrayList<LinkField> lfs = new ArrayList<LinkField>();
            lfs.addAll(this.ones.getAll());
            lfs.addAll(this.manys.getAll());
            lfs.addAll(this.manymanys.getAll());
            if (lfs.isEmpty()) {
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Found links , enable lazy!! -->" + this.type);
            }
            Mirror<Class> mirror = Mirror.me(this.type);
            ArrayList<InterceptorPair> interceptorPairs = new ArrayList<InterceptorPair>();
            for (LinkField linkField : lfs) {
                String fieldName = linkField.getName();
                try {
                    Method setter = mirror.getSetter(mirror.getField(fieldName));
                    LazyMethodInterceptor lmi = new LazyMethodInterceptor(setter, fieldName);
                    interceptorPairs.add(new InterceptorPair(lmi, MethodMatcherFactory.matcher("^(get|set)" + Strings.upperFirst(fieldName) + "$")));
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Not setter found for LazyLoading ?!", e);
                }
            }
            AsmClassAgent agent = new AsmClassAgent();
            for (InterceptorPair interceptorPair : interceptorPairs) {
                agent.addInterceptor(interceptorPair.getMethodMatcher(), interceptorPair.getMethodInterceptor());
            }
            Class clazz = agent.define(DefaultClassDefiner.defaultOne(), this.type);
            BornContext bc = Borns.evalByArgTypes(this.type, ResultSet.class);
            if (null == bc) {
                this.bornByDefault = Mirror.me(clazz).getBorningByArgTypes(new Class[0]);
            } else {
                this.bornByRS = bc.getBorning();
            }
        }
    }
}

