/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.pager;

import java.io.Serializable;
import org.nutz.lang.util.PageInfo;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Pager
implements PageInfo,
Serializable {
    private static final long serialVersionUID = 8848523495013555357L;
    private static final Log log = Logs.get();
    public static int DEFAULT_PAGE_SIZE = 20;
    public static int MAX_FETCH_SIZE = 200;
    private int pageNumber;
    private int pageSize;
    private int pageCount;
    private int recordCount;

    public Pager() {
        this.pageNumber = 1;
        this.pageSize = DEFAULT_PAGE_SIZE;
    }

    public Pager(int pageNumber, int pageSize) {
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        if (pageSize < 1) {
            pageSize = DEFAULT_PAGE_SIZE;
        }
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public Pager resetPageCount() {
        this.pageCount = -1;
        return this;
    }

    @Override
    public int getPageCount() {
        if (this.pageCount < 0) {
            this.pageCount = (int)Math.ceil((double)this.recordCount / (double)this.pageSize);
        }
        return this.pageCount;
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    public Pager setPageNumber(int pn) {
        if (1 > pn && log.isInfoEnabled()) {
            log.infof("PageNumber shall start at 1, but input is %d, that mean pager is disable", pn);
        }
        this.pageNumber = pn;
        return this;
    }

    @Override
    public Pager setPageSize(int pageSize) {
        this.pageSize = pageSize > 0 ? pageSize : DEFAULT_PAGE_SIZE;
        return this.resetPageCount();
    }

    @Override
    public Pager setRecordCount(int recordCount) {
        this.recordCount = recordCount > 0 ? recordCount : 0;
        this.pageCount = (int)Math.ceil((double)recordCount / (double)this.pageSize);
        return this;
    }

    @Override
    public int getOffset() {
        return this.pageSize * (this.pageNumber - 1);
    }

    public String toString() {
        return String.format("size: %d, total: %d, page: %d/%d", this.pageSize, this.recordCount, this.pageNumber, this.getPageCount());
    }

    @Override
    public boolean isFirst() {
        return this.pageNumber == 1;
    }

    @Override
    public boolean isLast() {
        if (this.pageCount == 0) {
            return true;
        }
        return this.pageNumber == this.pageCount;
    }

    @Override
    public boolean hasNext() {
        return !this.isLast();
    }

    @Override
    public boolean hasPrevious() {
        return !this.isFirst();
    }
}

