/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.pager;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.nutz.dao.DaoException;
import org.nutz.dao.pager.LoopScope;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.SqlContext;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public abstract class ResultSetLooping {
    private static Log log = Logs.get();
    public static int WARN_BIG_SIZE = -1;
    public static int ERROR_BIG_SIZE = -1;
    public static String KEY_WARN_SIZE = "sql-result-size-warn";
    public static String KEY_ERROR_SIZE = "sql-result-size-error";
    protected List<Object> list = new LinkedList<Object>();
    private int index = -1;

    public void doLoop(ResultSet rs, SqlContext context) throws SQLException {
        block12: {
            boolean errorBigResult;
            boolean warnBigResult;
            int errorSize;
            int warnSize;
            Pager pager;
            block11: {
                pager = context.getPager();
                if (null == rs) {
                    return;
                }
                warnSize = context.attr(KEY_WARN_SIZE) == null ? WARN_BIG_SIZE : ((Number)context.attr(KEY_WARN_SIZE)).intValue();
                errorSize = context.attr(KEY_ERROR_SIZE) == null ? ERROR_BIG_SIZE : ((Number)context.attr(KEY_ERROR_SIZE)).intValue();
                warnBigResult = log.isWarnEnabled() && warnSize > 0;
                boolean bl = errorBigResult = errorSize > 0;
                if (null != pager && 1003 != rs.getType() && pager.getPageNumber() > 0) break block11;
                while (rs.next()) {
                    this.createObject(++this.index, rs, context, -1);
                    if (warnBigResult && this.index > warnSize) {
                        warnBigResult = false;
                        this.warnBig(rs, context, this.index, warnSize);
                    }
                    if (!errorBigResult || this.index <= errorSize) continue;
                    errorBigResult = false;
                    this.errorBig(rs, context, this.index, errorSize);
                }
                break block12;
            }
            if (!rs.last()) break block12;
            if (pager.getPageSize() <= 0) {
                rs.setFetchSize(Pager.DEFAULT_PAGE_SIZE);
            } else if (pager.getPageSize() > Pager.MAX_FETCH_SIZE) {
                rs.setFetchSize(Pager.MAX_FETCH_SIZE);
            } else {
                rs.setFetchSize(pager.getPageSize());
            }
            int rowCount = rs.getRow();
            LoopScope ls = LoopScope.eval(pager, rowCount);
            if (rs.absolute(ls.start + 1)) {
                for (int i = ls.start; i < ls.max; ++i) {
                    this.createObject(++this.index, rs, context, rowCount);
                    if (rs.next()) {
                        if (warnBigResult && this.index > warnSize) {
                            warnBigResult = false;
                            this.warnBig(rs, context, this.index, warnSize);
                        }
                        if (!errorBigResult || this.index <= errorSize) continue;
                        errorBigResult = false;
                        this.errorBig(rs, context, this.index, errorSize);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public List<Object> getList() {
        return this.list;
    }

    public int getIndex() {
        return this.index;
    }

    protected abstract boolean createObject(int var1, ResultSet var2, SqlContext var3, int var4);

    protected void warnBig(ResultSet rs, SqlContext ctx, int index, int warnSize) {
        log.warnf("BIG Result, pager=%s", ctx.getPager());
    }

    protected void errorBig(ResultSet rs, SqlContext ctx, int index, int errorSize) {
        throw new DaoException("result size bigger than limit=" + errorSize);
    }
}

