/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.util.cri;

import java.util.Collection;
import org.nutz.castor.Castors;
import org.nutz.dao.util.cri.BetweenExpression;
import org.nutz.dao.util.cri.IntRange;
import org.nutz.dao.util.cri.IsNull;
import org.nutz.dao.util.cri.Like;
import org.nutz.dao.util.cri.LongRange;
import org.nutz.dao.util.cri.NameRange;
import org.nutz.dao.util.cri.SimpleExpression;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.dao.util.cri.SqlRange;
import org.nutz.dao.util.cri.Static;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;

public abstract class Exps {
    public static SqlExpressionGroup begin() {
        return new SqlExpressionGroup();
    }

    public static Like like(String name, String value) {
        return Like.create(name, value, true);
    }

    public static Like like(String name, String value, boolean ignoreCase) {
        return Like.create(name, value, ignoreCase);
    }

    public static IsNull isNull(String name) {
        return new IsNull(name);
    }

    public static SimpleExpression eq(String name, Object val) {
        return new SimpleExpression(name, "=", val);
    }

    public static SimpleExpression gt(String name, long val) {
        return new SimpleExpression(name, ">", val);
    }

    public static SimpleExpression lt(String name, long val) {
        return new SimpleExpression(name, "<", val);
    }

    public static SimpleExpression gte(String name, long val) {
        return new SimpleExpression(name, ">=", val);
    }

    public static SimpleExpression lte(String name, long val) {
        return new SimpleExpression(name, "<=", val);
    }

    public static IntRange inInt(String name, int ... ids) {
        return new IntRange(name, ids);
    }

    public static LongRange inLong(String name, long ... ids) {
        return new LongRange(name, ids);
    }

    public static NameRange inStr(String name, String ... names) {
        return new NameRange(name, names);
    }

    public static SqlRange inSql(String name, String subSql, Object ... args) {
        return new SqlRange(name, subSql, args);
    }

    public static SqlExpression create(String name, String op, Object value) {
        op = Strings.trim(op.toUpperCase());
        if (null == value) {
            if (!("=".equals(op) || "IS".equals(op) || "NOT IS".equals(op) || "IS NOT".equals(op))) {
                throw Lang.makeThrow("null can only use 'IS' or 'NOT IS'", new Object[0]);
            }
            IsNull re = Exps.isNull(name);
            return re.setNot(op.startsWith("NOT") || op.endsWith("NOT"));
        }
        if ("IN".equals(op) || "NOT IN".equals(op)) {
            SqlExpression re;
            Class<?> type = value.getClass();
            int len = Lang.length(value);
            if (len < 1) {
                re = new Static("1 != 1");
            } else if (type.isArray()) {
                re = Exps._evalRange(Mirror.me(type.getComponentType()), name, value);
            } else if (Collection.class.isAssignableFrom(type)) {
                Object first = Lang.first(value);
                if (null == first) {
                    return null;
                }
                re = Exps._evalRange(Mirror.me(first), name, value);
            } else {
                re = Exps.inSql(name, value.toString(), new Object[0]);
            }
            return re.setNot(op.startsWith("NOT"));
        }
        if ("LIKE".equals(op) || "NOT LIKE".equals(op)) {
            Like re;
            String v = value.toString();
            if (v.length() == 1) {
                re = Exps.like(name, v);
            } else {
                re = Exps.like(name, v.substring(1, v.length() - 1));
                re.left(v.substring(0, 1));
                re.right(v.substring(v.length() - 1, v.length()));
            }
            return re.ignoreCase(false).setNot(op.startsWith("NOT"));
        }
        if ("=".equals(op)) {
            return Exps.eq(name, value);
        }
        if ("!=".equals(op) || "<>".equals(op)) {
            return Exps.eq(name, value).setNot(true);
        }
        if ("BETWEEN".equals(op)) {
            Object[] values = (Object[])value;
            return new BetweenExpression(name, values[0], values[1]);
        }
        return new SimpleExpression(name, op, value);
    }

    private static SqlExpression _evalRange(Mirror<?> mirror, String name, Object value) {
        if (mirror.isInt()) {
            return Exps.inInt(name, Castors.me().castTo(value, int[].class));
        }
        if (mirror.isLong()) {
            return Exps.inLong(name, Castors.me().castTo(value, long[].class));
        }
        return Exps.inStr(name, Castors.me().castTo(value, String[].class));
    }
}

