/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.arithmetic;

import java.util.LinkedList;
import java.util.Queue;
import org.nutz.el.ElCache;
import org.nutz.el.Operator;
import org.nutz.el.obj.Elobj;
import org.nutz.lang.util.Context;

public class RPN {
    private final ElCache ec = new ElCache();
    private LinkedList<Object> el;

    public RPN() {
    }

    public RPN(Queue<Object> rpn) {
        this.compile(rpn);
    }

    public Object calculate(Context context) {
        this.ec.setContext(context);
        return this.calculate(this.el);
    }

    public Object calculate(Context context, Queue<Object> rpn) {
        this.ec.setContext(context);
        LinkedList<Object> operand = this.OperatorTree(rpn);
        return this.calculate(operand);
    }

    private Object calculate(LinkedList<Object> el2) {
        if (el2.peek() instanceof Operator) {
            Operator obj = (Operator)el2.peek();
            return obj.calculate();
        }
        if (el2.peek() instanceof Elobj) {
            return ((Elobj)el2.peek()).fetchVal();
        }
        return el2.peek();
    }

    public void compile(Queue<Object> rpn) {
        this.el = this.OperatorTree(rpn);
    }

    private LinkedList<Object> OperatorTree(Queue<Object> rpn) {
        LinkedList<Object> operand = new LinkedList<Object>();
        while (!rpn.isEmpty()) {
            if (rpn.peek() instanceof Operator) {
                Operator opt = (Operator)rpn.poll();
                opt.wrap(operand);
                operand.addFirst(opt);
                continue;
            }
            if (rpn.peek() instanceof Elobj) {
                ((Elobj)rpn.peek()).setEc(this.ec);
            }
            operand.addFirst(rpn.poll());
        }
        return operand;
    }
}

