/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.el.opt.custom;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.nutz.el.opt.RunMethod;
import org.nutz.plugin.Plugin;

public class DoURLEncoder
implements RunMethod,
Plugin {
    @Override
    public boolean canWork() {
        return true;
    }

    @Override
    public Object run(List<Object> fetchParam) {
        if (fetchParam.isEmpty()) {
            throw new IllegalArgumentException("need args!!");
        }
        Object val = fetchParam.get(0);
        if (val == null) {
            return "";
        }
        Object enc = null;
        if (fetchParam.size() > 1) {
            enc = fetchParam.get(1);
        }
        if (enc == null) {
            enc = "UTF-8";
        }
        try {
            return URLEncoder.encode(val.toString(), enc.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("can't do urlencode[" + val + "]", e);
        }
    }

    @Override
    public String fetchSelf() {
        return "urlencode";
    }
}

