/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http.sender;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.nutz.http.HttpException;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.http.Sender;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;

public class PostSender
extends Sender {
    public PostSender(Request request) {
        super(request);
    }

    @Override
    public Response send() throws HttpException {
        try {
            this.openConnection();
            InputStream ins = this.request.getInputStream();
            this.setupRequestHeader();
            if (ins != null && this.request.getHeader() != null && ins instanceof ByteArrayInputStream && this.request.getHeader().get("Content-Length") == null) {
                this.conn.addRequestProperty("Content-Length", "" + ins.available());
            }
            this.setupDoInputOutputFlag();
            if (null != ins) {
                BufferedOutputStream ops = Streams.buff(this.getOutputStream());
                Streams.write((OutputStream)ops, ins);
                Streams.safeClose(ins);
                Streams.safeFlush(ops);
                Streams.safeClose(ops);
            }
            return this.createResponse(this.getResponseHeader());
        }
        catch (Exception e) {
            throw new HttpException(this.request.getUrl().toString(), e);
        }
    }

    @Override
    public int getEstimationSize() throws IOException {
        if (this.request.getInputStream() != null) {
            return this.request.getInputStream().available();
        }
        if (null != this.request.getData()) {
            return this.request.getData().length;
        }
        try {
            return this.request.getURLEncodedParams().getBytes(this.request.getEnc()).length;
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow(e);
        }
    }
}

