/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.impl;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.JsonException;
import org.nutz.json.impl.JsonToken;
import org.nutz.lang.Lang;
import org.nutz.lang.Nums;

final class JsonTokenScan {
    Reader reader;
    JsonToken token = new JsonToken();
    JsonToken nextToken = null;
    JsonToken nextToken2 = new JsonToken();
    static final Object END = new Object();
    static final Object COMMA = new Object();
    int row = 1;
    int col = 0;
    static final int MapStart = 123;
    static final int MapEnd = 125;
    static final int ListStart = 91;
    static final int ListEnd = 93;
    static final int MapPair = 58;
    static final int SimpleString = 0;
    static final int OtherString = 1;
    static final int Comma = 44;

    public JsonTokenScan(Reader reader) {
        this.reader = reader;
    }

    protected void _nextToken() {
        switch (this.token.type) {
            case 44: 
            case 58: 
            case 91: 
            case 93: 
            case 123: 
            case 125: {
                return;
            }
            case 39: {
                this.token.type = 0;
                this.token.value = this.readString('\'');
                return;
            }
            case 34: {
                this.token.type = 0;
                this.token.value = this.readString('\"');
                return;
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                char c = '\u0000';
                block15: while (true) {
                    c = this.nextChar();
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            continue block15;
                        }
                    }
                    break;
                }
                this.token.type = c;
                this._nextToken();
                return;
            }
            case 47: {
                this.skipComment();
                this.nextToken();
                return;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append((char)this.token.type);
        block16: while (true) {
            char c = this.nextChar();
            switch (c) {
                case ',': 
                case ':': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.nextToken = this.nextToken2;
                    this.nextToken.type = c;
                    break block16;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break block16;
                }
                case '/': {
                    this.skipComment();
                    break block16;
                }
                default: {
                    sb.append(c);
                    continue block16;
                }
            }
            break;
        }
        this.token.type = 1;
        this.token.value = sb.toString();
    }

    protected void nextToken() {
        if (this.nextToken != null) {
            this.token.type = this.nextToken.type;
            this.token.value = this.nextToken.value;
            this.nextToken = null;
            return;
        }
        this.token.type = this.nextChar();
        this._nextToken();
    }

    protected void skipComment() {
        char c = this.nextChar();
        switch (c) {
            case '/': {
                while (this.nextChar() != '\n') {
                }
                return;
            }
            case '*': {
                char c2 = c;
                while (true) {
                    if ((c = this.nextChar()) != '/') {
                        c2 = c;
                        continue;
                    }
                    if (c2 == '*') break;
                }
                return;
            }
        }
        throw this.unexpectChar(c);
    }

    protected String readString(char endEnd) {
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        while ((c = this.nextChar()) != endEnd) {
            switch (c) {
                case '\\': {
                    c = this.parseSp();
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected Map<String, Object> readMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        boolean hasComma = false;
        block5: while (true) {
            this.nextToken();
            switch (this.token.type) {
                case 125: {
                    break block5;
                }
                case 0: 
                case 1: {
                    String key = this.token.value;
                    this.nextToken();
                    if (this.token.type != 58) {
                        throw this.unexpectChar((char)this.token.type);
                    }
                    Object obj = this.readObject(125);
                    if (obj == COMMA) {
                        if (hasComma) {
                            throw this.unexpectChar(',');
                        }
                        hasComma = true;
                        continue block5;
                    }
                    if (obj == END) {
                        throw this.unexpectChar((char)this.token.type);
                    }
                    map.put(key, obj);
                    hasComma = false;
                    continue block5;
                }
                case 44: {
                    continue block5;
                }
                default: {
                    throw this.unexpectChar((char)this.token.type);
                }
            }
            break;
        }
        return map;
    }

    protected List<Object> readList() {
        Object obj;
        ArrayList<Object> list = new ArrayList<Object>();
        boolean hasComma = false;
        while ((obj = this.readObject(93)) != END) {
            if (obj == COMMA) {
                if (hasComma) {
                    throw this.unexpectChar(',');
                }
                hasComma = true;
                continue;
            }
            list.add(obj);
            hasComma = false;
        }
        return list;
    }

    protected Object readObject(int endTag) {
        this.nextToken();
        switch (this.token.type) {
            case 123: {
                return this.readMap();
            }
            case 91: {
                return this.readList();
            }
            case 0: {
                return this.token.value;
            }
            case 1: {
                String value = this.token.value;
                int len = value.length();
                if (len == 0) {
                    return "";
                }
                switch (value.charAt(0)) {
                    case 't': {
                        if (!"true".equals(value)) break;
                        return true;
                    }
                    case 'f': {
                        if (!"false".equals(value)) break;
                        return false;
                    }
                    case 'n': {
                        if (!"null".endsWith(value)) break;
                        return null;
                    }
                    case 'u': {
                        if (!"undefined".endsWith(value)) break;
                        return null;
                    }
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        if (this.token.value.length() > 0) {
                            switch (this.token.value.charAt(this.token.value.length() - 1)) {
                                case 'L': 
                                case 'l': {
                                    return Long.parseLong(this.token.value.substring(0, this.token.value.length() - 1));
                                }
                                case 'F': 
                                case 'f': {
                                    return Float.valueOf(Float.parseFloat(this.token.value.substring(0, this.token.value.length() - 1)));
                                }
                            }
                            if (this.token.value.contains("e") || this.token.value.contains("E")) {
                                return new BigDecimal(this.token.value);
                            }
                            if (this.token.value.contains(".")) {
                                return Double.parseDouble(this.token.value);
                            }
                        }
                        Nums.Radix r = Nums.evalRadix(this.token.value);
                        long n = Long.parseLong(r.val, r.radix);
                        if (Integer.MAX_VALUE >= n && n >= Integer.MIN_VALUE) {
                            return (int)n;
                        }
                        return n;
                    }
                }
                throw new JsonException(this.row, this.col, value.charAt(0), "Unexpect String = " + value);
            }
        }
        if (this.token.type == endTag) {
            return END;
        }
        if (this.token.type == 44) {
            return COMMA;
        }
        throw this.unexpectChar((char)this.token.type);
    }

    public Object read() {
        int c = 0;
        boolean add = false;
        block11: while (true) {
            c = this.readChar();
            switch (c) {
                case -1: {
                    return null;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block11;
                }
                case 47: {
                    this.skipComment();
                    continue block11;
                }
            }
            break;
        }
        add = true;
        switch (c) {
            case 40: 
            case 118: {
                char z;
                do {
                    if ((z = this.nextChar()) != '{') continue;
                    return this.readMap();
                } while (z != '[');
                return this.readList();
            }
            case 123: {
                return this.readMap();
            }
            case 91: {
                return this.readList();
            }
            case 34: 
            case 39: {
                return this.readString((char)c);
            }
        }
        this.nextToken = this.nextToken2;
        this.nextToken.type = 1;
        this.nextToken.value = add ? (char)c + Lang.readAll(this.reader) : Lang.readAll(this.reader);
        return this.readObject(-1);
    }

    char nextChar() {
        int c = this.readChar();
        if (c == -1) {
            throw new JsonException("Unexpect EOF");
        }
        return (char)c;
    }

    protected char parseSp() {
        char c = this.nextChar();
        switch (c) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\\': {
                return '\\';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '/': {
                return '/';
            }
            case 'u': {
                char[] hex = new char[4];
                for (int i = 0; i < 4; ++i) {
                    hex[i] = this.nextChar();
                }
                return (char)Integer.valueOf(new String(hex), 16).intValue();
            }
            case 'b': {
                return ' ';
            }
            case 'v': {
                return ' ';
            }
            case 'f': {
                return '\f';
            }
        }
        throw this.unexpectChar(c);
    }

    private int readChar() {
        try {
            int c = this.reader.read();
            switch (c) {
                case -1: {
                    break;
                }
                case 10: {
                    ++this.row;
                    this.col = 0;
                    break;
                }
                default: {
                    ++this.col;
                }
            }
            return c;
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    protected JsonException unexpectChar(char c) {
        return new JsonException(this.row, this.col, c, "Unexpect Char");
    }
}

