/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.util;

import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.IntRange;

public class IntSet {
    private char l;
    private char r;
    private IntRange ir;

    public static IntSet make(String s) {
        if (s.length() < 3) {
            throw Lang.makeThrow("Invalid IntSet : '%s'", s);
        }
        s = Strings.trim(s);
        char l = s.charAt(0);
        char r = s.charAt(s.length() - 1);
        IntRange ir = IntRange.make(s.substring(1, s.length() - 1));
        return new IntSet(l, r, ir);
    }

    private IntSet(char l, char r, IntRange ir) {
        this.l = l;
        this.r = r;
        this.ir = ir;
    }

    public boolean match(int n) {
        if (this.l == '[' && this.r == ']') {
            return this.ir.inon(n);
        }
        if (this.l == '(' && this.r == ')') {
            return this.ir.in(n);
        }
        if (this.l == '[') {
            return this.ir.linon(n);
        }
        return this.ir.rinon(n);
    }

    public String toString() {
        return this.l + this.ir.toString() + this.r;
    }
}

