/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Context;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionHandler;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutFilter2;
import org.nutz.mvc.SessionProvider;
import org.nutz.mvc.config.FilterNutConfig;

public class NutFilter
implements Filter {
    protected static Log log;
    protected ActionHandler handler;
    protected static final String IGNORE = "^.+\\.(jsp|png|gif|jpg|js|css|jspx|jpeg|swf|ico|map)$";
    protected Pattern ignorePtn;
    protected String selfName;
    protected SessionProvider sp;
    private NutFilter2 proxyFilter;
    protected Pattern exclusionsPrefix;
    protected Pattern exclusionsSuffix;
    protected Set<String> exclusionPaths;
    protected ServletContext sc;

    public void init(FilterConfig conf) throws ServletException {
        try {
            this._init(conf);
        }
        finally {
            Mvcs.set(null, null, null);
            Mvcs.ctx().removeReqCtx();
        }
    }

    public void _init(FilterConfig conf) throws ServletException {
        String exclusions;
        log = Logs.getLog(this.getClass());
        this.sc = conf.getServletContext();
        Mvcs.setServletContext(this.sc);
        if ("true".equals(Strings.sNull(conf.getInitParameter("skip-mode"), "false").toLowerCase())) {
            log.infof("NutFilter[%s] run as skip-mode", conf.getFilterName());
            this.proxyFilter = new NutFilter2();
            return;
        }
        log.infof("NutFilter[%s] starting ...", conf.getFilterName());
        this.selfName = conf.getFilterName();
        Mvcs.set(this.selfName, null, null);
        FilterNutConfig config = new FilterNutConfig(conf);
        Mvcs.setNutConfig(config);
        this.handler = new ActionHandler(config);
        String regx = Strings.sNull(config.getInitParameter("ignore"), IGNORE);
        if (!"null".equalsIgnoreCase(regx)) {
            this.ignorePtn = Pattern.compile(regx, 2);
        }
        if ((exclusions = config.getInitParameter("exclusions")) != null) {
            String[] tmps = Strings.splitIgnoreBlank(exclusions);
            HashSet<String> prefix = new HashSet<String>();
            HashSet<String> suffix = new HashSet<String>();
            HashSet<String> paths = new HashSet<String>();
            for (String tmp : tmps) {
                if ((tmp = tmp.trim().intern()).length() > 1) {
                    if (tmp.startsWith("*")) {
                        suffix.add(tmp.substring(1));
                        continue;
                    }
                    if (tmp.endsWith("*")) {
                        prefix.add(tmp.substring(0, tmp.length() - 1));
                        continue;
                    }
                }
                paths.add(tmp);
            }
            if (prefix.size() > 0) {
                this.exclusionsPrefix = Pattern.compile("^(" + Lang.concat((Object)"|", prefix) + ")", 2);
                log.info("exclusionsPrefix  = " + this.exclusionsPrefix);
            }
            if (suffix.size() > 0) {
                this.exclusionsSuffix = Pattern.compile("(" + Lang.concat((Object)"|", suffix) + ")$", 2);
                log.info("exclusionsSuffix = " + this.exclusionsSuffix);
            }
            if (paths.size() > 0) {
                this.exclusionPaths = paths;
                log.info("exclusionsPath   = " + this.exclusionPaths);
            }
        }
        this.sp = config.getSessionProvider();
    }

    public void destroy() {
        if (this.proxyFilter != null) {
            return;
        }
        Mvcs.resetALL();
        Mvcs.set(this.selfName, null, null);
        if (this.handler != null) {
            this.handler.depose();
        }
        Mvcs.close();
        Mvcs.setServletContext(null);
        Mvcs.set(null, null, null);
        Mvcs.ctx().removeReqCtx();
    }

    protected boolean isExclusion(String matchUrl) throws IOException, ServletException {
        if (this.ignorePtn != null && this.ignorePtn.matcher(matchUrl).find()) {
            return true;
        }
        if (this.exclusionsSuffix != null && this.exclusionsSuffix.matcher(matchUrl).find()) {
            return true;
        }
        if (this.exclusionsPrefix != null && this.exclusionsPrefix.matcher(matchUrl).find()) {
            return true;
        }
        return this.exclusionPaths != null && this.exclusionPaths.contains(matchUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        if (!Mvcs.DISABLE_X_POWERED_BY) {
            ((HttpServletResponse)resp).setHeader("X-Powered-By", Mvcs.X_POWERED_BY);
        }
        ServletContext prCtx = Mvcs.getServletContext();
        Mvcs.setServletContext(this.sc);
        if (this.proxyFilter != null) {
            this.proxyFilter.doFilter(req, resp, chain);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String matchUrl = request.getServletPath() + Strings.sBlank(request.getPathInfo());
        String markKey = "nutz_ctx_mark";
        Integer mark = (Integer)req.getAttribute(markKey);
        if (mark != null) {
            req.setAttribute(markKey, (Object)(mark + 1));
        } else {
            req.setAttribute(markKey, (Object)0);
        }
        String preName = Mvcs.getName();
        Context preContext = Mvcs.resetALL();
        try {
            if (this.sp != null) {
                request = this.sp.filter(request, response, Mvcs.getServletContext());
            }
            Mvcs.set(this.selfName, request, response);
            if (!this.isExclusion(matchUrl) && this.handler.handle(request, response)) {
                return;
            }
            this.nextChain(request, response, chain);
        }
        finally {
            if (mark != null) {
                Mvcs.ctx().reqCtx(preContext);
                Mvcs.setServletContext(prCtx);
                Mvcs.set(preName, request, response);
                if (mark == 0) {
                    req.removeAttribute(markKey);
                } else {
                    req.setAttribute(markKey, (Object)(mark - 1));
                }
            } else {
                Mvcs.set(null, null, null);
                Mvcs.ctx().removeReqCtx();
                Mvcs.setServletContext(null);
            }
        }
    }

    protected void nextChain(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Mvcs.updateRequestAttributes(req);
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
    }
}

