/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.view;

import org.nutz.ioc.Ioc;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.mvc.View;
import org.nutz.mvc.ViewMaker;
import org.nutz.mvc.view.ForwardView;
import org.nutz.mvc.view.HttpStatusView;
import org.nutz.mvc.view.JspView;
import org.nutz.mvc.view.RawView;
import org.nutz.mvc.view.ServerRedirectView;
import org.nutz.mvc.view.UTF8JsonView;
import org.nutz.mvc.view.VoidView;

public class DefaultViewMaker
implements ViewMaker {
    public static final String VIEW_JSP = "jsp";
    public static final String VIEW_JSON = "json";
    public static final String VIEW_JSONP = "jsonp";
    public static final String VIEW_REDIRECT = "redirect";
    public static final String VIEW_REDIRECT2 = ">>";
    public static final String VIEW_VOID = "void";
    public static final String VIEW_IOC = "ioc";
    public static final String VIEW_HTTP = "http";
    public static final String VIEW_FORWARD = "forward";
    public static final String VIEW_FORWARD2 = "->";
    public static final String VIEW_RAW = "raw";

    @Override
    public View make(Ioc ioc, String type, String value) {
        if (VIEW_JSP.equals(type = type.toLowerCase())) {
            return new JspView(value);
        }
        if (VIEW_JSON.equals(type) || VIEW_JSONP.equals(type)) {
            if (Strings.isBlank(value)) {
                return VIEW_JSONP.equals(type) ? UTF8JsonView.JSONP : UTF8JsonView.COMPACT;
            }
            if (value.charAt(0) == '{') {
                return new UTF8JsonView(Json.fromJson(JsonFormat.class, (CharSequence)value)).setJsonp(VIEW_JSONP.equals(type));
            }
            if ("nice".equals(value)) {
                return new UTF8JsonView(JsonFormat.nice()).setJsonp(VIEW_JSONP.equals(type));
            }
            if ("forlook".equals(value)) {
                return new UTF8JsonView(JsonFormat.forLook()).setJsonp(VIEW_JSONP.equals(type));
            }
            if ("full".equals(value)) {
                return new UTF8JsonView(JsonFormat.full()).setJsonp(VIEW_JSONP.equals(type));
            }
            if ("compact".equals(value)) {
                return new UTF8JsonView(JsonFormat.compact()).setJsonp(VIEW_JSONP.equals(type));
            }
            if ("tidy".equals(value)) {
                return new UTF8JsonView(JsonFormat.tidy()).setJsonp(VIEW_JSONP.equals(type));
            }
            throw new IllegalArgumentException("unkown json view format : " + value);
        }
        if (VIEW_REDIRECT.equals(type) || VIEW_REDIRECT2.equals(type)) {
            return new ServerRedirectView(value);
        }
        if (VIEW_FORWARD.equals(type) || VIEW_FORWARD2.equals(type)) {
            return new ForwardView(value);
        }
        if (VIEW_VOID.equals(type)) {
            return new VoidView();
        }
        if (VIEW_IOC.equals(type)) {
            return ioc.get(View.class, value);
        }
        if (VIEW_HTTP.equals(type)) {
            String val = Strings.sBlank(value, "500");
            try {
                return new HttpStatusView(Integer.parseInt(val));
            }
            catch (NumberFormatException e) {
                return new HttpStatusView(Lang.map(val));
            }
        }
        if (VIEW_RAW.equals(type)) {
            return new RawView(value);
        }
        return null;
    }
}

