/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.repo.org.objectweb.asm;

import org.nutz.repo.org.objectweb.asm.ByteVector;
import org.nutz.repo.org.objectweb.asm.ClassWriter;
import org.nutz.repo.org.objectweb.asm.Label;

public class Attribute {
    public final String type;
    public byte[] value;
    Attribute next;

    public Attribute(String type) {
        this.type = type;
    }

    public boolean isUnknown() {
        return true;
    }

    public boolean isCodeAttribute() {
        return false;
    }

    protected Label[] getLabels() {
        return null;
    }

    protected ByteVector write(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        ByteVector v = new ByteVector();
        v.data = this.value;
        v.length = this.value.length;
        return v;
    }

    final int getCount() {
        int count = 0;
        Attribute attr = this;
        while (attr != null) {
            ++count;
            attr = attr.next;
        }
        return count;
    }

    final int getSize(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals) {
        Attribute attr = this;
        int size = 0;
        while (attr != null) {
            cw.newUTF8(attr.type);
            size += attr.write((ClassWriter)cw, (byte[])code, (int)len, (int)maxStack, (int)maxLocals).length + 6;
            attr = attr.next;
        }
        return size;
    }

    final void put(ClassWriter cw, byte[] code, int len, int maxStack, int maxLocals, ByteVector out) {
        Attribute attr = this;
        while (attr != null) {
            ByteVector b = attr.write(cw, code, len, maxStack, maxLocals);
            out.putShort(cw.newUTF8(attr.type)).putInt(b.length);
            out.putByteArray(b.data, 0, b.length);
            attr = attr.next;
        }
    }
}

