/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.nutz.resource.impl.ResourceLocation;

public class JarResourceLocation
extends ResourceLocation {
    private static final Log log = Logs.get();
    private List<String> names = new ArrayList<String>();
    private String jarPath;

    @Override
    public String id() {
        return this.jarPath;
    }

    @Override
    public void scan(String base, Pattern regex, List<NutResource> list) {
        for (String ensName : this.names) {
            String name = ensName;
            if (name.contains("/")) {
                name = name.substring(name.lastIndexOf(47) + 1);
            }
            if (!ensName.startsWith(base) || null != regex && !regex.matcher(name).find()) continue;
            try {
                list.add(Scans.makeJarNutResource(this.jarPath, ensName, base));
            }
            catch (IOException e) {
                if (!log.isInfoEnabled()) continue;
                log.info("Jar delete while scan?!! " + this.jarPath, e);
            }
        }
    }

    public String toString() {
        return "Jar[path=" + this.jarPath + "]";
    }

    public JarResourceLocation(String jarPath) throws IOException {
        this.jarPath = ResourceLocation.getJarPath(jarPath);
        ZipInputStream zis = null;
        try {
            zis = Scans.makeZipInputStream(jarPath);
            ZipEntry ens = null;
            while (null != (ens = zis.getNextEntry())) {
                if (ens.isDirectory()) continue;
                this.names.add(ens.getName());
            }
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(e);
        }
        finally {
            Streams.safeClose(zis);
        }
    }
}

