/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.EnumSet;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractFSharpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsharpFunctionsServerCodegen
extends AbstractFSharpCodegen {
    public static final String PROJECT_NAME = "projectName";
    static Logger LOGGER = LoggerFactory.getLogger(FsharpFunctionsServerCodegen.class);

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "fsharp-functions";
    }

    @Override
    public String getHelp() {
        return "Generates a fsharp-functions server (beta).";
    }

    public FsharpFunctionsServerCodegen() {
        this.featureSet = this.getFeatureSet().modify().wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.BasePath, GlobalFeature.Host}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).build();
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.addOption("licenseUrl", "The URL of the license", this.licenseUrl);
        this.addOption("licenseName", "The name of the license", this.licenseName);
        this.addOption("packageCopyright", "Specifies an AssemblyCopyright for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageCopyright);
        this.addOption("packageAuthors", "Specifies Authors property in the .NET Core project file.", this.packageAuthors);
        this.addOption("packageTitle", "Specifies an AssemblyTitle for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageTitle);
        this.addOption("packageName", "F# module name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "F# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modelPackage = "Model";
        this.templateDir = "fsharp-functions-server";
        this.embeddedTemplateDir = "fsharp-functions-server";
        this.apiTemplateFiles.put("Handler.mustache", "Handler.fs");
        this.apiTemplateFiles.put("HandlerParams.mustache", "HandlerParams.fs");
        this.apiTemplateFiles.put("ServiceInterface.mustache", "ServiceInterface.fs");
        this.apiTemplateFiles.put("ServiceImpl.mustache", "Service.fs");
        this.modelTemplateFiles.put("Model.mustache", ".fs");
        String implFolder = this.sourceFolder + File.separator + "impl";
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", this.projectFolder, "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", this.projectFolder, "build.bat"));
        this.supportingFiles.add(new SupportingFile("host.json", "", "host.json"));
        this.supportingFiles.add(new SupportingFile("local.settings.json", "", "local.settings.json"));
        this.supportingFiles.add(new SupportingFile("Project.fsproj.mustache", this.projectFolder, this.packageName + ".fsproj"));
    }

    @Override
    public String modelFileFolder() {
        return super.modelFileFolder().replace("Model", "model");
    }

    @Override
    public String apiFileFolder() {
        return super.apiFileFolder() + File.separator + "api";
    }

    private String implFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + "impl";
    }

    @Override
    public String toModelImport(String name) {
        return this.packageName + "." + this.modelPackage() + "." + name;
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = result.lastIndexOf(File.separatorChar);
            result = result.substring(0, ix) + result.substring(ix, result.length() - 2) + "fs";
            result = result.replace(this.apiFileFolder(), this.implFileFolder());
        }
        return result;
    }
}

