/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaskellServantCodegen
extends DefaultCodegen
implements CodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HaskellServantCodegen.class);
    protected String sourceFolder = "src";
    protected String apiVersion = "0.0.1";
    private static final Pattern LEADING_UNDERSCORE = Pattern.compile("^_+");
    public static final String PROP_SERVE_STATIC = "serveStatic";
    public static final String PROP_SERVE_STATIC_DESC = "serve will serve files from the directory 'static'.";
    public static final Boolean PROP_SERVE_STATIC_DEFAULT = Boolean.TRUE;

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "haskell";
    }

    @Override
    public String getHelp() {
        return "Generates a Haskell server and client library.";
    }

    public HaskellServantCodegen() {
        this.featureSet = this.getFeatureSet().modify().includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).build();
        this.specialCharReplacements.put("-", "Dash");
        this.specialCharReplacements.put(">", "GreaterThan");
        this.specialCharReplacements.put("<", "LessThan");
        this.specialCharReplacements.remove("\\");
        this.specialCharReplacements.remove("\"");
        this.specialCharReplacements.put("\\\\", "Back_Slash");
        this.specialCharReplacements.put("\\\"", "Double_Quote");
        this.outputFolder = "generated-code/haskell-servant";
        this.templateDir = "haskell-servant";
        this.embeddedTemplateDir = "haskell-servant";
        this.apiPackage = "API";
        this.modelPackage = "Types";
        this.setReservedWordsLowerCase(Arrays.asList("as", "case", "of", "class", "data", "family", "default", "deriving", "do", "forall", "foreign", "hiding", "if", "then", "else", "import", "infix", "infixl", "infixr", "instance", "let", "in", "mdo", "module", "newtype", "proc", "qualified", "rec", "type", "where"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("stack.mustache", "", "stack.yaml"));
        this.supportingFiles.add(new SupportingFile("Setup.mustache", "", "Setup.hs"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Bool", "String", "Int", "Integer", "Float", "Char", "Double", "List", "FilePath"));
        this.typeMapping.clear();
        this.typeMapping.put("array", "List");
        this.typeMapping.put("set", "Set");
        this.typeMapping.put("boolean", "Bool");
        this.typeMapping.put("string", "Text");
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Int");
        this.typeMapping.put("char", "Char");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("DateTime", "UTCTime");
        this.typeMapping.put("Date", "Day");
        this.typeMapping.put("file", "FilePath");
        this.typeMapping.put("binary", "FilePath");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("BigDecimal", "Double");
        this.typeMapping.put("any", "Value");
        this.typeMapping.put("UUID", "UUID");
        this.typeMapping.put("URI", "Text");
        this.typeMapping.put("ByteArray", "Text");
        this.typeMapping.put("object", "Value");
        this.importMapping.clear();
        this.importMapping.put("Map", "qualified Data.Map as Map");
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(PROP_SERVE_STATIC, PROP_SERVE_STATIC_DESC).defaultValue(PROP_SERVE_STATIC_DEFAULT.toString()));
    }

    public void setBooleanProperty(String property, Boolean defaultValue) {
        if (this.additionalProperties.containsKey(property)) {
            this.additionalProperties.put(property, this.convertPropertyToBoolean(property));
        } else {
            this.additionalProperties.put(property, defaultValue);
        }
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("HASKELL_POST_PROCESS_FILE"))) {
            LOGGER.info("Hint: Environment variable HASKELL_POST_PROCESS_FILE not defined so the Haskell code may not be properly formatted. To define it, try 'export HASKELL_POST_PROCESS_FILE=\"$HOME/.local/bin/hfmt -w\"' (Linux/Mac)");
        }
        this.setBooleanProperty(PROP_SERVE_STATIC, PROP_SERVE_STATIC_DEFAULT);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    public String firstLetterToUpper(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toUpperCase(Locale.ROOT);
        }
        return word.substring(0, 1).toUpperCase(Locale.ROOT) + word.substring(1);
    }

    public String firstLetterToLower(String word) {
        if (word.length() == 0) {
            return word;
        }
        if (word.length() == 1) {
            return word.substring(0, 1).toLowerCase(Locale.ROOT);
        }
        return word.substring(0, 1).toLowerCase(Locale.ROOT) + word.substring(1);
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String title = openAPI.getInfo().getTitle();
        if (title == null) {
            title = "OpenAPI";
        } else if ((title = title.trim()).toUpperCase(Locale.ROOT).endsWith("API")) {
            title = title.substring(0, title.length() - 3);
        }
        String[] words = title.split(" ");
        ArrayList<String> wordsLower = new ArrayList<String>();
        for (String word : words) {
            wordsLower.add(word.toLowerCase(Locale.ROOT));
        }
        String cabalName = this.joinStrings("-", wordsLower);
        ArrayList<String> wordsCaps = new ArrayList<String>();
        for (String word : words) {
            wordsCaps.add(this.firstLetterToUpper(word));
        }
        String apiName = this.joinStrings("", wordsCaps);
        this.supportingFiles.add(new SupportingFile("haskell-servant-codegen.mustache", "", cabalName + ".cabal"));
        this.supportingFiles.add(new SupportingFile("API.mustache", "lib/" + apiName, "API.hs"));
        this.supportingFiles.add(new SupportingFile("Types.mustache", "lib/" + apiName, "Types.hs"));
        this.additionalProperties.put("title", apiName);
        this.additionalProperties.put("titleLower", this.firstLetterToLower(apiName));
        this.additionalProperties.put("package", cabalName);
        this.additionalProperties.put("contextStackLimit", openAPI.getPaths().size() * 2 + 300);
        ArrayList replacements = new ArrayList();
        Object[] replacementChars = this.specialCharReplacements.keySet().toArray();
        for (int i = 0; i < replacementChars.length; ++i) {
            String c = (String)replacementChars[i];
            HashMap<String, Object> o = new HashMap<String, Object>();
            o.put("char", c);
            o.put("replacement", "'" + (String)this.specialCharReplacements.get(c));
            o.put("hasMore", i != replacementChars.length - 1);
            replacements.add(o);
        }
        this.additionalProperties.put("specialCharReplacements", replacements);
        this.additionalProperties.put("generateToSchema", true);
        super.preprocessOpenAPI(openAPI);
    }

    private void setGenerateToSchema(CodegenModel model) {
        for (CodegenProperty var : model.vars) {
            if (var.dataType.contentEquals("Value") || var.dataType.contains(" Value")) {
                this.additionalProperties.put("generateToSchema", false);
            }
            if (var.items == null || !var.items.dataType.contentEquals("Value") && !var.dataType.contains(" Value")) continue;
            this.additionalProperties.put("generateToSchema", false);
        }
        List<CodegenModel> children = model.getChildren();
        if (children != null) {
            for (CodegenModel child : children) {
                this.setGenerateToSchema(child);
            }
        }
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return "(Map.Map String " + this.getTypeDeclaration(inner) + ")";
        }
        return this.fixModelChars(super.getTypeDeclaration(p));
    }

    @Override
    public String getSchemaType(Schema p) {
        String schemaType = super.getSchemaType(p);
        LOGGER.debug("debugging OpenAPI type: " + p.getType() + ", " + p.getFormat() + " => " + schemaType);
        String type = null;
        if (this.typeMapping.containsKey(schemaType)) {
            type = (String)this.typeMapping.get(schemaType);
            return type;
        }
        type = this.typeMapping.containsValue(schemaType) ? schemaType + "_" : schemaType;
        return this.toModelName(type);
    }

    @Override
    public String toInstantiationType(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            Schema additionalProperties2 = ModelUtils.getAdditionalProperties(p);
            String type = additionalProperties2.getType();
            if (null == type) {
                LOGGER.error("No Type defined for Additional Property " + additionalProperties2 + "\n\tIn Property: " + p);
            }
            String inner = this.getSchemaType(additionalProperties2);
            return "(Map.Map Text " + inner + ")";
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            String inner = this.getSchemaType(ap.getItems());
            return inner;
        }
        return null;
    }

    private String joinStrings(String sep, List<String> ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private List<String> pathToServantRoute(String path, List<CodegenParameter> pathParams) {
        HashMap<String, String> captureTypes = new HashMap<String, String>();
        for (CodegenParameter param : pathParams) {
            captureTypes.put(param.baseName, param.dataType);
        }
        if (path.contentEquals("/")) {
            return new ArrayList<String>();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> pathComponents = new ArrayList<String>();
        for (String piece : path.split("/")) {
            if (piece.startsWith("{") && piece.endsWith("}")) {
                String name = piece.substring(1, piece.length() - 1);
                pathComponents.add("Capture \"" + name + "\" " + (String)captureTypes.get(name));
                continue;
            }
            pathComponents.add("\"" + piece + "\"");
        }
        return pathComponents;
    }

    private List<String> pathToClientType(String path, List<CodegenParameter> pathParams) {
        HashMap<String, String> captureTypes = new HashMap<String, String>();
        for (CodegenParameter param : pathParams) {
            captureTypes.put(param.baseName, param.dataType);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        ArrayList<String> type = new ArrayList<String>();
        for (String piece : path.split("/")) {
            if (!piece.startsWith("{") || !piece.endsWith("}")) continue;
            String name = piece.substring(1, piece.length() - 1);
            type.add((String)captureTypes.get(name));
        }
        return type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CodegenOperation fromOperation(String resourcePath, String httpMethod, Operation operation, List<Server> servers) {
        void var9_19;
        void var9_17;
        CodegenOperation op = super.fromOperation(resourcePath, httpMethod, operation, servers);
        List<String> path = this.pathToServantRoute(op.path, op.pathParams);
        List<String> type = this.pathToClientType(op.path, op.pathParams);
        for (CodegenParameter codegenParameter : op.queryParams) {
            String paramType = codegenParameter.dataType;
            if (codegenParameter.isListContainer) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.collectionFormat)) {
                    codegenParameter.collectionFormat = "csv";
                }
                paramType = this.makeQueryListType(paramType, codegenParameter.collectionFormat);
            }
            path.add("QueryParam \"" + codegenParameter.baseName + "\" " + paramType);
            type.add("Maybe " + codegenParameter.dataType);
        }
        String bodyType = null;
        if (op.getHasBodyParam()) {
            for (CodegenParameter param : op.bodyParams) {
                path.add("ReqBody '[JSON] " + param.dataType);
                bodyType = param.dataType;
            }
        } else if (op.getHasFormParams()) {
            String string;
            bodyType = string = "Form" + StringUtils.camelize(op.operationId);
            path.add("ReqBody '[FormUrlEncoded] " + string);
        }
        if (bodyType != null) {
            type.add(bodyType);
        }
        for (CodegenParameter param : op.headerParams) {
            path.add("Header \"" + param.baseName + "\" " + param.dataType);
            String paramType = param.dataType;
            if (param.isListContainer) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.collectionFormat)) {
                    param.collectionFormat = "csv";
                }
                paramType = this.makeQueryListType(paramType, param.collectionFormat);
            }
            type.add("Maybe " + paramType);
        }
        for (CodegenParameter param : op.formParams) {
            param.vendorExtensions.put("x-formParamName", StringUtils.camelize(param.baseName));
        }
        String string = op.returnType;
        if (string == null || string.equals("null")) {
            String string2 = "()";
        }
        if (var9_17.indexOf(" ") >= 0) {
            String string3 = "(" + (String)var9_17 + ")";
        }
        path.add("Verb '" + op.httpMethod.toUpperCase(Locale.ROOT) + " 200 '[JSON] " + (String)var9_19);
        type.add("m " + (String)var9_19);
        op.vendorExtensions.put("x-routeType", this.joinStrings(" :> ", path));
        op.vendorExtensions.put("x-clientType", this.joinStrings(" -> ", type));
        op.vendorExtensions.put("x-formName", "Form" + StringUtils.camelize(op.operationId));
        for (CodegenParameter param : op.formParams) {
            param.vendorExtensions.put("x-formPrefix", StringUtils.camelize(op.operationId, true));
        }
        return op;
    }

    private String makeQueryListType(String type, String collectionFormat) {
        type = type.substring(1, type.length() - 1);
        switch (collectionFormat) {
            case "csv": {
                return "(QueryList 'CommaSeparated (" + type + "))";
            }
            case "tsv": {
                return "(QueryList 'TabSeparated (" + type + "))";
            }
            case "space": 
            case "ssv": {
                return "(QueryList 'SpaceSeparated (" + type + "))";
            }
            case "pipes": {
                return "(QueryList 'PipeSeparated (" + type + "))";
            }
            case "multi": {
                return "(QueryList 'MultiParamArray (" + type + "))";
            }
        }
        throw new UnsupportedOperationException(collectionFormat + " (collection format) not supported");
    }

    private String fixOperatorChars(String string) {
        StringBuilder sb = new StringBuilder();
        String name = string;
        if (string.startsWith("_")) {
            if (this.reservedWords.contains(string.substring(1, string.length()))) {
                name = string.substring(1, string.length());
            } else if (this.reservedWordsMappings.containsValue(string)) {
                name = LEADING_UNDERSCORE.matcher(string).replaceFirst("");
            }
        }
        for (char c : name.toCharArray()) {
            String cString = String.valueOf(c);
            if (this.specialCharReplacements.containsKey(cString)) {
                sb.append("'");
                sb.append((String)this.specialCharReplacements.get(cString));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private String fixModelChars(String string) {
        return string.replace(".", "").replace("-", "");
    }

    @Override
    public CodegenModel fromModel(String name, Schema mod) {
        CodegenModel model = super.fromModel(name, mod);
        this.setGenerateToSchema(model);
        model.classname = this.fixModelChars(model.classname);
        if (this.typeMapping.containsValue(model.classname)) {
            model.classname = model.classname + "_";
        }
        String prefix = StringUtils.camelize(model.classname, true);
        for (CodegenProperty prop : model.vars) {
            prop.name = this.toVarName(prefix + StringUtils.camelize(this.fixOperatorChars(prop.name)));
        }
        String dataOrNewtype = "data";
        if (!"object".equals(model.dataType) && this.typeMapping.containsKey(model.dataType)) {
            String newtype = (String)this.typeMapping.get(model.dataType);
            model.vendorExtensions.put("x-customNewtype", newtype);
        }
        model.vendorExtensions.put("x-prefix", prefix);
        model.vendorExtensions.put("x-data", dataOrNewtype);
        return model;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("{-", "{_-").replace("-}", "-_}");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String haskellPostProcessFile = System.getenv("HASKELL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)haskellPostProcessFile)) {
            return;
        }
        if ("hs".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = haskellPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }
}

