/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.features.CXFServerFeatures;
import org.openapitools.codegen.languages.features.GzipTestFeatures;
import org.openapitools.codegen.languages.features.LoggingTestFeatures;
import org.openapitools.codegen.languages.features.UseGenericResponseFeatures;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaCXFServerCodegen
extends AbstractJavaJAXRSServerCodegen
implements CXFServerFeatures,
GzipTestFeatures,
LoggingTestFeatures,
UseGenericResponseFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaCXFServerCodegen.class);
    protected boolean addConsumesProducesJson = true;
    protected boolean generateSpringApplication = false;
    protected boolean useSpringAnnotationConfig = false;
    protected boolean useSwaggerFeature = false;
    protected boolean useSwaggerUI = false;
    protected boolean useWadlFeature = false;
    protected boolean useMultipartFeature = false;
    protected boolean useBeanValidationFeature = false;
    protected boolean generateSpringBootApplication = false;
    protected boolean generateJbossDeploymentDescriptor = false;
    protected boolean useGzipFeature = false;
    protected boolean useGzipFeatureForTests = false;
    protected boolean useLoggingFeature = false;
    protected boolean useLoggingFeatureForTests = false;
    protected boolean useAnnotatedBasePath = false;
    protected boolean generateNonSpringApplication = false;
    protected boolean useGenericResponse = false;

    public JavaCXFServerCodegen() {
        this.supportsInheritance = true;
        this.useTags = true;
        this.artifactId = "openapi-cxf-server";
        this.outputFolder = "generated-code/JavaJaxRS-CXF";
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("useTags", String.valueOf(true));
        this.apiTemplateFiles.put("apiServiceImpl.mustache", ".java");
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.typeMapping.put("date", "LocalDate");
        this.importMapping.put("LocalDate", "org.joda.time.LocalDate");
        this.embeddedTemplateDir = this.templateDir = "JavaJaxRS" + File.separator + "cxf";
        this.cliOptions.add(CliOption.newBoolean("generateSpringApplication", "Generate Spring application"));
        this.cliOptions.add(CliOption.newBoolean("useSpringAnnotationConfig", "Use Spring Annotation Config"));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerFeature", "Use Swagger Feature"));
        this.cliOptions.add(CliOption.newBoolean("useSwaggerUI", "Use Swagger UI"));
        this.cliOptions.add(CliOption.newBoolean("useWadlFeature", "Use WADL Feature"));
        this.cliOptions.add(CliOption.newBoolean("useMultipartFeature", "Use Multipart Feature"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeature", "Use Gzip Feature"));
        this.cliOptions.add(CliOption.newBoolean("useGzipFeatureForTests", "Use Gzip Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidationFeature", "Use BeanValidation Feature"));
        this.cliOptions.add(CliOption.newBoolean("useLoggingFeature", "Use Logging Feature"));
        this.cliOptions.add(CliOption.newBoolean("useLoggingFeatureForTests", "Use Logging Feature for tests"));
        this.cliOptions.add(CliOption.newBoolean("generateSpringBootApplication", "Generate Spring Boot application"));
        this.cliOptions.add(CliOption.newBoolean("generateJbossDeploymentDescriptor", "Generate Jboss Deployment Descriptor"));
        this.cliOptions.add(CliOption.newBoolean("addConsumesProducesJson", "Add @Consumes/@Produces Json to API interface"));
        this.cliOptions.add(CliOption.newBoolean("useAnnotatedBasePath", "Use @Path annotations for basePath"));
        this.cliOptions.add(CliOption.newBoolean("generateNonSpringApplication", "Generate non-Spring application"));
        this.cliOptions.add(CliOption.newBoolean("useGenericResponse", "Use generic response"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("addConsumesProducesJson")) {
            this.setAddConsumesProducesJson(this.convertPropertyToBooleanAndWriteBack("addConsumesProducesJson"));
        }
        if (this.additionalProperties.containsKey("useGenericResponse")) {
            this.setUseGenericResponse(this.convertPropertyToBoolean("useGenericResponse"));
        }
        if (this.useGenericResponse) {
            this.writePropertyBack("useGenericResponse", this.useGenericResponse);
        }
        if (this.additionalProperties.containsKey("generateSpringApplication")) {
            this.setGenerateSpringApplication(this.convertPropertyToBooleanAndWriteBack("generateSpringApplication"));
            this.setUseSwaggerFeature(this.convertPropertyToBooleanAndWriteBack("useSwaggerFeature"));
            this.setUseSwaggerUI(this.convertPropertyToBooleanAndWriteBack("useSwaggerUI"));
            this.setUseWadlFeature(this.convertPropertyToBooleanAndWriteBack("useWadlFeature"));
            this.setUseMultipartFeature(this.convertPropertyToBooleanAndWriteBack("useMultipartFeature"));
            this.setUseGzipFeature(this.convertPropertyToBooleanAndWriteBack("useGzipFeature"));
            this.setUseGzipFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useGzipFeatureForTests"));
            this.setUseLoggingFeature(this.convertPropertyToBooleanAndWriteBack("useLoggingFeature"));
            this.setUseLoggingFeatureForTests(this.convertPropertyToBooleanAndWriteBack("useLoggingFeatureForTests"));
            this.setUseSpringAnnotationConfig(this.convertPropertyToBooleanAndWriteBack("useSpringAnnotationConfig"));
            boolean useBeanValidationFeature = this.convertPropertyToBooleanAndWriteBack("useBeanValidationFeature");
            this.setUseBeanValidationFeature(useBeanValidationFeature);
            if (useBeanValidationFeature) {
                LOGGER.info("make sure your target server supports Bean Validation 1.1");
            }
            this.setGenerateSpringBootApplication(this.convertPropertyToBooleanAndWriteBack("generateSpringBootApplication"));
        }
        if (this.additionalProperties.containsKey("generateJbossDeploymentDescriptor")) {
            boolean generateJbossDeploymentDescriptorProp = this.convertPropertyToBooleanAndWriteBack("generateJbossDeploymentDescriptor");
            this.setGenerateJbossDeploymentDescriptor(generateJbossDeploymentDescriptorProp);
        }
        if (this.additionalProperties.containsKey("useAnnotatedBasePath")) {
            boolean useAnnotatedBasePathProp = this.convertPropertyToBooleanAndWriteBack("useAnnotatedBasePath");
            this.setUseAnnotatedBasePath(useAnnotatedBasePathProp);
        }
        if (this.additionalProperties.containsKey("generateNonSpringApplication")) {
            boolean generateNonSpringApplication = this.convertPropertyToBooleanAndWriteBack("generateNonSpringApplication");
            this.setGenerateNonSpringApplication(generateNonSpringApplication);
        }
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("server/pom.mustache", "", "pom.xml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("server/openapi-generator-ignore.mustache", "", ".openapi-generator-ignore").doNotOverwrite());
        if (this.generateSpringApplication) {
            this.supportingFiles.add(new SupportingFile("server/readme.md", "", "readme.md").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("server/ApplicationContext.xml.mustache", "src/main/resources", "ApplicationContext.xml").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("server/web.mustache", "src/main/webapp/WEB-INF", "web.xml").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("server/context.xml.mustache", "src/main/webapp/WEB-INF", "context.xml").doNotOverwrite());
            if (this.generateJbossDeploymentDescriptor) {
                this.supportingFiles.add(new SupportingFile("server/jboss-web.xml.mustache", "src/main/webapp/WEB-INF", "jboss-web.xml").doNotOverwrite());
            }
            if (this.generateSpringBootApplication) {
                this.supportingFiles.add(new SupportingFile("server/SpringBootApplication.mustache", (this.testFolder + '/' + this.apiPackage).replace(".", "/"), "SpringBootApplication.java").doNotOverwrite());
                this.supportingFiles.add(new SupportingFile("server/application.properties.mustache", this.testResourcesFolder + '/', "application.properties").doNotOverwrite());
            }
        }
        if (this.generateNonSpringApplication) {
            this.supportingFiles.add(new SupportingFile("server/nonspring-web.mustache", "src/main/webapp/WEB-INF", "web.xml").doNotOverwrite());
        }
    }

    @Override
    public String getName() {
        return "jaxrs-cxf";
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
        model.imports.remove("JsonSerialize");
        model.imports.remove("ToStringSerializer");
    }

    @Override
    public String getHelp() {
        return "Generates a Java JAXRS Server application based on Apache CXF framework.";
    }

    @Override
    public void setGenerateSpringApplication(boolean generateSpringApplication) {
        this.generateSpringApplication = generateSpringApplication;
    }

    @Override
    public void setUseSpringAnnotationConfig(boolean useSpringAnnotationConfig) {
        this.useSpringAnnotationConfig = useSpringAnnotationConfig;
    }

    @Override
    public void setUseSwaggerFeature(boolean useSwaggerFeature) {
        this.useSwaggerFeature = useSwaggerFeature;
    }

    @Override
    public void setUseWadlFeature(boolean useWadlFeature) {
        this.useWadlFeature = useWadlFeature;
    }

    @Override
    public void setUseMultipartFeature(boolean useMultipartFeature) {
        this.useMultipartFeature = useMultipartFeature;
    }

    @Override
    public void setUseGzipFeature(boolean useGzipFeature) {
        this.useGzipFeature = useGzipFeature;
    }

    @Override
    public void setUseLoggingFeature(boolean useLoggingFeature) {
        this.useLoggingFeature = useLoggingFeature;
    }

    @Override
    public void setUseBeanValidationFeature(boolean useBeanValidationFeature) {
        this.useBeanValidationFeature = useBeanValidationFeature;
    }

    @Override
    public void setGenerateSpringBootApplication(boolean generateSpringBootApplication) {
        this.generateSpringBootApplication = generateSpringBootApplication;
    }

    @Override
    public void setGenerateJbossDeploymentDescriptor(boolean generateJbossDeploymentDescriptor) {
        this.generateJbossDeploymentDescriptor = generateJbossDeploymentDescriptor;
    }

    @Override
    public void setUseGzipFeatureForTests(boolean useGzipFeatureForTests) {
        this.useGzipFeatureForTests = useGzipFeatureForTests;
    }

    @Override
    public void setUseLoggingFeatureForTests(boolean useLoggingFeatureForTests) {
        this.useLoggingFeatureForTests = useLoggingFeatureForTests;
    }

    @Override
    public void setUseSwaggerUI(boolean useSwaggerUI) {
        this.useSwaggerUI = useSwaggerUI;
    }

    @Override
    public void setAddConsumesProducesJson(boolean addConsumesProducesJson) {
        this.addConsumesProducesJson = addConsumesProducesJson;
    }

    @Override
    public void setUseAnnotatedBasePath(boolean useAnnotatedBasePath) {
        this.useAnnotatedBasePath = useAnnotatedBasePath;
    }

    @Override
    public void setGenerateNonSpringApplication(boolean generateNonSpringApplication) {
        this.generateNonSpringApplication = generateNonSpringApplication;
    }

    @Override
    public void setUseGenericResponse(boolean useGenericResponse) {
        this.useGenericResponse = useGenericResponse;
    }
}

