/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNetCoreServerCodegen
extends AbstractCSharpCodegen {
    public static final String USE_SWASHBUCKLE = "useSwashbuckle";
    public static final String ASPNET_CORE_VERSION = "aspnetCoreVersion";
    public static final String SWASHBUCKLE_VERSION = "swashbuckleVersion";
    public static final String CLASS_MODIFIER = "classModifier";
    public static final String OPERATION_MODIFIER = "operationModifier";
    public static final String OPERATION_IS_ASYNC = "operationIsAsync";
    public static final String OPERATION_RESULT_TASK = "operationResultTask";
    public static final String GENERATE_BODY = "generateBody";
    public static final String BUILD_TARGET = "buildTarget";
    public static final String MODEL_CLASS_MODIFIER = "modelClassModifier";
    public static final String TARGET_FRAMEWORK = "targetFramework";
    public static final String PROJECT_SDK = "projectSdk";
    public static final String SDK_WEB = "Microsoft.NET.Sdk.Web";
    public static final String SDK_LIB = "Microsoft.NET.Sdk";
    public static final String COMPATIBILITY_VERSION = "compatibilityVersion";
    public static final String IS_LIBRARY = "isLibrary";
    public static final String USE_FRAMEWORK_REFERENCE = "useFrameworkReference";
    public static final String USE_NEWTONSOFT = "useNewtonsoft";
    public static final String USE_DEFAULT_ROUTING = "useDefaultRouting";
    public static final String NEWTONSOFT_VERSION = "newtonsoftVersion";
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    private String userSecretsGuid = UUID.randomUUID().toString();
    protected Logger LOGGER = LoggerFactory.getLogger(AspNetCoreServerCodegen.class);
    private boolean useSwashbuckle = true;
    protected int serverPort = 8080;
    protected String serverHost = "0.0.0.0";
    protected CliOption swashbuckleVersion = new CliOption("swashbuckleVersion", "Swashbuckle version: 3.0.0, 4.0.0, 5.0.0");
    protected CliOption aspnetCoreVersion = new CliOption("aspnetCoreVersion", "ASP.NET Core version: 5.0, 3.1, 3.0, 2.2, 2.1, 2.0 (deprecated)");
    private CliOption classModifier = new CliOption("classModifier", "Class Modifier for controller classes: Empty string or abstract.");
    private CliOption operationModifier = new CliOption("operationModifier", "Operation Modifier can be virtual or abstract");
    private CliOption modelClassModifier = new CliOption("modelClassModifier", "Model Class Modifier can be nothing or partial");
    private boolean generateBody = true;
    private CliOption buildTarget = new CliOption("buildTarget", "Target to build an application or library");
    private String projectSdk = "Microsoft.NET.Sdk.Web";
    private String compatibilityVersion = "Version_2_2";
    private boolean operationIsAsync = false;
    private boolean operationResultTask = false;
    private boolean isLibrary = false;
    private boolean useFrameworkReference = false;
    private boolean useNewtonsoft = true;
    private boolean useDefaultRouting = true;
    private String newtonsoftVersion = "3.0.0";

    public AspNetCoreServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.PROTOBUF}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.ApiKey, SecurityFeature.BasicAuth, SecurityFeature.BearerToken}).excludeSecurityFeatures(new SecurityFeature[]{SecurityFeature.OpenIDConnect, SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Implicit}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling, GlobalFeature.MultiServer}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        this.apiTemplateFiles.put("controller.mustache", ".cs");
        this.templateDir = "aspnetcore/3.0";
        this.embeddedTemplateDir = "aspnetcore/3.0";
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("long", "long");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("number", "decimal");
        this.typeMapping.put("DateTime", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("UUID", "Guid");
        this.typeMapping.put("URI", "string");
        this.setSupportNullable(Boolean.TRUE);
        this.addOption("packageDescription", "Specifies a AssemblyDescription for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageDescription);
        this.addOption("licenseUrl", "The URL of the license", this.licenseUrl);
        this.addOption("licenseName", "The name of the license", this.licenseName);
        this.addOption("packageCopyright", "Specifies an AssemblyCopyright for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageCopyright);
        this.addOption("packageAuthors", "Specifies Authors property in the .NET Core project file.", this.packageAuthors);
        this.addOption("packageTitle", "Specifies an AssemblyTitle for the .NET Framework global assembly attributes stored in the AssemblyInfo file.", this.packageTitle);
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption(COMPATIBILITY_VERSION, "ASP.Net Core CompatibilityVersion", this.compatibilityVersion);
        this.aspnetCoreVersion.addEnum("2.0", "ASP.NET Core 2.0");
        this.aspnetCoreVersion.addEnum("2.1", "ASP.NET Core 2.1");
        this.aspnetCoreVersion.addEnum("2.2", "ASP.NET Core 2.2");
        this.aspnetCoreVersion.addEnum("3.0", "ASP.NET Core 3.0");
        this.aspnetCoreVersion.addEnum("3.1", "ASP.NET Core 3.1");
        this.aspnetCoreVersion.addEnum("5.0", "ASP.NET Core 5.0");
        this.aspnetCoreVersion.setDefault("3.1");
        this.aspnetCoreVersion.setOptValue(this.aspnetCoreVersion.getDefault());
        this.cliOptions.add(this.aspnetCoreVersion);
        this.swashbuckleVersion.addEnum("3.0.0", "Swashbuckle 3.0.0");
        this.swashbuckleVersion.addEnum("4.0.0", "Swashbuckle 4.0.0");
        this.swashbuckleVersion.addEnum("5.0.0", "Swashbuckle 5.0.0");
        this.swashbuckleVersion.setDefault("3.0.0");
        this.swashbuckleVersion.setOptValue(this.swashbuckleVersion.getDefault());
        this.cliOptions.add(this.swashbuckleVersion);
        this.addSwitch("nullableReferenceTypes", "Use nullable annotations in the project. Only supported on C# 8 / ASP.NET Core 3.0 or newer.", this.nullReferenceTypesFlag);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(USE_SWASHBUCKLE, "Uses the Swashbuckle.AspNetCore NuGet package for documentation.", this.useSwashbuckle);
        this.addSwitch(IS_LIBRARY, "Is the build a library", this.isLibrary);
        this.addSwitch(USE_FRAMEWORK_REFERENCE, "Use frameworkReference for ASP.NET Core 3.0+ and PackageReference ASP.NET Core 2.2 or earlier.", this.useFrameworkReference);
        this.addSwitch(USE_NEWTONSOFT, "Uses the Newtonsoft JSON library.", this.useNewtonsoft);
        this.addOption(NEWTONSOFT_VERSION, "Version for Microsoft.AspNetCore.Mvc.NewtonsoftJson for ASP.NET Core 3.0+", this.newtonsoftVersion);
        this.addSwitch(USE_DEFAULT_ROUTING, "Use default routing for the ASP.NET Core version.", this.useDefaultRouting);
        this.addOption("enumNameSuffix", "Suffix that will be appended to all enum names.", this.enumNameSuffix);
        this.addOption("enumValueSuffix", "Suffix that will be appended to all enum values.", this.enumValueSuffix);
        this.classModifier.addEnum("", "Keep class default with no modifier");
        this.classModifier.addEnum("abstract", "Make class abstract");
        this.classModifier.setDefault("");
        this.classModifier.setOptValue(this.classModifier.getDefault());
        this.addOption(this.classModifier.getOpt(), this.classModifier.getDescription(), this.classModifier.getOptValue());
        this.operationModifier.addEnum("virtual", "Keep method virtual");
        this.operationModifier.addEnum("abstract", "Make method abstract");
        this.operationModifier.setDefault("virtual");
        this.operationModifier.setOptValue(this.operationModifier.getDefault());
        this.cliOptions.add(this.operationModifier);
        this.buildTarget.addEnum("program", "Generate code for a standalone server");
        this.buildTarget.addEnum("library", "Generate code for a server abstract class library");
        this.buildTarget.setDefault("program");
        this.buildTarget.setOptValue(this.buildTarget.getDefault());
        this.cliOptions.add(this.buildTarget);
        this.addSwitch(GENERATE_BODY, "Generates method body.", this.generateBody);
        this.addSwitch(OPERATION_IS_ASYNC, "Set methods to async or sync (default).", this.operationIsAsync);
        this.addSwitch(OPERATION_RESULT_TASK, "Set methods result to Task<>.", this.operationResultTask);
        this.modelClassModifier.setType("String");
        this.modelClassModifier.addEnum("", "Keep model class default with no modifier");
        this.modelClassModifier.addEnum("partial", "Make model class partial");
        this.modelClassModifier.setDefault("partial");
        this.modelClassModifier.setOptValue(this.modelClassModifier.getDefault());
        this.addOption(this.modelClassModifier.getOpt(), this.modelClassModifier.getDescription(), this.modelClassModifier.getOptValue());
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "aspnetcore";
    }

    @Override
    public String getHelp() {
        return "Generates an ASP.NET Core Web API server.";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverHost", url.getHost());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.additionalProperties.put("userSecretsGuid", this.userSecretsGuid);
        if (!this.additionalProperties.containsKey(NEWTONSOFT_VERSION)) {
            this.additionalProperties.put(NEWTONSOFT_VERSION, this.newtonsoftVersion);
        } else {
            this.newtonsoftVersion = (String)this.additionalProperties.get(NEWTONSOFT_VERSION);
        }
        this.setBuildTarget();
        this.setClassModifier();
        this.setOperationModifier();
        this.setModelClassModifier();
        this.setUseSwashbuckle();
        this.setOperationIsAsync();
        this.additionalProperties.put(PROJECT_SDK, this.projectSdk);
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase(Locale.ROOT));
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.packageName + ".Controllers";
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.packageName + ".Models";
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        this.setAspnetCoreVersion(packageFolder);
        this.setSwashbuckleVersion();
        this.setIsFramework();
        this.setUseNewtonsoft();
        this.setUseEndpointRouting();
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("validateModel.mustache", packageFolder + File.separator + "Attributes", "ValidateModelStateAttribute.cs"));
        this.supportingFiles.add(new SupportingFile("typeConverter.mustache", packageFolder + File.separator + "Converters", "CustomEnumConverter.cs"));
        if (this.aspnetCoreVersion.getOptValue().startsWith("3.") || this.aspnetCoreVersion.getOptValue().startsWith("5.0")) {
            this.supportingFiles.add(new SupportingFile("OpenApi" + File.separator + "TypeExtensions.mustache", packageFolder + File.separator + "OpenApi", "TypeExtensions.cs"));
        }
        this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
        if (!this.isLibrary) {
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("appsettings.json", packageFolder, "appsettings.json"));
            this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
            this.supportingFiles.add(new SupportingFile("Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", packageFolder + File.separator + "wwwroot", "README.md"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", packageFolder + File.separator + "wwwroot", "index.html"));
            this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "openapi-original.mustache", packageFolder + File.separator + "wwwroot", "openapi-original.json"));
        } else {
            this.supportingFiles.add(new SupportingFile("Project.nuspec.mustache", packageFolder, this.packageName + ".nuspec"));
        }
        if (this.useSwashbuckle) {
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
        }
        this.supportingFiles.add(new SupportingFile("Authentication" + File.separator + "ApiAuthentication.mustache", packageFolder + File.separator + "Authentication", "ApiAuthentication.cs"));
        this.supportingFiles.add(new SupportingFile("Formatters" + File.separator + "InputFormatterStream.mustache", packageFolder + File.separator + "Formatters", "InputFormatterStream.cs"));
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Controllers";
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateJSONSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized {} to {}. Please verify generated source.", (Object)original, (Object)operation.path);
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase(Locale.ROOT);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations;
        super.postProcessOperationsWithModels(objs, allModels);
        if (objs != null && (operations = (Map)objs.get("operations")) != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                if (operation.consumes == null || operation.consumes.size() == 0) continue;
                StringBuilder consumesString = new StringBuilder();
                for (Map<String, String> consume : operation.consumes) {
                    if (!consume.containsKey("mediaType")) continue;
                    if (consumesString.toString().equals("")) {
                        consumesString = new StringBuilder("\"" + consume.get("mediaType") + "\"");
                    } else {
                        consumesString.append(", \"").append(consume.get("mediaType")).append("\"");
                    }
                    if (!consume.get("mediaType").equals("multipart/form-data")) continue;
                    for (CodegenParameter param : operation.formParams) {
                        if (!param.isBinary) continue;
                        param.dataType = "IFormFile";
                        param.baseType = "IFormFile";
                    }
                    for (CodegenParameter param : operation.allParams) {
                        if (!param.isBinary || !param.isFormParam) continue;
                        param.dataType = "IFormFile";
                        param.baseType = "IFormFile";
                    }
                }
                if (consumesString.toString().equals("")) continue;
                operation.vendorExtensions.put("x-aspnetcore-consumes", consumesString.toString());
            }
        }
        return objs;
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String getNullableType(Schema p, String type) {
        if (this.languageSpecificPrimitives.contains(type)) {
            if (this.isSupportNullable() && ModelUtils.isNullable(p) && (this.nullableType.contains(type) || this.nullReferenceTypesFlag)) {
                return type + "?";
            }
            return type;
        }
        return null;
    }

    private void setCliOption(CliOption cliOption) throws IllegalArgumentException {
        if (this.additionalProperties.containsKey(cliOption.getOpt())) {
            Object obj = this.additionalProperties.get(cliOption.getOpt());
            if (!"boolean".equals(cliOption.getType()) && obj instanceof Boolean) {
                obj = "";
                this.additionalProperties.put(cliOption.getOpt(), obj);
            }
            cliOption.setOptValue(obj.toString());
        } else {
            this.additionalProperties.put(cliOption.getOpt(), cliOption.getOptValue());
        }
        if (cliOption.getOptValue() == null) {
            cliOption.setOptValue(cliOption.getDefault());
            throw new IllegalArgumentException(cliOption.getOpt() + ": Invalid value '" + this.additionalProperties.get(cliOption.getOpt()).toString() + "'. " + cliOption.getDescription());
        }
    }

    private void setClassModifier() {
        this.setCliOption(this.classModifier);
        if ("abstract".equals(this.classModifier.getOptValue())) {
            this.operationModifier.setOptValue(this.classModifier.getOptValue());
            this.additionalProperties.put(OPERATION_MODIFIER, this.operationModifier.getOptValue());
            this.LOGGER.warn("classModifier is {} so forcing operatonModifier to {}", (Object)this.classModifier.getOptValue(), (Object)this.operationModifier.getOptValue());
        }
    }

    private void setOperationModifier() {
        this.setCliOption(this.operationModifier);
        if ("abstract".equals(this.operationModifier.getOptValue())) {
            this.generateBody = false;
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
            this.LOGGER.warn("operationModifier is {} so forcing generateBody to {}", (Object)this.operationModifier.getOptValue(), (Object)this.generateBody);
        } else if (this.additionalProperties.containsKey(GENERATE_BODY)) {
            this.generateBody = this.convertPropertyToBooleanAndWriteBack(GENERATE_BODY);
        } else {
            this.additionalProperties.put(GENERATE_BODY, this.generateBody);
        }
    }

    private void setModelClassModifier() {
        this.setCliOption(this.modelClassModifier);
        if (this.isLibrary) {
            this.modelClassModifier.setOptValue("");
            this.additionalProperties.put(MODEL_CLASS_MODIFIER, this.modelClassModifier.getOptValue());
            this.LOGGER.warn("buildTarget is {} so removing any modelClassModifier ", (Object)this.buildTarget.getOptValue());
        }
    }

    private void setBuildTarget() {
        this.setCliOption(this.buildTarget);
        if ("library".equals(this.buildTarget.getOptValue())) {
            this.LOGGER.warn("buildTarget is {} so changing default isLibrary to true", (Object)this.buildTarget.getOptValue());
            this.isLibrary = true;
            this.projectSdk = SDK_LIB;
            this.additionalProperties.put(CLASS_MODIFIER, "abstract");
        } else {
            this.isLibrary = false;
            this.projectSdk = SDK_WEB;
        }
        this.additionalProperties.put(IS_LIBRARY, this.isLibrary);
    }

    private void setAspnetCoreVersion(String packageFolder) {
        this.setCliOption(this.aspnetCoreVersion);
        this.compatibilityVersion = this.aspnetCoreVersion.getOptValue().startsWith("3.") || this.aspnetCoreVersion.getOptValue().startsWith("5.0") ? null : ("2.0".equals(this.aspnetCoreVersion.getOptValue()) ? null : "Version_" + this.aspnetCoreVersion.getOptValue().replace(".", "_"));
        this.LOGGER.info("ASP.NET core version: {}", (Object)this.aspnetCoreVersion.getOptValue());
        if (!this.additionalProperties.containsKey("templateDir")) {
            this.templateDir = this.embeddedTemplateDir = "aspnetcore" + File.separator + this.determineTemplateVersion(this.aspnetCoreVersion.getOptValue());
        }
        this.additionalProperties.put(COMPATIBILITY_VERSION, this.compatibilityVersion);
    }

    private String determineTemplateVersion(String frameworkVersion) {
        switch (frameworkVersion) {
            case "5.0": 
            case "3.1": {
                return "3.0";
            }
            case "2.2": {
                return "2.1";
            }
        }
        return frameworkVersion;
    }

    private void setUseSwashbuckle() {
        if (this.isLibrary) {
            this.LOGGER.warn("isLibrary is true so changing default useSwashbuckle to false");
            this.useSwashbuckle = false;
        } else {
            this.useSwashbuckle = true;
        }
        if (this.additionalProperties.containsKey(USE_SWASHBUCKLE)) {
            this.useSwashbuckle = this.convertPropertyToBooleanAndWriteBack(USE_SWASHBUCKLE);
        } else {
            this.additionalProperties.put(USE_SWASHBUCKLE, this.useSwashbuckle);
        }
    }

    private void setOperationIsAsync() {
        if (this.isLibrary) {
            this.operationIsAsync = false;
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        } else if (this.additionalProperties.containsKey(OPERATION_IS_ASYNC)) {
            this.operationIsAsync = this.convertPropertyToBooleanAndWriteBack(OPERATION_IS_ASYNC);
        } else {
            this.additionalProperties.put(OPERATION_IS_ASYNC, this.operationIsAsync);
        }
    }

    private void setIsFramework() {
        if (this.aspnetCoreVersion.getOptValue().startsWith("3.")) {
            this.LOGGER.warn("ASP.NET core version is {} so changing to use frameworkReference instead of packageReference ", (Object)this.aspnetCoreVersion.getOptValue());
            this.useFrameworkReference = true;
            this.additionalProperties.put(USE_FRAMEWORK_REFERENCE, this.useFrameworkReference);
            this.additionalProperties.put(TARGET_FRAMEWORK, "netcoreapp" + this.aspnetCoreVersion.getOptValue());
        } else if (this.aspnetCoreVersion.getOptValue().startsWith("5.")) {
            this.LOGGER.warn("ASP.NET core version is {} so changing to use frameworkReference instead of packageReference ", (Object)this.aspnetCoreVersion.getOptValue());
            this.useFrameworkReference = true;
            this.additionalProperties.put(USE_FRAMEWORK_REFERENCE, this.useFrameworkReference);
            this.additionalProperties.put(TARGET_FRAMEWORK, "net5.0");
        } else {
            if (this.additionalProperties.containsKey(USE_FRAMEWORK_REFERENCE)) {
                this.useFrameworkReference = this.convertPropertyToBooleanAndWriteBack(USE_FRAMEWORK_REFERENCE);
            } else {
                this.additionalProperties.put(USE_FRAMEWORK_REFERENCE, this.useFrameworkReference);
            }
            this.additionalProperties.put(TARGET_FRAMEWORK, "netcoreapp" + this.aspnetCoreVersion);
        }
    }

    private void setUseNewtonsoft() {
        if (this.aspnetCoreVersion.getOptValue().startsWith("2.")) {
            this.LOGGER.warn("ASP.NET core version 2.X support has been deprecated. Please use ASP.NET core version 3.1 instead");
            this.LOGGER.warn("ASP.NET core version is {} so staying on default json library.", (Object)this.aspnetCoreVersion.getOptValue());
            this.useNewtonsoft = false;
            this.additionalProperties.put(USE_NEWTONSOFT, this.useNewtonsoft);
        } else if (this.additionalProperties.containsKey(USE_NEWTONSOFT)) {
            this.useNewtonsoft = this.convertPropertyToBooleanAndWriteBack(USE_NEWTONSOFT);
        } else {
            this.additionalProperties.put(USE_NEWTONSOFT, this.useNewtonsoft);
        }
    }

    private void setUseEndpointRouting() {
        if (this.aspnetCoreVersion.getOptValue().startsWith("3.") || this.aspnetCoreVersion.getOptValue().startsWith("5.")) {
            this.LOGGER.warn("ASP.NET core version is {} so switching to old style endpoint routing.", (Object)this.aspnetCoreVersion.getOptValue());
            this.useDefaultRouting = false;
            this.additionalProperties.put(USE_DEFAULT_ROUTING, this.useDefaultRouting);
        } else if (this.additionalProperties.containsKey(USE_DEFAULT_ROUTING)) {
            this.useDefaultRouting = this.convertPropertyToBooleanAndWriteBack(USE_DEFAULT_ROUTING);
        } else {
            this.additionalProperties.put(USE_DEFAULT_ROUTING, this.useDefaultRouting);
        }
    }

    private void setSwashbuckleVersion() {
        this.setCliOption(this.swashbuckleVersion);
        if (this.aspnetCoreVersion.getOptValue().startsWith("3.") || this.aspnetCoreVersion.getOptValue().startsWith("5.")) {
            this.LOGGER.warn("ASP.NET core version is {} so changing default Swashbuckle version to 5.0.0.", (Object)this.aspnetCoreVersion.getOptValue());
            this.swashbuckleVersion.setOptValue("5.0.0");
            this.additionalProperties.put(SWASHBUCKLE_VERSION, this.swashbuckleVersion.getOptValue());
        } else {
            this.LOGGER.info("Swashbuckle version: {}", (Object)this.swashbuckleVersion.getOptValue());
        }
    }
}

