/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Apache2ConfigCodegen
extends DefaultCodegen
implements CodegenConfig {
    public static final String USER_INFO_PATH = "userInfoPath";
    private final Logger LOGGER = LoggerFactory.getLogger(Apache2ConfigCodegen.class);
    protected String userInfoPath = "/var/www/html/";

    @Override
    public CodegenType getTag() {
        return CodegenType.CONFIG;
    }

    @Override
    public String getName() {
        return "apache2";
    }

    @Override
    public String getHelp() {
        return "Generates an Apache2 Config file with the permissions";
    }

    public Apache2ConfigCodegen() {
        this.modifyFeatureSet(features -> features.parameterFeatures(EnumSet.of(ParameterFeature.Path)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth)).dataTypeFeatures(EnumSet.noneOf(DataTypeFeature.class)).wireFormatFeatures(EnumSet.noneOf(WireFormatFeature.class)).documentationFeatures(EnumSet.noneOf(DocumentationFeature.class)).globalFeatures(EnumSet.noneOf(GlobalFeature.class)).schemaSupportFeatures(EnumSet.noneOf(SchemaSupportFeature.class)).clientModificationFeatures(EnumSet.noneOf(ClientModificationFeature.class)));
        this.apiTemplateFiles.put("apache-config.mustache", ".conf");
        this.templateDir = "apache2";
        this.embeddedTemplateDir = "apache2";
        this.cliOptions.add(new CliOption(USER_INFO_PATH, "Path to the user and group files"));
    }

    @Override
    public void processOpts() {
        if (this.additionalProperties.containsKey(USER_INFO_PATH)) {
            this.userInfoPath = this.additionalProperties.get(USER_INFO_PATH).toString();
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        ArrayList<CodegenOperation> newOpList = new ArrayList<CodegenOperation>();
        for (CodegenOperation op : operationList) {
            String path = op.path;
            String[] items = path.split("/", -1);
            ArrayList<String> splitPath = new ArrayList<String>();
            for (String item : items) {
                if (item.matches("^\\{(.*)\\}$")) {
                    item = "*";
                }
                splitPath.add(item);
                op.path = op.path + item + "/";
            }
            op.vendorExtensions.put("x-codegen-user-info-path", this.userInfoPath);
            boolean foundInNewList = false;
            for (CodegenOperation op1 : newOpList) {
                if (foundInNewList || !op1.path.equals(op.path)) continue;
                foundInNewList = true;
                ArrayList<CodegenOperation> currentOtherMethodList = (ArrayList<CodegenOperation>)op1.vendorExtensions.get("x-codegen-otherMethods");
                if (currentOtherMethodList == null) {
                    currentOtherMethodList = new ArrayList<CodegenOperation>();
                }
                op.operationIdCamelCase = op1.operationIdCamelCase;
                currentOtherMethodList.add(op);
                op1.vendorExtensions.put("x-codegen-other-methods", currentOtherMethodList);
            }
            if (foundInNewList) continue;
            newOpList.add(op);
        }
        operations.put("operation", newOpList);
        return objs;
    }
}

