/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.github.curiousoddman.rgxgen.RgxGen;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenComposedSchemas;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.TemplateManager;
import org.openapitools.codegen.api.TemplatePathLocator;
import org.openapitools.codegen.api.TemplateProcessor;
import org.openapitools.codegen.api.TemplatingEngineAdapter;
import org.openapitools.codegen.ignore.CodegenIgnoreProcessor;
import org.openapitools.codegen.languages.AbstractPythonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.templating.CommonTemplateContentLocator;
import org.openapitools.codegen.templating.GeneratorTemplateContentLocator;
import org.openapitools.codegen.templating.HandlebarsEngineAdapter;
import org.openapitools.codegen.templating.TemplateManagerOptions;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonExperimentalClientCodegen
extends AbstractPythonCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PythonExperimentalClientCodegen.class);
    public static final String PACKAGE_URL = "packageUrl";
    public static final String DEFAULT_LIBRARY = "urllib3";
    public static final String USE_NOSE = "useNose";
    public static final String RECURSION_LIMIT = "recursionLimit";
    protected String packageUrl;
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected boolean useNose = Boolean.FALSE;
    protected Map<Character, String> regexModifiers;
    private String testFolder;
    private Map<String, Schema> modelNameToSchemaCache;
    private DateTimeFormatter iso8601Date = DateTimeFormatter.ISO_DATE;
    private DateTimeFormatter iso8601DateTime = DateTimeFormatter.ISO_DATE_TIME;
    private String templateExtension;
    protected CodegenIgnoreProcessor ignoreProcessor;
    protected TemplateProcessor templateProcessor = null;

    public PythonExperimentalClientCodegen() {
        this.loadDeepObjectIntoItems = false;
        this.modifyFeatureSet(features -> features.includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Simple, SchemaSupportFeature.Composite, SchemaSupportFeature.Polymorphism, SchemaSupportFeature.Union}).includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer, GlobalFeature.ParameterStyling}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects}).excludeSchemaSupportFeatures(new SchemaSupportFeature[0]).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.importMapping.clear();
        this.modelPackage = "model";
        this.apiPackage = "api";
        this.outputFolder = "generated-code" + File.separatorChar + "python";
        this.templateDir = "python-experimental";
        this.embeddedTemplateDir = "python-experimental";
        this.testFolder = "test";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("all_params", "resource_path", "path_params", "query_params", "header_params", "form_params", "local_var_files", "body_params", "auth_settings", "property", "and", "del", "from", "not", "while", "as", "elif", "global", "or", "with", "assert", "else", "if", "pass", "yield", "break", "except", "import", "print", "class", "exec", "in", "raise", "continue", "finally", "is", "return", "def", "for", "lambda", "try", "self", "nonlocal", "None", "True", "False", "async", "await", "float", "int", "str", "bool", "none_type", "dict", "frozendict", "list", "tuple", "file_type"));
        this.regexModifiers = new HashMap<Character, String>();
        this.regexModifiers.put(Character.valueOf('i'), "IGNORECASE");
        this.regexModifiers.put(Character.valueOf('l'), "LOCALE");
        this.regexModifiers.put(Character.valueOf('m'), "MULTILINE");
        this.regexModifiers.put(Character.valueOf('s'), "DOTALL");
        this.regexModifiers.put(Character.valueOf('u'), "UNICODE");
        this.regexModifiers.put(Character.valueOf('x'), "VERBOSE");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "python package name (convention: snake_case).").defaultValue("openapi_client"));
        this.cliOptions.add(new CliOption("projectName", "python project name in setup.py (e.g. petstore-api)."));
        this.cliOptions.add(new CliOption("packageVersion", "python package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption(PACKAGE_URL, "python package URL."));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("generateSourceCodeOnly", "Specifies that only a library source code is to be generated.").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(CliOption.newBoolean(USE_NOSE, "use the nose test framework").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(RECURSION_LIMIT, "Set the recursion limit. If not set, use the system default value."));
        this.supportedLibraries.put(DEFAULT_LIBRARY, "urllib3-based client");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use: urllib3");
        libraryOption.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(libraryOption);
        this.setLibrary(DEFAULT_LIBRARY);
        this.supportsAdditionalPropertiesWithComposedSchema = true;
        this.setDisallowAdditionalPropertiesIfNotPresent(false);
        this.instantiationTypes.put("map", "dict");
        this.languageSpecificPrimitives.add("file_type");
        this.languageSpecificPrimitives.add("none_type");
        this.typeMapping.put("decimal", "str");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
    }

    @Override
    public void processOpts() {
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        TemplatingEngineAdapter te = this.getTemplatingEngine();
        if (!(te instanceof HandlebarsEngineAdapter)) {
            throw new RuntimeException("Only the HandlebarsEngineAdapter is supported for this generator");
        }
        HandlebarsEngineAdapter hea = (HandlebarsEngineAdapter)te;
        hea.infiniteLoops(true);
        hea.setPrettyPrint(true);
        CommonTemplateContentLocator commonTemplateLocator = new CommonTemplateContentLocator();
        GeneratorTemplateContentLocator generatorTemplateLocator = new GeneratorTemplateContentLocator(this);
        TemplateManagerOptions templateManagerOptions = new TemplateManagerOptions(this.isEnableMinimalUpdate(), this.isSkipOverwrite());
        this.templateProcessor = new TemplateManager(templateManagerOptions, te, new TemplatePathLocator[]{generatorTemplateLocator, commonTemplateLocator});
        this.templateExtension = te.getIdentifier();
        String ignoreFileLocation = this.getIgnoreFilePathOverride();
        if (ignoreFileLocation != null) {
            File ignoreFile = new File(ignoreFileLocation);
            if (ignoreFile.exists() && ignoreFile.canRead()) {
                this.ignoreProcessor = new CodegenIgnoreProcessor(ignoreFile);
            } else {
                this.LOGGER.warn("Ignore file specified at {} is not valid. This will fall back to an existing ignore file if present in the output directory.", (Object)ignoreFileLocation);
            }
        }
        if (this.ignoreProcessor == null) {
            this.ignoreProcessor = new CodegenIgnoreProcessor(this.getOutputDir());
        }
        this.modelTemplateFiles.put("model." + this.templateExtension, ".py");
        this.apiTemplateFiles.put("api." + this.templateExtension, ".py");
        this.modelTestTemplateFiles.put("model_test." + this.templateExtension, ".py");
        this.apiTestTemplateFiles.put("api_test." + this.templateExtension, ".py");
        this.modelDocTemplateFiles.put("model_doc." + this.templateExtension, ".md");
        this.apiDocTemplateFiles.put("api_doc." + this.templateExtension, ".md");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("PYTHON_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable PYTHON_POST_PROCESS_FILE not defined so the Python code may not be properly formatted. To define it, try 'export PYTHON_POST_PROCESS_FILE=\"/usr/local/bin/yapf -i\"' (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        Boolean excludeTests = false;
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        }
        if (this.additionalProperties.containsKey("projectName")) {
            this.setProjectName((String)this.additionalProperties.get("projectName"));
        } else {
            this.setProjectName(this.packageName.replaceAll("_", "-"));
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        }
        this.additionalProperties.put("projectName", this.projectName);
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        if (this.additionalProperties.containsKey("excludeTests")) {
            excludeTests = Boolean.valueOf(this.additionalProperties.get("excludeTests").toString());
        }
        Boolean generateSourceCodeOnly = false;
        if (this.additionalProperties.containsKey("generateSourceCodeOnly")) {
            generateSourceCodeOnly = Boolean.valueOf(this.additionalProperties.get("generateSourceCodeOnly").toString());
        }
        if (generateSourceCodeOnly.booleanValue()) {
            this.testFolder = this.packagePath() + File.separatorChar + this.testFolder;
            this.apiDocPath = this.packagePath() + File.separatorChar + this.apiDocPath;
            this.modelDocPath = this.packagePath() + File.separatorChar + this.modelDocPath;
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        if (this.additionalProperties.containsKey(PACKAGE_URL)) {
            this.setPackageUrl((String)this.additionalProperties.get(PACKAGE_URL));
        }
        if (this.additionalProperties.containsKey(USE_NOSE)) {
            this.setUseNose((String)this.additionalProperties.get(USE_NOSE));
        }
        if (this.additionalProperties.containsKey(RECURSION_LIMIT)) {
            try {
                Integer.parseInt((String)this.additionalProperties.get(RECURSION_LIMIT));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new IllegalArgumentException("recursionLimit must be an integer, e.g. 2000.");
            }
        }
        String readmePath = "README.md";
        String readmeTemplate = "README." + this.templateExtension;
        if (generateSourceCodeOnly.booleanValue()) {
            readmePath = this.packagePath() + "_" + readmePath;
            readmeTemplate = "README_onlypackage." + this.templateExtension;
        }
        this.supportingFiles.add(new SupportingFile(readmeTemplate, "", readmePath));
        if (!generateSourceCodeOnly.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tox." + this.templateExtension, "", "tox.ini"));
            this.supportingFiles.add(new SupportingFile("test-requirements." + this.templateExtension, "", "test-requirements.txt"));
            this.supportingFiles.add(new SupportingFile("requirements." + this.templateExtension, "", "requirements.txt"));
            this.supportingFiles.add(new SupportingFile("setup_cfg." + this.templateExtension, "", "setup.cfg"));
            this.supportingFiles.add(new SupportingFile("git_push.sh." + this.templateExtension, "", "git_push.sh"));
            this.supportingFiles.add(new SupportingFile("gitignore." + this.templateExtension, "", ".gitignore"));
            this.supportingFiles.add(new SupportingFile("travis." + this.templateExtension, "", ".travis.yml"));
            this.supportingFiles.add(new SupportingFile("gitlab-ci." + this.templateExtension, "", ".gitlab-ci.yml"));
            this.supportingFiles.add(new SupportingFile("setup." + this.templateExtension, "", "setup.py"));
        }
        this.supportingFiles.add(new SupportingFile("configuration." + this.templateExtension, this.packagePath(), "configuration.py"));
        this.supportingFiles.add(new SupportingFile("__init__package." + this.templateExtension, this.packagePath(), "__init__.py"));
        String[] packageNameSplits = this.packageName.split("\\.");
        String currentPackagePath = "";
        for (int i = 0; i < packageNameSplits.length - 1; ++i) {
            if (i > 0) {
                currentPackagePath = currentPackagePath + File.separatorChar;
            }
            currentPackagePath = currentPackagePath + packageNameSplits[i];
            this.supportingFiles.add(new SupportingFile("__init__." + this.templateExtension, currentPackagePath, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("exceptions." + this.templateExtension, this.packagePath(), "exceptions.py"));
        if (Boolean.FALSE.equals(excludeTests)) {
            this.supportingFiles.add(new SupportingFile("__init__." + this.templateExtension, this.testFolder, "__init__.py"));
        }
        this.supportingFiles.add(new SupportingFile("api_client." + this.templateExtension, this.packagePath(), "api_client.py"));
        if ("asyncio".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("asyncio/rest." + this.templateExtension, this.packagePath(), "rest.py"));
            this.additionalProperties.put("asyncio", "true");
        } else if ("tornado".equals(this.getLibrary())) {
            this.supportingFiles.add(new SupportingFile("tornado/rest." + this.templateExtension, this.packagePath(), "rest.py"));
            this.additionalProperties.put("tornado", "true");
        } else {
            this.supportingFiles.add(new SupportingFile("rest." + this.templateExtension, this.packagePath(), "rest.py"));
        }
        this.supportingFiles.add(new SupportingFile("schemas." + this.templateExtension, this.packagePath(), "schemas.py"));
        this.supportingFiles.add(new SupportingFile("__init__models." + this.templateExtension, this.packagePath() + File.separatorChar + "models", "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__model." + this.templateExtension, this.packagePath() + File.separatorChar + this.modelPackage, "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__apis." + this.templateExtension, this.packagePath() + File.separatorChar + "apis", "__init__.py"));
        this.supportingFiles.add(new SupportingFile("__init__api." + this.templateExtension, this.packagePath() + File.separatorChar + this.apiPackage, "__init__.py"));
        Map securitySchemeMap = this.openAPI != null ? (this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null) : null;
        List<CodegenSecurity> authMethods = this.fromSecurity(securitySchemeMap);
        if (ProcessUtils.hasHttpSignatureMethods(authMethods)) {
            this.supportingFiles.add(new SupportingFile("signing." + this.templateExtension, this.packagePath(), "signing.py"));
        }
        ModelUtils.setGenerateAliasAsModel(true);
        this.LOGGER.info("generateAliasAsModel is hard coded to true in this generator. Alias models will only be generated if they contain validations or enums");
        if (!DEFAULT_LIBRARY.equals(this.getLibrary())) {
            throw new RuntimeException("Only the `urllib3` library is supported in the refactored `python` client generator at the moment. Please fall back to `python-legacy` client generator for the time being. We welcome contributions to add back `asyncio`, `tornado` support to the `python` client generator.");
        }
    }

    public String endpointFilename(String templateName, String tag, String operationId) {
        return this.apiFileFolder() + File.separator + this.toApiFilename(tag) + "_endpoints" + File.separator + operationId + ".py";
    }

    protected File processTemplateToFile(Map<String, Object> templateData, String templateName, String outputFilename, boolean shouldGenerate, String skippedByOption) throws IOException {
        String adjustedOutputFilename = outputFilename.replaceAll("//", "/").replace('/', File.separatorChar);
        File target = new File(adjustedOutputFilename);
        if (this.ignoreProcessor.allowsFile(target)) {
            if (shouldGenerate) {
                Path outDir = Paths.get(this.getOutputDir(), new String[0]).toAbsolutePath();
                Path absoluteTarget = target.toPath().toAbsolutePath();
                if (!absoluteTarget.startsWith(outDir)) {
                    throw new RuntimeException(String.format(Locale.ROOT, "Target files must be generated within the output directory; absoluteTarget=%s outDir=%s", absoluteTarget, outDir));
                }
                return this.templateProcessor.write(templateData, templateName, target);
            }
            this.templateProcessor.skip(target.toPath(), String.format(Locale.ROOT, "Skipped by %s options supplied by user.", skippedByOption));
            return null;
        }
        this.templateProcessor.ignore(target.toPath(), "Ignored by rule in ignore file.");
        return null;
    }

    protected void generateEndpoints(Map<String, Object> objs) {
        if (!((Boolean)this.additionalProperties.get("generateApis")).booleanValue()) {
            return;
        }
        HashMap operations = (HashMap)objs.get("operations");
        ArrayList codegenOperations = (ArrayList)operations.get("operation");
        for (CodegenOperation co : codegenOperations) {
            for (Tag tag : co.tags) {
                String tagName = tag.getName();
                String pythonTagName = this.toVarName(tagName);
                HashMap<String, Object> operationMap = new HashMap<String, Object>();
                operationMap.put("operation", co);
                operationMap.put("imports", co.imports);
                operationMap.put("packageName", this.packageName);
                String templateName = "endpoint.handlebars";
                String filename = this.endpointFilename(templateName, pythonTagName, co.operationId);
                try {
                    File file = this.processTemplateToFile(operationMap, templateName, filename, true, "apis");
                }
                catch (IOException e) {
                    this.LOGGER.error("Error when writing template file {}", (Object)e.toString());
                }
            }
        }
    }

    @Override
    protected void addVarsRequiredVarsAdditionalProps(Schema schema, IJsonSchemaValidationProperties property) {
        this.setAddProps(schema, property);
        if (schema instanceof ComposedSchema && this.supportsAdditionalPropertiesWithComposedSchema) {
            ComposedSchema cs = (ComposedSchema)schema;
            if (schema.getProperties() != null && !schema.getProperties().isEmpty()) {
                if (cs.getOneOf() != null && !cs.getOneOf().isEmpty()) {
                    this.LOGGER.warn("'oneOf' is intended to include only the additional optional OAS extension discriminator object. For more details, see https://json-schema.org/draft/2019-09/json-schema-core.html#rfc.section.9.2.1.3 and the OAS section on 'Composition and Inheritance'.");
                }
                HashSet<String> requiredVars = new HashSet<String>();
                if (schema.getRequired() != null) {
                    requiredVars.addAll(schema.getRequired());
                }
                this.addVars(property, property.getVars(), schema.getProperties(), requiredVars);
            }
            return;
        }
        if (ModelUtils.isTypeObjectSchema(schema)) {
            HashSet<String> requiredVars = new HashSet<String>();
            if (schema.getRequired() != null) {
                requiredVars.addAll(schema.getRequired());
                property.setHasRequired(true);
            }
            this.addVars(property, property.getVars(), schema.getProperties(), requiredVars);
            if (property.getVars() != null && !property.getVars().isEmpty()) {
                property.setHasVars(true);
            }
        }
    }

    @Override
    public String getName() {
        return "python-experimental";
    }

    @Override
    public String getHelp() {
        String newLine = System.getProperty("line.separator");
        return String.join((CharSequence)"<br />", "Generates a Python client library", "", "Features in this generator:", "- type hints on endpoints and model creation", "- model parameter names use the spec defined keys and cases", "- robust composition (oneOf/anyOf/allOf) where paload data is stored in one instance only", "- endpoint parameter names use the spec defined keys and cases", "- inline schemas are supported at any location including composition", "- multiple content types supported in request body and response bodies", "- run time type checking", "- Sending/receiving decimals as strings supported with type:string format: number -> DecimalSchema", "- quicker load time for python modules (a single endpoint can be imported and used without loading others)", "- all instances of schemas dynamically inherit from all matching schemas so one can use isinstance to check if validation passed", "- composed schemas with type constraints supported (type:object + oneOf/anyOf/allOf)", "- schemas are not coerced/cast. For example string + date are both stored as string, and there is a date accessor", "    - Exceptions: int/float is stored as Decimal, When receiving data from headers it will start as str and may need to be cast for example to int");
    }

    @Override
    public Schema unaliasSchema(Schema schema, Map<String, String> usedImportMappings) {
        Map<String, Schema> allSchemas = ModelUtils.getSchemas(this.openAPI);
        if (allSchemas == null || allSchemas.isEmpty()) {
            return schema;
        }
        if (schema != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)schema.get$ref())) {
            String simpleRef = ModelUtils.getSimpleRef(schema.get$ref());
            if (usedImportMappings.containsKey(simpleRef)) {
                this.LOGGER.debug("Schema unaliasing of {} omitted because aliased class is to be mapped to {}", (Object)simpleRef, (Object)usedImportMappings.get(simpleRef));
                return schema;
            }
            Schema ref = allSchemas.get(simpleRef);
            if (ref == null) {
                OnceLogger.once(this.LOGGER).warn("{} is not defined", (Object)schema.get$ref());
                return schema;
            }
            if (ref.getEnum() != null && !ref.getEnum().isEmpty()) {
                return schema;
            }
            if (ModelUtils.isArraySchema(ref)) {
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.isComposedSchema(ref)) {
                return schema;
            }
            if (ModelUtils.isMapSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                if (ModelUtils.isGenerateAliasAsModel(ref)) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.isObjectSchema(ref)) {
                if (ref.getProperties() != null && !ref.getProperties().isEmpty()) {
                    return schema;
                }
                if (ModelUtils.hasValidation(ref)) {
                    return schema;
                }
                if (this.getAllOfDescendants(simpleRef, this.openAPI).size() > 0) {
                    return schema;
                }
                return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
            }
            if (ModelUtils.hasValidation(ref)) {
                return schema;
            }
            if (Boolean.TRUE.equals(ref.getNullable()) && ref.getEnum() == null) {
                return schema;
            }
            return this.unaliasSchema(allSchemas.get(ModelUtils.getSimpleRef(schema.get$ref())), usedImportMappings);
        }
        return schema;
    }

    public String pythonDate(Object dateValue) {
        String strValue = null;
        if (dateValue instanceof OffsetDateTime) {
            OffsetDateTime date = null;
            try {
                date = (OffsetDateTime)dateValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date` format for value {}", (Object)dateValue.toString());
                date = ((Date)dateValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = date.format(this.iso8601Date);
        } else {
            strValue = dateValue.toString();
        }
        return "isoparse('" + strValue + "').date()";
    }

    public String pythonDateTime(Object dateTimeValue) {
        String strValue = null;
        if (dateTimeValue instanceof OffsetDateTime) {
            OffsetDateTime dateTime = null;
            try {
                dateTime = (OffsetDateTime)dateTimeValue;
            }
            catch (ClassCastException e) {
                this.LOGGER.warn("Invalid `date-time` format for value {}", (Object)dateTimeValue.toString());
                dateTime = ((Date)dateTimeValue).toInstant().atOffset(ZoneOffset.UTC);
            }
            strValue = dateTime.format(this.iso8601DateTime);
        } else {
            strValue = dateTimeValue.toString();
        }
        return "isoparse('" + strValue + "')";
    }

    @Override
    public String toDefaultValue(Schema p) {
        Object defaultObject = null;
        if (p.getDefault() != null) {
            defaultObject = p.getDefault();
        }
        if (defaultObject == null) {
            return null;
        }
        String defaultValue = defaultObject.toString();
        if (ModelUtils.isDateSchema(p)) {
            defaultValue = this.pythonDate(defaultObject);
        } else if (ModelUtils.isDateTimeSchema(p)) {
            defaultValue = this.pythonDateTime(defaultObject);
        } else if (!(!ModelUtils.isStringSchema(p) || ModelUtils.isByteArraySchema(p) || ModelUtils.isBinarySchema(p) || ModelUtils.isFileSchema(p) || ModelUtils.isUUIDSchema(p) || ModelUtils.isEmailSchema(p))) {
            defaultValue = this.ensureQuotes(defaultValue);
        } else if (ModelUtils.isBooleanSchema(p)) {
            defaultValue = Boolean.valueOf(defaultValue) == false ? "False" : "True";
        }
        return defaultValue;
    }

    @Override
    public String toModelImport(String name) {
        return "from " + this.packagePath() + "." + this.modelPackage() + "." + this.toModelFilename(name) + " import " + this.toModelName(name);
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        HashMap val = (HashMap)objs.get("operations");
        ArrayList operations = (ArrayList)val.get("operation");
        ArrayList imports = (ArrayList)objs.get("imports");
        for (CodegenOperation operation : operations) {
            if (operation.imports.size() == 0) continue;
            String[] modelNames = operation.imports.toArray(new String[0]);
            operation.imports.clear();
            for (String modelName : modelNames) {
                operation.imports.add(this.toModelImport(modelName));
            }
        }
        this.generateEndpoints(objs);
        return objs;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        super.postProcessAllModels(objs);
        Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
        for (String schemaName : allDefinitions.keySet()) {
            ModelsMap objModel;
            Schema refSchema = new Schema().$ref("#/components/schemas/" + schemaName);
            Schema unaliasedSchema = this.unaliasSchema(refSchema, this.importMapping);
            String modelName = this.toModelName(schemaName);
            if (unaliasedSchema.get$ref() == null || (objModel = objs.get(modelName)) == null) continue;
            for (ModelMap model : objModel.getModels()) {
                CodegenModel cm = model.getModel();
                String[] importModelNames = cm.imports.toArray(new String[0]);
                cm.imports.clear();
                for (String importModelName : importModelNames) {
                    cm.imports.add(this.toModelImport(importModelName));
                }
            }
        }
        return objs;
    }

    @Override
    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenProperty schemaProp;
        CodegenParameter cp = super.fromParameter(parameter, imports);
        if (parameter.getStyle() != null) {
            switch (parameter.getStyle()) {
                case MATRIX: {
                    cp.style = "MATRIX";
                    break;
                }
                case LABEL: {
                    cp.style = "LABEL";
                    break;
                }
                case FORM: {
                    cp.style = "FORM";
                    break;
                }
                case SIMPLE: {
                    cp.style = "SIMPLE";
                    break;
                }
                case SPACEDELIMITED: {
                    cp.style = "SPACE_DELIMITED";
                    break;
                }
                case PIPEDELIMITED: {
                    cp.style = "PIPE_DELIMITED";
                    break;
                }
                case DEEPOBJECT: {
                    cp.style = "DEEP_OBJECT";
                }
            }
        }
        if ((schemaProp = cp.getSchema().clone()) != null) {
            schemaProp.nameInSnakeCase = null;
            schemaProp.baseName = this.toModelName(cp.baseName) + "Schema";
            cp.setSchema(schemaProp);
        }
        return cp;
    }

    private boolean isValidPythonVarOrClassName(String name) {
        return name.matches("^[_a-zA-Z][_a-zA-Z0-9]*$");
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p) {
        CodegenProperty cp = super.fromProperty(name, p);
        if (cp.isAnyType && cp.isNullable) {
            cp.isNullable = false;
        }
        if (cp.isNullable && cp.complexType == null) {
            cp.setIsNull(true);
            cp.isNullable = false;
            cp.setHasMultipleTypes(true);
        }
        this.postProcessPattern(cp.pattern, cp.vendorExtensions);
        cp.nameInSnakeCase = (this.isReservedWord(name) || !this.isValidPythonVarOrClassName(name)) && !name.equals(cp.name) ? cp.name : null;
        if (cp.isEnum) {
            this.updateCodegenPropertyEnum(cp);
        }
        Schema unaliasedSchema = this.unaliasSchema(p, this.importMapping);
        if (cp.isPrimitiveType && unaliasedSchema.get$ref() != null) {
            cp.complexType = cp.dataType;
        }
        this.setAdditionalPropsAndItemsVarNames(cp);
        return cp;
    }

    private void setAdditionalPropsAndItemsVarNames(IJsonSchemaValidationProperties item) {
        if (item.getAdditionalProperties() != null) {
            item.getAdditionalProperties().setBaseName("_additional_properties");
        }
        if (item.getItems() != null) {
            item.getItems().setBaseName("_items");
        }
    }

    @Override
    public boolean isDataTypeString(String dataType) {
        return "str".equals(dataType);
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        Map<String, Object> extensions;
        Map<String, Object> allowableValues = var.allowableValues;
        if (var.mostInnerItems != null) {
            allowableValues = var.mostInnerItems.allowableValues;
        }
        if (allowableValues == null) {
            return;
        }
        List values = (List)allowableValues.get("values");
        if (values == null) {
            return;
        }
        String varDataType = var.mostInnerItems != null ? var.mostInnerItems.dataType : var.dataType;
        Schema referencedSchema = this.getModelNameToSchemaCache().get(varDataType);
        String dataType = referencedSchema != null ? this.getTypeDeclaration(referencedSchema) : varDataType;
        List<Map<String, Object>> enumVars = this.buildEnumVars(values, dataType);
        Map<String, Object> map = extensions = var.mostInnerItems != null ? var.mostInnerItems.getVendorExtensions() : var.getVendorExtensions();
        if (referencedSchema != null) {
            extensions = referencedSchema.getExtensions();
        }
        this.updateEnumVarsWithExtensions(enumVars, extensions, dataType);
        allowableValues.put("enumVars", enumVars);
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter cp = super.fromRequestBody(body, imports, bodyParameterName);
        cp.baseName = "body";
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        if (schema.get$ref() == null) {
            return cp;
        }
        Schema unaliasedSchema = this.unaliasSchema(schema, this.importMapping);
        CodegenProperty unaliasedProp = this.fromProperty("body", unaliasedSchema);
        Boolean dataTypeMismatch = !cp.dataType.equals(unaliasedProp.dataType);
        Boolean baseTypeMismatch = !cp.baseType.equals(unaliasedProp.complexType) && unaliasedProp.complexType != null;
        if (dataTypeMismatch.booleanValue() || baseTypeMismatch.booleanValue()) {
            cp.dataType = unaliasedProp.dataType;
            cp.baseType = unaliasedProp.complexType;
        }
        return cp;
    }

    @Override
    protected void addBodyModelSchema(CodegenParameter codegenParameter, String name, Schema schema, Set<String> imports, String bodyParameterName, boolean forceSimpleRef) {
        Schema bodySchema;
        Schema unaliased;
        if (name != null && (unaliased = this.unaliasSchema(bodySchema = new Schema().$ref("#/components/schemas/" + name), this.importMapping)).get$ref() != null) {
            forceSimpleRef = true;
        }
        CodegenModel codegenModel = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            schema.setName(name);
            codegenModel = this.fromModel(name, schema);
        }
        if (codegenModel != null) {
            codegenParameter.isModel = true;
        }
        if (codegenModel != null && (codegenModel.hasVars || forceSimpleRef)) {
            codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModel.classname : bodyParameterName;
            codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
            codegenParameter.baseType = codegenModel.classname;
            codegenParameter.dataType = this.getTypeDeclaration(codegenModel.classname);
            codegenParameter.description = codegenModel.description;
            codegenParameter.isNullable = codegenModel.isNullable;
            imports.add(codegenParameter.baseType);
        } else {
            CodegenProperty codegenProperty = this.fromProperty("property", schema);
            if (codegenProperty != null && codegenProperty.getComplexType() != null && codegenProperty.getComplexType().contains(" | ")) {
                String codegenModelName;
                List<String> parts = Arrays.asList(codegenProperty.getComplexType().split(" \\| "));
                imports.addAll(parts);
                codegenParameter.baseName = codegenModelName = codegenProperty.getComplexType();
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenParameter.baseName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenProperty.getDescription();
                codegenParameter.isNullable = codegenProperty.isNullable;
            } else if (ModelUtils.isMapSchema(schema)) {
                this.LOGGER.error("Map should be supported. Please report to openapi-generator github repo about the issue.");
            } else if (codegenProperty != null) {
                String codegenModelDescription;
                String codegenModelName;
                if (codegenModel != null) {
                    codegenModelName = codegenModel.classname;
                    codegenModelDescription = codegenModel.description;
                } else {
                    codegenModelName = "anyType";
                    codegenModelDescription = "";
                }
                codegenParameter.baseName = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)bodyParameterName) ? codegenModelName : bodyParameterName;
                codegenParameter.paramName = this.toParamName(codegenParameter.baseName);
                codegenParameter.baseType = codegenModelName;
                codegenParameter.dataType = this.getTypeDeclaration(codegenModelName);
                codegenParameter.description = codegenModelDescription;
                if (codegenProperty.complexType != null) {
                    imports.add(codegenProperty.complexType);
                }
            }
            this.setParameterNullable(codegenParameter, codegenProperty);
        }
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "EMPTY";
        }
        String intPattern = "^[-\\+]?\\d+$";
        String floatPattern = "^[-\\+]?\\d+\\.\\d+$";
        Boolean intMatch = Pattern.matches(intPattern, value);
        Boolean floatMatch = Pattern.matches(floatPattern, value);
        if (intMatch.booleanValue() || floatMatch.booleanValue()) {
            String plusSign = "^\\+.+";
            String negSign = "^-.+";
            value = Pattern.matches(plusSign, value) ? value.replace("+", "POSITIVE_") : (Pattern.matches(negSign, value) ? value.replace("-", "NEGATIVE_") : "POSITIVE_" + value);
            if (floatMatch.booleanValue()) {
                value = value.replace(".", "_PT_");
            }
            return value;
        }
        String usedValue = value.replaceAll("\\s+", "_").toUpperCase(Locale.ROOT);
        usedValue = usedValue.replaceAll("^[^_a-zA-Z]", "");
        if ((usedValue = usedValue.replaceAll("[^_a-zA-Z0-9]*", "")).length() == 0) {
            for (int i = 0; i < value.length(); ++i) {
                Character c = Character.valueOf(value.charAt(i));
                String charName = Character.getName(c.hashCode());
                usedValue = usedValue + this.charNameToVarName(charName);
            }
            usedValue = usedValue.replaceAll("[_]$", "");
        }
        return usedValue;
    }

    private String charNameToVarName(String charName) {
        String varName = charName.replaceAll("[\\-\\s]", "_");
        varName = varName.replaceAll("SIGN", "");
        return varName;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "float".equals(datatype) || datatype.equals("int, float")) {
            return value;
        }
        if ("bool".equals(datatype)) {
            return value.substring(0, 1).toUpperCase(Locale.ROOT) + value.substring(1);
        }
        return this.ensureQuotes(value);
    }

    @Override
    public void postProcessParameter(CodegenParameter p) {
        this.postProcessPattern(p.pattern, p.vendorExtensions);
        if (p.baseType != null && this.languageSpecificPrimitives.contains(p.baseType)) {
            p.baseType = null;
        }
    }

    @Override
    protected void addParentContainer(CodegenModel model, String name, Schema schema) {
        super.addParentContainer(model, name, schema);
        ArrayList<String> referencedModelNames = new ArrayList<String>();
        model.dataType = this.getTypeString(schema, "", "", referencedModelNames);
    }

    @Override
    public CodegenModel fromModel(String name, Schema sc) {
        CodegenModel cm = super.fromModel(name, sc);
        Schema unaliasedSchema = this.unaliasSchema(sc, this.importMapping);
        if (unaliasedSchema != null && ModelUtils.isDecimalSchema(unaliasedSchema)) {
            cm.isString = false;
            cm.isDecimal = true;
        }
        if (cm.isNullable) {
            cm.setIsNull(true);
            cm.isNullable = false;
            cm.setHasMultipleTypes(true);
        }
        if (cm.isArray && cm.getItems() != null && cm.getItems().complexType != null) {
            cm.imports.add(cm.getItems().complexType);
        }
        if (cm.isArray && cm.getItems() != null && cm.getItems().mostInnerItems != null && cm.getItems().mostInnerItems.complexType != null) {
            cm.imports.add(cm.getItems().mostInnerItems.complexType);
        }
        Boolean isNotPythonModelSimpleModel = ModelUtils.isComposedSchema(sc) || ModelUtils.isObjectSchema(sc) || ModelUtils.isMapSchema(sc);
        this.setAdditionalPropsAndItemsVarNames(cm);
        if (isNotPythonModelSimpleModel.booleanValue()) {
            return cm;
        }
        String defaultValue = this.toDefaultValue(sc);
        if (sc.getDefault() != null) {
            cm.defaultValue = defaultValue;
        }
        return cm;
    }

    @Override
    public String getSchemaType(Schema schema) {
        String openAPIType = this.getSingleSchemaType(schema);
        if (this.typeMapping.containsKey(openAPIType)) {
            String type = (String)this.typeMapping.get(openAPIType);
            return type;
        }
        return this.toModelName(openAPIType);
    }

    public String getModelName(Schema sc) {
        Schema unaliasedSchema;
        if (sc.get$ref() != null && (unaliasedSchema = this.unaliasSchema(sc, this.importMapping)).get$ref() != null) {
            return this.toModelName(ModelUtils.getSimpleRef(sc.get$ref()));
        }
        return null;
    }

    private String getTypeString(Schema p, String prefix, String suffix, List<String> referencedModelNames) {
        Schema unaliasedSchema;
        String fullSuffix = suffix;
        if (")".equals(suffix)) {
            fullSuffix = "," + suffix;
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)p.get$ref()) && (unaliasedSchema = this.unaliasSchema(p, this.importMapping)).get$ref() != null) {
            String modelName = this.toModelName(ModelUtils.getSimpleRef(p.get$ref()));
            if (referencedModelNames != null) {
                referencedModelNames.add(modelName);
            }
            return prefix + modelName + fullSuffix;
        }
        if (this.isAnyTypeSchema(p)) {
            return prefix + "bool, date, datetime, dict, float, int, list, str, none_type" + suffix;
        }
        if (ModelUtils.isNullable(ModelUtils.getReferencedSchema(this.openAPI, p))) {
            fullSuffix = ", none_type" + suffix;
        }
        if (this.isFreeFormObject(p) && this.getAdditionalProperties(p) == null) {
            return prefix + "bool, date, datetime, dict, float, int, list, str" + fullSuffix;
        }
        if (ModelUtils.isNumberSchema(p)) {
            return prefix + "int, float" + fullSuffix;
        }
        if ((ModelUtils.isMapSchema(p) || "object".equals(p.getType())) && this.getAdditionalProperties(p) != null) {
            Schema inner = this.getAdditionalProperties(p);
            return prefix + "{str: " + this.getTypeString(inner, "(", ")", referencedModelNames) + "}" + fullSuffix;
        }
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner == null) {
                Schema anyType = new Schema();
                return this.getTypeString(anyType, "[", "]", referencedModelNames);
            }
            return prefix + this.getTypeString(inner, "[", "]", referencedModelNames) + fullSuffix;
        }
        if (ModelUtils.isFileSchema(p)) {
            return prefix + "file_type" + fullSuffix;
        }
        String baseType = this.getSchemaType(p);
        return prefix + baseType + fullSuffix;
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        return this.getTypeString(p, "", "", null);
    }

    @Override
    public String toInstantiationType(Schema property) {
        if (ModelUtils.isArraySchema(property) || ModelUtils.isMapSchema(property) || property.getAdditionalProperties() != null) {
            return this.getSchemaType(property);
        }
        return super.toInstantiationType(property);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        Schema addProps = this.getAdditionalProperties(schema);
        if (addProps != null) {
            ArrayList<String> referencedModelNames = new ArrayList<String>();
            codegenModel.additionalPropertiesType = this.getTypeString(addProps, "", "", referencedModelNames);
            if (referencedModelNames.size() != 0) {
                codegenModel.imports.addAll(referencedModelNames);
            }
        }
    }

    protected Object getObjectExample(Schema sc) {
        Boolean objectModel;
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((objectModel = Boolean.valueOf(ModelUtils.isObjectSchema(schema) || ModelUtils.isMapSchema(schema) || ModelUtils.isComposedSchema(schema))).booleanValue()) {
            return null;
        }
        if (schema.getExample() != null) {
            return schema.getExample();
        }
        if (schema.getDefault() != null) {
            return schema.getDefault();
        }
        if (schema.getEnum() != null && !schema.getEnum().isEmpty()) {
            return schema.getEnum().get(0);
        }
        return null;
    }

    private String ensureQuotes(String in) {
        Pattern pattern = Pattern.compile("\r\n|\r|\n");
        Matcher matcher = pattern.matcher(in);
        if (matcher.find()) {
            return "'''" + in + "'''";
        }
        String strPattern = "^['\"].*?['\"]$";
        if (in.matches(strPattern)) {
            return in;
        }
        return "\"" + in + "\"";
    }

    public String toExampleValue(Schema schema, Object objExample) {
        String modelName = this.getModelName(schema);
        return this.toExampleValueRecursive(modelName, schema, objExample, 1, "", 0, new ArrayList<Schema>());
    }

    private Boolean simpleStringSchema(Schema schema) {
        Schema sc = schema;
        String ref = schema.get$ref();
        if (ref != null) {
            sc = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if (!(!ModelUtils.isStringSchema(sc) || ModelUtils.isDateSchema(sc) || ModelUtils.isDateTimeSchema(sc) || "Number".equalsIgnoreCase(sc.getFormat()) || ModelUtils.isByteArraySchema(sc) || ModelUtils.isBinarySchema(sc) || schema.getPattern() != null)) {
            return true;
        }
        return false;
    }

    private CodegenDiscriminator.MappedModel getDiscriminatorMappedModel(CodegenDiscriminator disc) {
        for (CodegenDiscriminator.MappedModel mm : disc.getMappedModels()) {
            String modelName = mm.getModelName();
            Schema modelSchema = this.getModelNameToSchemaCache().get(modelName);
            if (!ModelUtils.isObjectSchema(modelSchema)) continue;
            return mm;
        }
        return null;
    }

    private String toExampleValueRecursive(String modelName, Schema schema, Object objExample, int indentationLevel, String prefix, Integer exampleLine, List<Schema> includedSchemas) {
        boolean couldHaveCycle = includedSchemas.size() > 0 && this.potentiallySelfReferencingSchema(schema);
        boolean cycleFound = false;
        if (couldHaveCycle) {
            cycleFound = includedSchemas.subList(0, includedSchemas.size() - 1).stream().anyMatch(s -> schema.equals(s));
        }
        String indentionConst = "    ";
        String currentIndentation = "";
        String closingIndentation = "";
        for (int i = 0; i < indentationLevel; ++i) {
            currentIndentation = currentIndentation + "    ";
        }
        if (exampleLine.equals(0)) {
            closingIndentation = currentIndentation;
            currentIndentation = "";
        } else {
            closingIndentation = currentIndentation;
        }
        String openChars = "";
        String closeChars = "";
        if (modelName != null) {
            openChars = modelName + "(";
            closeChars = ")";
        }
        String fullPrefix = currentIndentation + prefix + openChars;
        String example = null;
        if (objExample != null) {
            example = objExample.toString();
        }
        if (null != schema.get$ref()) {
            String ref;
            Map<String, Schema> allDefinitions = ModelUtils.getSchemas(this.openAPI);
            Schema refSchema = allDefinitions.get(ref = ModelUtils.getSimpleRef(schema.get$ref()));
            if (null == refSchema) {
                this.LOGGER.warn("Unable to find referenced schema " + schema.get$ref() + "\n");
                return fullPrefix + "None" + closeChars;
            }
            String refModelName = this.getModelName(schema);
            return this.toExampleValueRecursive(refModelName, refSchema, objExample, indentationLevel, prefix, exampleLine, includedSchemas);
        }
        if (ModelUtils.isNullType(schema) || this.isAnyTypeSchema(schema)) {
            return fullPrefix + "None" + closeChars;
        }
        if (ModelUtils.isBooleanSchema(schema)) {
            example = objExample == null ? "True" : ("false".equalsIgnoreCase(objExample.toString()) ? "False" : "True");
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateSchema(schema)) {
            example = objExample == null ? this.pythonDate("1970-01-01") : this.pythonDate(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isDateTimeSchema(schema)) {
            example = objExample == null ? this.pythonDateTime("1970-01-01T00:00:00.00Z") : this.pythonDateTime(objExample);
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isBinarySchema(schema)) {
            if (objExample == null) {
                example = "/path/to/file";
            }
            example = "open('" + example + "', 'rb')";
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isByteArraySchema(schema)) {
            if (objExample == null) {
                example = "'YQ=='";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isStringSchema(schema)) {
            if (objExample == null) {
                if ("Number".equalsIgnoreCase(schema.getFormat())) {
                    example = "2";
                    return fullPrefix + example + closeChars;
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)schema.getPattern())) {
                    String pattern = schema.getPattern();
                    RgxGen rgxGen = new RgxGen((CharSequence)pattern);
                    Random random = new Random(18L);
                    String sample = rgxGen.generate(random);
                    Pattern valueExtractor = Pattern.compile("^/?(.+?)/?.?$");
                    Matcher m = valueExtractor.matcher(sample);
                    example = m.find() ? m.group(m.groupCount()) : "";
                } else if (schema.getMinLength() != null) {
                    example = "";
                    int len = schema.getMinLength();
                    for (int i = 0; i < len; ++i) {
                        example = example + "a";
                    }
                } else {
                    example = ModelUtils.isUUIDSchema(schema) ? "046b6c7f-0b8a-43b9-b35d-6489e6daee91" : "string_example";
                }
            }
            return fullPrefix + this.ensureQuotes(example) + closeChars;
        }
        if (ModelUtils.isIntegerSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "1";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isNumberSchema(schema)) {
            if (objExample == null) {
                example = schema.getMinimum() != null ? schema.getMinimum().toString() : "3.14";
            }
            return fullPrefix + example + closeChars;
        }
        if (ModelUtils.isArraySchema(schema)) {
            if (objExample instanceof Iterable) {
                return fullPrefix + objExample.toString();
            }
            ArraySchema arrayschema = (ArraySchema)schema;
            Schema itemSchema = arrayschema.getItems();
            String itemModelName = this.getModelName(itemSchema);
            includedSchemas.add(schema);
            String itemExample = this.toExampleValueRecursive(itemModelName, itemSchema, objExample, indentationLevel + 1, "", exampleLine + 1, includedSchemas);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)itemExample) || cycleFound) {
                return fullPrefix + "[]";
            }
            return fullPrefix + "[\n" + itemExample + "\n" + closingIndentation + "]" + closeChars;
        }
        if (ModelUtils.isMapSchema(schema)) {
            Object addPropsObj;
            if (modelName == null) {
                fullPrefix = fullPrefix + "dict(";
                closeChars = ")";
            }
            if ((addPropsObj = schema.getAdditionalProperties()) instanceof Schema && !cycleFound) {
                Schema addPropsSchema = (Schema)addPropsObj;
                String key = "key";
                Object addPropsExample = this.getObjectExample(addPropsSchema);
                if (addPropsSchema.getEnum() != null && !addPropsSchema.getEnum().isEmpty()) {
                    key = addPropsSchema.getEnum().get(0).toString();
                }
                addPropsExample = this.exampleFromStringOrArraySchema(addPropsSchema, addPropsExample, key);
                String addPropPrefix = key + "=";
                if (modelName == null) {
                    addPropPrefix = this.ensureQuotes(key) + ": ";
                }
                String addPropsModelName = this.getModelName(addPropsSchema);
                includedSchemas.add(schema);
                example = fullPrefix + "\n" + this.toExampleValueRecursive(addPropsModelName, addPropsSchema, addPropsExample, indentationLevel + 1, addPropPrefix, exampleLine + 1, includedSchemas) + ",\n" + closingIndentation + closeChars;
            } else {
                example = fullPrefix + closeChars;
            }
            return example;
        }
        if (ModelUtils.isObjectSchema(schema)) {
            if (modelName == null) {
                fullPrefix = fullPrefix + "dict(";
                closeChars = ")";
            }
            if (cycleFound) {
                return fullPrefix + closeChars;
            }
            CodegenDiscriminator disc = this.createDiscriminator(modelName, schema, this.openAPI);
            if (disc != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm != null) {
                    String discPropNameValue = mm.getMappingName();
                    String addPropsExample = mm.getModelName();
                } else {
                    return fullPrefix + closeChars;
                }
            }
            return this.exampleForObjectModel(schema, fullPrefix, closeChars, null, indentationLevel, exampleLine, closingIndentation, includedSchemas);
        }
        if (ModelUtils.isComposedSchema(schema)) {
            if (cycleFound) {
                return fullPrefix + closeChars;
            }
            CodegenDiscriminator disc = this.createDiscriminator(modelName, schema, this.openAPI);
            if (disc != null) {
                CodegenDiscriminator.MappedModel mm = this.getDiscriminatorMappedModel(disc);
                if (mm != null) {
                    String discPropNameValue = mm.getMappingName();
                    String chosenModelName = mm.getModelName();
                    Schema modelSchema = this.getModelNameToSchemaCache().get(chosenModelName);
                    CodegenProperty cp = new CodegenProperty();
                    cp.setName(disc.getPropertyName());
                    cp.setExample(discPropNameValue);
                    return this.exampleForObjectModel(modelSchema, fullPrefix, closeChars, cp, indentationLevel, exampleLine, closingIndentation, includedSchemas);
                }
                return fullPrefix + closeChars;
            }
            return fullPrefix + closeChars;
        }
        this.LOGGER.warn("Type " + schema.getType() + " not handled properly in toExampleValue");
        return example;
    }

    private boolean potentiallySelfReferencingSchema(Schema schema) {
        return null != schema.get$ref() || ModelUtils.isArraySchema(schema) || ModelUtils.isMapSchema(schema) || ModelUtils.isObjectSchema(schema) || ModelUtils.isComposedSchema(schema);
    }

    private String exampleForObjectModel(Schema schema, String fullPrefix, String closeChars, CodegenProperty discProp, int indentationLevel, int exampleLine, String closingIndentation, List<Schema> includedSchemas) {
        Map requiredAndOptionalProps = schema.getProperties();
        if (requiredAndOptionalProps == null || requiredAndOptionalProps.isEmpty()) {
            return fullPrefix + closeChars;
        }
        String example = fullPrefix + "\n";
        for (Map.Entry entry : requiredAndOptionalProps.entrySet()) {
            String propName = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            propName = this.toVarName(propName);
            String propModelName = null;
            Object propExample = null;
            if (discProp != null && propName.equals(discProp.name)) {
                propModelName = null;
                propExample = discProp.example;
            } else {
                propModelName = this.getModelName(propSchema);
                propExample = this.exampleFromStringOrArraySchema(propSchema, null, propName);
            }
            includedSchemas.add(schema);
            example = example + this.toExampleValueRecursive(propModelName, propSchema, propExample, indentationLevel + 1, propName + "=", exampleLine + 1, includedSchemas) + ",\n";
        }
        example = example + closingIndentation + closeChars;
        return example;
    }

    private Object exampleFromStringOrArraySchema(Schema sc, Object currentExample, String propName) {
        Object example;
        if (currentExample != null) {
            return currentExample;
        }
        Schema schema = sc;
        String ref = sc.get$ref();
        if (ref != null) {
            schema = ModelUtils.getSchema(this.openAPI, ModelUtils.getSimpleRef(ref));
        }
        if ((example = this.getObjectExample(schema)) != null) {
            return example;
        }
        if (this.simpleStringSchema(schema).booleanValue()) {
            return propName + "_example";
        }
        if (ModelUtils.isArraySchema(schema)) {
            ArraySchema arraySchema = (ArraySchema)schema;
            Schema itemSchema = arraySchema.getItems();
            example = this.getObjectExample(itemSchema);
            if (example != null) {
                return example;
            }
            if (this.simpleStringSchema(itemSchema).booleanValue()) {
                return propName + "_example";
            }
        }
        return null;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        String finalExample;
        Schema schema = parameter.getSchema();
        if (schema == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because parameter lacks a schema");
            return;
        }
        Object example = null;
        example = codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example") ? codegenParameter.vendorExtensions.get("x-example") : (parameter.getExample() != null ? parameter.getExample() : (parameter.getExamples() != null && !parameter.getExamples().isEmpty() && ((Example)parameter.getExamples().values().iterator().next()).getValue() != null ? ((Example)parameter.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema)));
        example = this.exampleFromStringOrArraySchema(schema, example, parameter.getName());
        codegenParameter.example = finalExample = this.toExampleValue(schema, example);
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, RequestBody requestBody) {
        MediaType mediaType;
        Schema schema;
        Content content;
        if (codegenParameter.vendorExtensions != null && codegenParameter.vendorExtensions.containsKey("x-example")) {
            codegenParameter.example = Json.pretty((Object)codegenParameter.vendorExtensions.get("x-example"));
        }
        if ((content = requestBody.getContent()).size() > 1) {
            OnceLogger.once(this.LOGGER).warn("Multiple MediaTypes found, using only the first one");
        }
        if ((schema = (mediaType = (MediaType)content.values().iterator().next()).getSchema()) == null) {
            this.LOGGER.warn("CodegenParameter.example defaulting to null because requestBody content lacks a schema");
            return;
        }
        Object example = null;
        example = mediaType.getExample() != null ? mediaType.getExample() : (mediaType.getExamples() != null && !mediaType.getExamples().isEmpty() && ((Example)mediaType.getExamples().values().iterator().next()).getValue() != null ? ((Example)mediaType.getExamples().values().iterator().next()).getValue() : this.getObjectExample(schema));
        example = this.exampleFromStringOrArraySchema(schema, example, codegenParameter.paramName);
        codegenParameter.example = this.toExampleValue(schema, example);
    }

    @Override
    public CodegenParameter fromFormProperty(String name, Schema propertySchema, Set<String> imports) {
        CodegenParameter cp = super.fromFormProperty(name, propertySchema, imports);
        Parameter p = new Parameter();
        p.setSchema(propertySchema);
        p.setName(cp.paramName);
        this.setParameterExampleValue(cp, p);
        return cp;
    }

    @Override
    protected Map<String, Schema> getModelNameToSchemaCache() {
        if (this.modelNameToSchemaCache == null) {
            HashMap m = new HashMap();
            ModelUtils.getSchemas(this.openAPI).forEach((key, schema) -> m.put(this.toModelName((String)key), schema));
            this.modelNameToSchemaCache = Collections.unmodifiableMap(m);
        }
        return this.modelNameToSchemaCache;
    }

    @Override
    protected void setAddProps(Schema schema, IJsonSchemaValidationProperties property) {
        if (schema.equals((Object)new Schema())) {
            return;
        }
        boolean additionalPropertiesIsAnyType = false;
        CodegenModel m = null;
        if (property instanceof CodegenModel) {
            m = (CodegenModel)property;
        }
        CodegenProperty addPropProp = null;
        boolean isAdditionalPropertiesTrue = false;
        if (schema.getAdditionalProperties() == null) {
            if (!this.disallowAdditionalPropertiesIfNotPresent) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty(String.valueOf(property.hashCode()), new Schema());
                addPropProp.name = "";
                addPropProp.baseName = "";
                addPropProp.nameInSnakeCase = null;
                additionalPropertiesIsAnyType = true;
            }
        } else if (schema.getAdditionalProperties() instanceof Boolean) {
            if (Boolean.TRUE.equals(schema.getAdditionalProperties())) {
                isAdditionalPropertiesTrue = true;
                addPropProp = this.fromProperty(String.valueOf(property.hashCode()), new Schema());
                addPropProp.name = "";
                addPropProp.baseName = "";
                addPropProp.nameInSnakeCase = null;
                additionalPropertiesIsAnyType = true;
            }
        } else {
            addPropProp = this.fromProperty(String.valueOf(property.hashCode()), (Schema)schema.getAdditionalProperties());
            addPropProp.name = "";
            addPropProp.baseName = "";
            addPropProp.nameInSnakeCase = null;
            if (this.isAnyTypeSchema((Schema)schema.getAdditionalProperties())) {
                additionalPropertiesIsAnyType = true;
            }
        }
        if (additionalPropertiesIsAnyType) {
            property.setAdditionalPropertiesIsAnyType(true);
        }
        if (m != null && isAdditionalPropertiesTrue) {
            m.isAdditionalPropertiesTrue = true;
        }
        if (ModelUtils.isComposedSchema(schema) && !this.supportsAdditionalPropertiesWithComposedSchema) {
            return;
        }
        if (addPropProp != null) {
            property.setAdditionalProperties(addPropProp);
        }
    }

    @Override
    protected void updatePropertyForArray(CodegenProperty property, CodegenProperty innerProperty) {
        if (innerProperty == null) {
            if (this.LOGGER.isWarnEnabled()) {
                this.LOGGER.warn("skipping invalid array property {}", (Object)Json.pretty((Object)property));
            }
            return;
        }
        property.dataFormat = innerProperty.dataFormat;
        if (this.languageSpecificPrimitives.contains(innerProperty.baseType)) {
            property.isPrimitiveType = true;
        }
        property.items = innerProperty;
        property.mostInnerItems = this.getMostInnerItems(innerProperty);
        if (this.isPropertyInnerMostEnum(property).booleanValue()) {
            property.isEnum = true;
            this.updateDataTypeWithEnumForArray(property);
            property.allowableValues = this.getInnerEnumAllowableValues(property);
        }
    }

    @Override
    protected void updatePropertyForString(CodegenProperty property, Schema p) {
        if (ModelUtils.isByteArraySchema(p)) {
            property.isByteArray = true;
            property.setIsString(false);
        } else if (ModelUtils.isBinarySchema(p)) {
            property.isBinary = true;
            property.isFile = true;
        } else if (ModelUtils.isUUIDSchema(p)) {
            property.isUuid = true;
        } else if (ModelUtils.isURISchema(p)) {
            property.isUri = true;
        } else if (ModelUtils.isEmailSchema(p)) {
            property.isEmail = true;
        } else if (ModelUtils.isDateSchema(p)) {
            property.setIsString(false);
            property.isDate = true;
        } else if (ModelUtils.isDateTimeSchema(p)) {
            property.setIsString(false);
            property.isDateTime = true;
        } else if (ModelUtils.isDecimalSchema(p)) {
            property.isDecimal = true;
            property.setIsString(false);
        }
        property.pattern = this.toRegularExpression(p.getPattern());
    }

    @Override
    protected void updatePropertyForObject(CodegenProperty property, Schema p) {
        this.addVarsRequiredVarsAdditionalProps(p, property);
    }

    @Override
    protected void updatePropertyForAnyType(CodegenProperty property, Schema p) {
        if (Boolean.FALSE.equals(p.getNullable())) {
            this.LOGGER.warn("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)p.getName());
        }
        this.addVarsRequiredVarsAdditionalProps(p, property);
    }

    @Override
    protected void updateModelForObject(CodegenModel m, Schema schema) {
        if (schema.getProperties() != null || schema.getRequired() != null) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        this.addAdditionPropertiesToCodeGenModel(m, schema);
        this.setAddProps(schema, m);
    }

    @Override
    protected void updateModelForAnyType(CodegenModel m, Schema schema) {
        if (Boolean.FALSE.equals(schema.getNullable())) {
            this.LOGGER.error("Schema '{}' is any type, which includes the 'null' value. 'nullable' cannot be set to 'false'", (Object)m.name);
        }
        if (schema.getProperties() != null || schema.getRequired() != null) {
            this.addVars(m, this.unaliasPropertySchema(schema.getProperties()), schema.getRequired(), null, null);
        }
        this.addAdditionPropertiesToCodeGenModel(m, schema);
        this.setAddProps(schema, m);
    }

    @Override
    protected void updateModelForComposedSchema(CodegenModel m, Schema schema, Map<String, Schema> allDefinitions) {
        CodegenComposedSchemas cs;
        ComposedSchema composed = (ComposedSchema)schema;
        if (composed.getAllOf() != null) {
            int modelImplCnt = 0;
            int modelDiscriminators = 0;
            for (Schema innerSchema : composed.getAllOf()) {
                if (m.discriminator == null && innerSchema.getDiscriminator() != null) {
                    this.LOGGER.debug("discriminator is set to null (not correctly set earlier): {}", (Object)m.name);
                    m.setDiscriminator(this.createDiscriminator(m.name, innerSchema, this.openAPI));
                    if (!this.getLegacyDiscriminatorBehavior().booleanValue()) {
                        m.addDiscriminatorMappedModelsImports();
                    }
                    ++modelDiscriminators;
                }
                if (innerSchema.getXml() != null) {
                    m.xmlPrefix = innerSchema.getXml().getPrefix();
                    m.xmlNamespace = innerSchema.getXml().getNamespace();
                    m.xmlName = innerSchema.getXml().getName();
                }
                if (modelDiscriminators > 1) {
                    this.LOGGER.error("Allof composed schema is inheriting >1 discriminator. Only use one discriminator: {}", (Object)composed);
                }
                if (modelImplCnt++ <= 1) continue;
                this.LOGGER.warn("More than one inline schema specified in allOf:. Only the first one is recognized. All others are ignored.");
                break;
            }
        }
        if ((cs = m.getComposedSchemas()) != null) {
            if (cs.getAllOf() != null && !cs.getAllOf().isEmpty()) {
                for (CodegenProperty cp : cs.getAllOf()) {
                    if (cp.complexType == null) continue;
                    this.addImport(m, cp.complexType);
                }
            }
            if (cs.getOneOf() != null && !cs.getOneOf().isEmpty()) {
                for (CodegenProperty cp : cs.getOneOf()) {
                    if (cp.complexType == null) continue;
                    this.addImport(m, cp.complexType);
                }
            }
            if (cs.getAnyOf() != null && !cs.getAnyOf().isEmpty()) {
                for (CodegenProperty cp : cs.getAnyOf()) {
                    if (cp.complexType == null) continue;
                    this.addImport(m, cp.complexType);
                }
            }
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        return this.postProcessModelsEnum(objs);
    }

    public void postProcessPattern(String pattern, Map<String, Object> vendorExtensions) {
        if (pattern != null) {
            int i = pattern.lastIndexOf(47);
            if (pattern.charAt(0) != '/' || i < 2) {
                throw new IllegalArgumentException("Pattern must follow the Perl /pattern/modifiers convention. " + pattern + " is not valid.");
            }
            String regex = pattern.substring(1, i).replace("'", "\\'");
            ArrayList<String> modifiers = new ArrayList<String>();
            for (char c : pattern.substring(i).toCharArray()) {
                if (!this.regexModifiers.containsKey(Character.valueOf(c))) continue;
                String modifier = this.regexModifiers.get(Character.valueOf(c));
                modifiers.add(modifier);
            }
            vendorExtensions.put("x-regex", regex);
            vendorExtensions.put("x-modifiers", modifiers);
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String apiDocFileFolder() {
        return this.outputFolder + "/" + this.apiDocPath;
    }

    @Override
    public String modelDocFileFolder() {
        return this.outputFolder + "/" + this.modelDocPath;
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separatorChar + this.packagePath() + File.separatorChar + this.apiPackage();
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separatorChar + this.packagePath() + File.separatorChar + this.modelPackage();
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separatorChar + this.testFolder;
    }

    public void setUseNose(String val) {
        this.useNose = Boolean.parseBoolean(val);
    }

    public void setPackageUrl(String packageUrl) {
        this.packageUrl = packageUrl;
    }

    public String packagePath() {
        return this.packageName.replace('.', File.separatorChar);
    }

    public String generatePackageName(String packageName) {
        return StringUtils.underscore(packageName.replaceAll("[^\\w]+", ""));
    }

    @Override
    public List<CodegenParameter> fromRequestBodyToFormParameters(RequestBody body, Set<String> imports) {
        ArrayList<CodegenParameter> parameters = new ArrayList<CodegenParameter>();
        this.LOGGER.debug("debugging fromRequestBodyToFormParameters= {}", (Object)body);
        Schema schema = ModelUtils.getSchemaFromRequestBody(body);
        schema = ModelUtils.getReferencedSchema(this.openAPI, schema);
        CodegenParameter cp = this.fromFormProperty("body", schema, imports);
        cp.setContent(this.getContent(body.getContent(), imports, "RequestBody"));
        cp.isFormParam = false;
        cp.isBodyParam = true;
        parameters.add(cp);
        return parameters;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation co = super.fromOperation(path, httpMethod, operation, servers);
        if (co.bodyParam == null) {
            for (CodegenParameter cp : co.allParams) {
                if (!cp.isBodyParam) continue;
                co.bodyParam = cp;
                co.bodyParams.add(cp);
            }
        }
        return co;
    }

    @Override
    public String defaultTemplatingEngine() {
        return "handlebars";
    }

    @Override
    public String generatorLanguageVersion() {
        return ">=3.9";
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String originalSpecVersion = openAPI.getExtensions() != null && !openAPI.getExtensions().isEmpty() ? (String)openAPI.getExtensions().get("x-original-swagger-version") : openAPI.getOpenapi();
        Integer specMajorVersion = Integer.parseInt(originalSpecVersion.substring(0, 1));
        if (specMajorVersion < 3) {
            throw new RuntimeException("Your spec version of " + originalSpecVersion + " is too low. python-experimental only works with specs with version >= 3.X.X. Please use a tool like Swagger Editor or Swagger Converter to convert your spec to v3");
        }
    }
}

