/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;

public class JavaPKMSTServerCodegen
extends AbstractJavaCodegen {
    public static final String CONFIG_PACKAGE = "configPackage";
    public static final String BASE_PACKAGE = "basePackage";
    public static final String TITLE = "title";
    public static final String EUREKA_URI = "eurekaUri";
    public static final String ZIPKIN_URI = "zipkinUri";
    public static final String SPRINGADMIN_URI = "springBootAdminUri";
    protected String basePackage = "com.prokarma.pkmst";
    protected String serviceName = "Pkmst";
    protected String configPackage = "com.prokarma.pkmst.config";
    protected String title;
    protected String eurekaUri;
    protected String zipkinUri;
    protected String springBootAdminUri;

    public JavaPKMSTServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.groupId = "com.prokarma";
        this.artifactId = "pkmst-microservice";
        this.templateDir = "java-pkmst";
        this.embeddedTemplateDir = "java-pkmst";
        this.apiPackage = "com.prokarma.pkmst.controller";
        this.modelPackage = "com.prokarma.pkmst.model";
        this.invokerPackage = "com.prokarma.pkmst.controller";
        this.updateOption("groupId", this.getGroupId());
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption(BASE_PACKAGE, "base package for java source code"));
        this.cliOptions.add(new CliOption("serviceName", "Service Name"));
        this.cliOptions.add(new CliOption(TITLE, "server title name or client service name"));
        this.cliOptions.add(new CliOption(EUREKA_URI, "Eureka URI"));
        this.cliOptions.add(new CliOption(ZIPKIN_URI, "Zipkin URI"));
        this.cliOptions.add(new CliOption(SPRINGADMIN_URI, "Spring-Boot URI"));
        this.cliOptions.add(new CliOption("pkmstInterceptor", "PKMST Interceptor"));
        this.apiTestTemplateFiles.put("api_test.mustache", ".java");
        if (".md".equals(this.modelDocTemplateFiles.get("model_doc.mustache"))) {
            this.modelDocTemplateFiles.remove("model_doc.mustache");
        }
        if (".md".equals(this.apiDocTemplateFiles.get("api_doc.mustache"))) {
            this.apiDocTemplateFiles.remove("api_doc.mustache");
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-pkmst";
    }

    @Override
    public String getHelp() {
        return "Generates a PKMST SpringBoot Server application using the SpringFox integration. Also enables EurekaServerClient / Zipkin / Spring-Boot admin";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BASE_PACKAGE)) {
            this.setBasePackage((String)this.additionalProperties.get(BASE_PACKAGE));
            this.setInvokerPackage(this.getBasePackage());
            this.apiPackage = this.getBasePackage() + ".controller";
            this.modelPackage = this.getBasePackage() + ".model";
            this.setConfigPackage(this.getBasePackage() + ".config");
        } else {
            this.additionalProperties.put(BASE_PACKAGE, this.basePackage);
            this.additionalProperties.put(CONFIG_PACKAGE, this.getConfigPackage());
            this.additionalProperties.put("apiPackage", this.apiPackage);
            this.additionalProperties.put("modelPackage", this.modelPackage);
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("groupId")) {
            this.setGroupId((String)this.additionalProperties.get("groupId"));
        } else {
            this.additionalProperties.put("groupId", this.groupId);
        }
        if (this.additionalProperties.containsKey("artifactId")) {
            this.setArtifactId((String)this.additionalProperties.get("artifactId"));
        } else {
            this.additionalProperties.put("artifactId", this.artifactId);
        }
        if (this.additionalProperties.containsKey("artifactVersion")) {
            this.setArtifactVersion((String)this.additionalProperties.get("artifactVersion"));
        } else {
            this.additionalProperties.put("artifactVersion", this.artifactVersion);
        }
        if (this.additionalProperties.containsKey("serviceName")) {
            this.setServiceName((String)this.additionalProperties.get("serviceName"));
        } else {
            this.additionalProperties.put("serviceName", this.serviceName);
        }
        if (this.additionalProperties.containsKey("bigDecimalAsString")) {
            this.setSerializeBigDecimalAsString(Boolean.parseBoolean(this.additionalProperties.get("bigDecimalAsString").toString()));
        }
        if (this.additionalProperties.containsKey("serializableModel")) {
            this.setSerializableModel(Boolean.valueOf(this.additionalProperties.get("serializableModel").toString()));
        }
        if (this.additionalProperties.containsKey(TITLE)) {
            this.setTitle((String)this.additionalProperties.get(TITLE));
        }
        this.additionalProperties.put("serializableModel", this.serializableModel);
        if (this.additionalProperties.containsKey("fullJavaUtil")) {
            this.setFullJavaUtil(Boolean.parseBoolean(this.additionalProperties.get("fullJavaUtil").toString()));
        }
        if (this.additionalProperties.containsKey(EUREKA_URI)) {
            this.setEurekaUri((String)this.additionalProperties.get(EUREKA_URI));
        }
        if (this.additionalProperties.containsKey(ZIPKIN_URI)) {
            this.setZipkinUri((String)this.additionalProperties.get(ZIPKIN_URI));
        }
        if (this.additionalProperties.containsKey(SPRINGADMIN_URI)) {
            this.setSpringBootAdminUri((String)this.additionalProperties.get(SPRINGADMIN_URI));
        }
        if (this.fullJavaUtil) {
            this.javaUtilPrefix = "java.util.";
        }
        this.additionalProperties.put("fullJavaUtil", this.fullJavaUtil);
        this.additionalProperties.put("javaUtilPrefix", this.javaUtilPrefix);
        this.additionalProperties.put("supportJava6", false);
        this.additionalProperties.put("java8", true);
        if (this.additionalProperties.containsKey("withXml")) {
            this.setWithXml(Boolean.parseBoolean(this.additionalProperties.get("withXml").toString()));
        }
        this.additionalProperties.put("withXml", this.withXml);
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTemplateFiles.put("apiController.mustache", "Controller.java");
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.supportingFiles.add(new SupportingFile("SpringBootApplication.mustache", (this.getSourceFolder() + File.separator + this.getBasePackage()).replace(".", File.separator), this.getServiceName() + "Application.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "openapiDocumentationConfig.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator + "swagger", "OpenAPIDocumentationConfig.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "pkmstproperties.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator + "swagger", "PkmstProperties.java"));
        this.supportingFiles.add(new SupportingFile("config" + File.separator + "appconfig.mustache", (this.sourceFolder + File.separator + this.getConfigPackage()).replace(".", File.separator) + File.separator, "AppConfig.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "authorizationServerConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "AuthorizationServerConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "oAuth2SecurityConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "OAuth2SecurityConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("security" + File.separator + "resourceServerConfiguration.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "security", "ResourceServerConfiguration.java"));
        this.supportingFiles.add(new SupportingFile("logging" + File.separator + "httpLoggingFilter.mustache", (this.sourceFolder + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "logging", "HttpLoggingFilter.java"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-local.mustache", "src.main.resources".replace(".", File.separator), "application-local.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-dev.mustache", "src.main.resources".replace(".", File.separator), "application-dev.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "application-dev-config.mustache", "src.main.resources".replace(".", File.separator), "application-dev-config.yml"));
        this.supportingFiles.add(new SupportingFile("resources" + File.separator + "bootstrap.mustache", "src.main.resources".replace(".", File.separator), "bootstrap.yml"));
        this.supportingFiles.add(new SupportingFile("pom.mustache", "", "pom.xml"));
        this.supportingFiles.add(new SupportingFile("readme.mustache", "", "Readme.md"));
        this.supportingFiles.add(new SupportingFile("manifest.mustache", "", "manifest.yml"));
        this.supportingFiles.add(new SupportingFile("docker.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("logstash.mustache", "", "logstash.conf"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "executeReport.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber" + File.separator + "report", "ExecuteReport.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumberTest.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "Test.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumberSteps.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "Steps.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "package.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "cucumber", this.serviceName + "package-info.java"));
        this.supportingFiles.add(new SupportingFile("cucumber" + File.separator + "cucumber.mustache", ("src.test.resources" + File.separator + this.basePackage).replace(".", File.separator) + File.separator + "cucumber", this.serviceName + ".feature"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "bootstrap.mustache", "src.test.resources".replace(".", File.separator), "bootstrap.yml"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "application.mustache", "src.test.resources".replace(".", File.separator), "application.properties"));
        this.supportingFiles.add(new SupportingFile("testresources" + File.separator + "application-test.mustache", "src.test.resources".replace(".", File.separator), "application-test.properties"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "gatling.mustache", "src.test.resources".replace(".", File.separator), "gatling.conf"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "application.mustache", "src.test.resources".replace(".", File.separator), "application.conf"));
        this.supportingFiles.add(new SupportingFile("gatling" + File.separator + "testapi.mustache", "src" + File.separator + "test" + File.separator + "scala" + File.separator + "scalaFiles".replace(".", File.separator), "testapi.scala"));
        this.supportingFiles.add(new SupportingFile("integration" + File.separator + "integrationtest.mustache", this.testFolder + File.separator + this.basePackage.replace(".", File.separator) + File.separator + "controller", this.serviceName + "IT.java"));
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (final CodegenOperation operation : ops) {
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (final CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        this.doDataTypeAssignment(resp.dataType, new DataTypeAssigner(){

                            @Override
                            public void setReturnType(String returnType) {
                                resp.dataType = returnType;
                            }

                            @Override
                            public void setReturnContainer(String returnContainer) {
                                resp.containerType = returnContainer;
                            }
                        });
                    }
                }
                this.doDataTypeAssignment(operation.returnType, new DataTypeAssigner(){

                    @Override
                    public void setReturnType(String returnType) {
                        operation.returnType = returnType;
                    }

                    @Override
                    public void setReturnContainer(String returnContainer) {
                        operation.returnContainer = returnContainer;
                    }
                });
                this.handleImplicitHeaders(operation);
            }
        }
        return objs;
    }

    private void doDataTypeAssignment(String returnType, DataTypeAssigner dataTypeAssigner) {
        int end;
        String rt = returnType;
        if (rt == null) {
            dataTypeAssigner.setReturnType("Void");
        } else if (rt.startsWith("List")) {
            int end2 = rt.lastIndexOf(">");
            if (end2 > 0) {
                dataTypeAssigner.setReturnType(rt.substring("List<".length(), end2).trim());
                dataTypeAssigner.setReturnContainer("List");
            }
        } else if (rt.startsWith("Map")) {
            int end3 = rt.lastIndexOf(">");
            if (end3 > 0) {
                dataTypeAssigner.setReturnType(rt.substring("Map<".length(), end3).split(",")[1].trim());
                dataTypeAssigner.setReturnContainer("Map");
            }
        } else if (rt.startsWith("Set") && (end = rt.lastIndexOf(">")) > 0) {
            dataTypeAssigner.setReturnType(rt.substring("Set<".length(), end).trim());
            dataTypeAssigner.setReturnContainer("Set");
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("null".equals(property.example)) {
            property.example = null;
        }
        if (!Boolean.TRUE.equals(model.isEnum)) {
            model.imports.add("JsonProperty");
            if (Boolean.TRUE.equals(model.hasEnums)) {
                model.imports.add("JsonValue");
            }
        } else if (this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public ModelsMap postProcessModelsEnum(ModelsMap objs) {
        objs = super.postProcessModelsEnum(objs);
        List<Map<String, String>> imports = objs.getImports();
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            if (!Boolean.TRUE.equals(cm.isEnum) || cm.allowableValues == null) continue;
            cm.imports.add((String)this.importMapping.get("JsonValue"));
            HashMap item = new HashMap();
            item.put("import", this.importMapping.get("JsonValue"));
            imports.add(item);
        }
        return objs;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Map vendorExt;
        super.preprocessOpenAPI(openAPI);
        if (openAPI == null || openAPI.getPaths() == null) {
            return;
        }
        if (openAPI.getTags() != null) {
            ArrayList<ResourcePath> resourcePaths = new ArrayList<ResourcePath>();
            for (Tag tag : openAPI.getTags()) {
                ResourcePath resourcePath = new ResourcePath();
                resourcePath.setPath(tag.getName());
                resourcePaths.add(resourcePath);
            }
            this.additionalProperties.put("resourcePaths", resourcePaths);
        }
        if ((vendorExt = openAPI.getInfo().getExtensions()) != null && !vendorExt.toString().isEmpty() && vendorExt.containsKey("x-codegen")) {
            Map uris = (Map)vendorExt.get("x-codegen");
            if (uris.containsKey(EUREKA_URI)) {
                String eurekaUri = (String)uris.get(EUREKA_URI);
                this.additionalProperties.put(EUREKA_URI, eurekaUri);
            }
            if (uris.containsKey(ZIPKIN_URI)) {
                String zipkinUri = (String)uris.get(ZIPKIN_URI);
                this.additionalProperties.put(ZIPKIN_URI, zipkinUri);
            }
            if (uris.containsKey(SPRINGADMIN_URI)) {
                String springBootAdminUri = (String)uris.get(SPRINGADMIN_URI);
                this.additionalProperties.put(SPRINGADMIN_URI, springBootAdminUri);
            }
            if (uris.containsKey("pkmstInterceptor")) {
                String pkmstInterceptor = (String)uris.get("pkmstInterceptor");
                this.additionalProperties.put("pkmstInterceptor", pkmstInterceptor);
            }
        }
        if (!this.additionalProperties.containsKey(TITLE)) {
            String title = openAPI.getInfo().getTitle();
            if (title != null) {
                if ((title = title.trim().replace(" ", "-")).toUpperCase(Locale.ROOT).endsWith("API")) {
                    title = title.substring(0, title.length() - 3);
                }
                this.title = StringUtils.camelize(this.sanitizeName(title), true);
            }
            this.additionalProperties.put(TITLE, this.title);
        }
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        this.additionalProperties.put("serverPort", URLPathUtils.getPort(url, 8080));
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        tags.add(value);
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        co.subresourceOperation = !co.path.isEmpty();
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name) + "Api";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace(".", "/");
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.testFolder + "/" + this.apiPackage().replace(".", "/");
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace(".", "/");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace("/", File.separator);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace("/", File.separator);
    }

    public void setEurekaUri(String eurekaUri) {
        this.eurekaUri = eurekaUri;
    }

    public void setZipkinUri(String zipkinUri) {
        this.zipkinUri = zipkinUri;
    }

    public void setSpringBootAdminUri(String springBootAdminUri) {
        this.springBootAdminUri = springBootAdminUri;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private static class ResourcePath {
        private String path;

        private ResourcePath() {
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String toString() {
            return this.path;
        }
    }

    private static interface DataTypeAssigner {
        public void setReturnType(String var1);

        public void setReturnContainer(String var1);
    }
}

