/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorSettings
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeneratorSettings.class);
    private static final String DEFAULT_GIT_HOST = "github.com";
    private static final String DEFAULT_GIT_USER_ID = "GIT_USER_ID";
    private static final String DEFAULT_GIT_REPO_ID = "GIT_REPO_ID";
    private static final String DEFAULT_RELEASE_NOTE = "Minor update";
    private String generatorName;
    private String apiPackage;
    private String modelPackage;
    private String invokerPackage;
    private String packageName;
    private String apiNameSuffix;
    private String modelNamePrefix;
    private String modelNameSuffix;
    private String groupId;
    private String artifactId;
    private String artifactVersion;
    private String library;
    private final Map<String, String> instantiationTypes;
    private final Map<String, String> typeMappings;
    private final Map<String, Object> additionalProperties;
    private final Map<String, String> importMappings;
    private final Map<String, String> schemaMappings;
    private final Map<String, String> inlineSchemaNameMappings;
    private final Map<String, String> inlineSchemaNameDefaults;
    private final Map<String, String> openapiNormalizer;
    private final Set<String> languageSpecificPrimitives;
    private final Map<String, String> reservedWordsMappings;
    private final Map<String, String> serverVariables;
    private String gitHost;
    private String gitUserId;
    private String gitRepoId;
    private String releaseNote;
    private String httpUserAgent;

    public String getGeneratorName() {
        return this.generatorName;
    }

    public String getApiPackage() {
        return this.apiPackage;
    }

    public String getModelPackage() {
        return this.modelPackage;
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getApiNameSuffix() {
        return this.apiNameSuffix;
    }

    public String getModelNamePrefix() {
        return this.modelNamePrefix;
    }

    public String getModelNameSuffix() {
        return this.modelNameSuffix;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public String getLibrary() {
        return this.library;
    }

    public Map<String, String> getInstantiationTypes() {
        return this.instantiationTypes;
    }

    public Map<String, String> getTypeMappings() {
        return this.typeMappings;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Map<String, String> getImportMappings() {
        return this.importMappings;
    }

    public Map<String, String> getSchemaMappings() {
        return this.schemaMappings;
    }

    public Map<String, String> getInlineSchemaNameMappings() {
        return this.inlineSchemaNameMappings;
    }

    public Map<String, String> getInlineSchemaNameDefaults() {
        return this.inlineSchemaNameDefaults;
    }

    public Map<String, String> getOpenAPINormalizer() {
        return this.openapiNormalizer;
    }

    public Set<String> getLanguageSpecificPrimitives() {
        return this.languageSpecificPrimitives;
    }

    public Map<String, String> getReservedWordsMappings() {
        return this.reservedWordsMappings;
    }

    public Map<String, String> getServerVariables() {
        return this.serverVariables;
    }

    public String getGitHost() {
        return this.gitHost;
    }

    public String getGitUserId() {
        return this.gitUserId;
    }

    public String getGitRepoId() {
        return this.gitRepoId;
    }

    public String getReleaseNote() {
        return this.releaseNote;
    }

    public String getHttpUserAgent() {
        return this.httpUserAgent;
    }

    private GeneratorSettings(Builder builder) {
        this.setDefaults();
        this.generatorName = builder.generatorName;
        this.apiPackage = builder.apiPackage;
        this.modelPackage = builder.modelPackage;
        this.invokerPackage = builder.invokerPackage;
        this.packageName = builder.packageName;
        this.apiNameSuffix = builder.apiNameSuffix;
        this.modelNamePrefix = builder.modelNamePrefix;
        this.modelNameSuffix = builder.modelNameSuffix;
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.artifactVersion = builder.artifactVersion;
        this.library = builder.library;
        this.instantiationTypes = Collections.unmodifiableMap(builder.instantiationTypes);
        this.typeMappings = Collections.unmodifiableMap(builder.typeMappings);
        this.importMappings = Collections.unmodifiableMap(builder.importMappings);
        this.schemaMappings = Collections.unmodifiableMap(builder.schemaMappings);
        this.inlineSchemaNameMappings = Collections.unmodifiableMap(builder.inlineSchemaNameMappings);
        this.inlineSchemaNameDefaults = Collections.unmodifiableMap(builder.inlineSchemaNameDefaults);
        this.openapiNormalizer = Collections.unmodifiableMap(builder.openapiNormalizer);
        this.languageSpecificPrimitives = Collections.unmodifiableSet(builder.languageSpecificPrimitives);
        this.reservedWordsMappings = Collections.unmodifiableMap(builder.reservedWordsMappings);
        this.serverVariables = Collections.unmodifiableMap(builder.serverVariables);
        this.gitHost = builder.gitHost;
        this.gitUserId = builder.gitUserId;
        this.gitRepoId = builder.gitRepoId;
        this.releaseNote = builder.releaseNote;
        this.httpUserAgent = builder.httpUserAgent;
        HashMap<String, String> additional = new HashMap<String, String>(builder.additionalProperties);
        if (this.isNotEmpty(this.apiPackage)) {
            additional.put("apiPackage", this.apiPackage);
        }
        if (this.isNotEmpty(this.modelPackage)) {
            additional.put("modelPackage", this.modelPackage);
        }
        if (this.isNotEmpty(this.invokerPackage)) {
            additional.put("invokerPackage", this.invokerPackage);
        }
        if (this.isNotEmpty(this.packageName)) {
            additional.put("packageName", this.packageName);
        }
        if (this.isNotEmpty(this.groupId)) {
            additional.put("groupId", this.groupId);
        }
        if (this.isNotEmpty(this.artifactId)) {
            additional.put("artifactId", this.artifactId);
        }
        if (this.isNotEmpty(this.artifactVersion)) {
            additional.put("artifactVersion", this.artifactVersion);
        }
        if (this.isNotEmpty(this.apiNameSuffix)) {
            additional.put("apiNameSuffix", this.apiNameSuffix);
        }
        if (this.isNotEmpty(this.modelNamePrefix)) {
            additional.put("modelNamePrefix", this.modelNamePrefix);
        }
        if (this.isNotEmpty(this.modelNameSuffix)) {
            additional.put("modelNameSuffix", this.modelNameSuffix);
        }
        if (this.isNotEmpty(this.gitHost)) {
            additional.put("gitHost", this.gitHost);
        }
        if (this.isNotEmpty(this.gitUserId)) {
            additional.put("gitUserId", this.gitUserId);
        }
        if (this.isNotEmpty(this.gitRepoId)) {
            additional.put("gitRepoId", this.gitRepoId);
        }
        if (this.isNotEmpty(this.releaseNote)) {
            additional.put("releaseNote", this.releaseNote);
        }
        if (this.isNotEmpty(this.httpUserAgent)) {
            additional.put("httpUserAgent", this.httpUserAgent);
        }
        this.additionalProperties = Collections.unmodifiableMap(additional);
    }

    public GeneratorSettings() {
        this.setDefaults();
        this.instantiationTypes = Collections.unmodifiableMap(new HashMap(0));
        this.typeMappings = Collections.unmodifiableMap(new HashMap(0));
        this.additionalProperties = Collections.unmodifiableMap(new HashMap(0));
        this.importMappings = Collections.unmodifiableMap(new HashMap(0));
        this.schemaMappings = Collections.unmodifiableMap(new HashMap(0));
        this.inlineSchemaNameMappings = Collections.unmodifiableMap(new HashMap(0));
        this.inlineSchemaNameDefaults = Collections.unmodifiableMap(new HashMap(0));
        this.openapiNormalizer = Collections.unmodifiableMap(new HashMap(0));
        this.languageSpecificPrimitives = Collections.unmodifiableSet(new HashSet(0));
        this.reservedWordsMappings = Collections.unmodifiableMap(new HashMap(0));
        this.serverVariables = Collections.unmodifiableMap(new HashMap(0));
    }

    private void setDefaults() {
        this.gitHost = DEFAULT_GIT_HOST;
        this.gitUserId = DEFAULT_GIT_USER_ID;
        this.gitRepoId = DEFAULT_GIT_REPO_ID;
        this.releaseNote = DEFAULT_RELEASE_NOTE;
    }

    private boolean isNotEmpty(String value) {
        return value != null && value.length() > 0;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GeneratorSettings copy) {
        Builder builder = new Builder();
        builder.generatorName = copy.getGeneratorName();
        builder.apiPackage = copy.getApiPackage();
        builder.modelPackage = copy.getModelPackage();
        builder.invokerPackage = copy.getInvokerPackage();
        builder.packageName = copy.getPackageName();
        builder.apiNameSuffix = copy.getApiNameSuffix();
        builder.modelNamePrefix = copy.getModelNamePrefix();
        builder.modelNameSuffix = copy.getModelNameSuffix();
        builder.groupId = copy.getGroupId();
        builder.artifactId = copy.getArtifactId();
        builder.artifactVersion = copy.getArtifactVersion();
        builder.library = copy.getLibrary();
        if (copy.getInstantiationTypes() != null) {
            builder.instantiationTypes.putAll(copy.getInstantiationTypes());
        }
        if (copy.getTypeMappings() != null) {
            builder.typeMappings.putAll(copy.getTypeMappings());
        }
        if (copy.getAdditionalProperties() != null) {
            builder.additionalProperties.putAll(copy.getAdditionalProperties());
        }
        if (copy.getImportMappings() != null) {
            builder.importMappings.putAll(copy.getImportMappings());
        }
        if (copy.getSchemaMappings() != null) {
            builder.schemaMappings.putAll(copy.getSchemaMappings());
        }
        if (copy.getInlineSchemaNameMappings() != null) {
            builder.inlineSchemaNameMappings.putAll(copy.getInlineSchemaNameMappings());
        }
        if (copy.getInlineSchemaNameDefaults() != null) {
            builder.inlineSchemaNameDefaults.putAll(copy.getInlineSchemaNameDefaults());
        }
        if (copy.getOpenAPINormalizer() != null) {
            builder.openapiNormalizer.putAll(copy.getOpenAPINormalizer());
        }
        if (copy.getLanguageSpecificPrimitives() != null) {
            builder.languageSpecificPrimitives.addAll(copy.getLanguageSpecificPrimitives());
        }
        if (copy.getReservedWordsMappings() != null) {
            builder.reservedWordsMappings.putAll(copy.getReservedWordsMappings());
        }
        if (copy.getServerVariables() != null) {
            builder.serverVariables.putAll(copy.getServerVariables());
        }
        builder.gitHost = copy.getGitHost();
        builder.gitUserId = copy.getGitUserId();
        builder.gitRepoId = copy.getGitRepoId();
        builder.releaseNote = copy.getReleaseNote();
        builder.httpUserAgent = copy.getHttpUserAgent();
        return builder;
    }

    public String toString() {
        return "GeneratorSettings{generatorName='" + this.generatorName + '\'' + ", apiPackage='" + this.apiPackage + '\'' + ", modelPackage='" + this.modelPackage + '\'' + ", invokerPackage='" + this.invokerPackage + '\'' + ", packageName='" + this.packageName + '\'' + ", apiNameSuffix='" + this.apiNameSuffix + '\'' + ", modelNamePrefix='" + this.modelNamePrefix + '\'' + ", modelNameSuffix='" + this.modelNameSuffix + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", artifactVersion='" + this.artifactVersion + '\'' + ", library='" + this.library + '\'' + ", instantiationTypes=" + this.instantiationTypes + ", typeMappings=" + this.typeMappings + ", additionalProperties=" + this.additionalProperties + ", importMappings=" + this.importMappings + ", languageSpecificPrimitives=" + this.languageSpecificPrimitives + ", reservedWordsMappings=" + this.reservedWordsMappings + ", gitHost='" + this.gitHost + '\'' + ", gitUserId='" + this.gitUserId + '\'' + ", gitRepoId='" + this.gitRepoId + '\'' + ", releaseNote='" + this.releaseNote + '\'' + ", httpUserAgent='" + this.httpUserAgent + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneratorSettings)) {
            return false;
        }
        GeneratorSettings that = (GeneratorSettings)o;
        return Objects.equals(this.getGeneratorName(), that.getGeneratorName()) && Objects.equals(this.getApiPackage(), that.getApiPackage()) && Objects.equals(this.getModelPackage(), that.getModelPackage()) && Objects.equals(this.getInvokerPackage(), that.getInvokerPackage()) && Objects.equals(this.getPackageName(), that.getPackageName()) && Objects.equals(this.getApiNameSuffix(), that.getApiNameSuffix()) && Objects.equals(this.getModelNamePrefix(), that.getModelNamePrefix()) && Objects.equals(this.getModelNameSuffix(), that.getModelNameSuffix()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getArtifactVersion(), that.getArtifactVersion()) && Objects.equals(this.getLibrary(), that.getLibrary()) && Objects.equals(this.getInstantiationTypes(), that.getInstantiationTypes()) && Objects.equals(this.getTypeMappings(), that.getTypeMappings()) && Objects.equals(this.getAdditionalProperties(), that.getAdditionalProperties()) && Objects.equals(this.getImportMappings(), that.getImportMappings()) && Objects.equals(this.getSchemaMappings(), that.getSchemaMappings()) && Objects.equals(this.getInlineSchemaNameMappings(), that.getInlineSchemaNameMappings()) && Objects.equals(this.getInlineSchemaNameDefaults(), that.getInlineSchemaNameDefaults()) && Objects.equals(this.getOpenAPINormalizer(), that.getOpenAPINormalizer()) && Objects.equals(this.getLanguageSpecificPrimitives(), that.getLanguageSpecificPrimitives()) && Objects.equals(this.getReservedWordsMappings(), that.getReservedWordsMappings()) && Objects.equals(this.getGitHost(), that.getGitHost()) && Objects.equals(this.getGitUserId(), that.getGitUserId()) && Objects.equals(this.getGitRepoId(), that.getGitRepoId()) && Objects.equals(this.getReleaseNote(), that.getReleaseNote()) && Objects.equals(this.getHttpUserAgent(), that.getHttpUserAgent());
    }

    public int hashCode() {
        return Objects.hash(this.getGeneratorName(), this.getApiPackage(), this.getModelPackage(), this.getInvokerPackage(), this.getPackageName(), this.getApiNameSuffix(), this.getModelNamePrefix(), this.getModelNameSuffix(), this.getGroupId(), this.getArtifactId(), this.getArtifactVersion(), this.getLibrary(), this.getInstantiationTypes(), this.getTypeMappings(), this.getAdditionalProperties(), this.getImportMappings(), this.getSchemaMappings(), this.getInlineSchemaNameMappings(), this.getInlineSchemaNameDefaults(), this.getOpenAPINormalizer(), this.getLanguageSpecificPrimitives(), this.getReservedWordsMappings(), this.getGitHost(), this.getGitUserId(), this.getGitRepoId(), this.getReleaseNote(), this.getHttpUserAgent());
    }

    public static final class Builder {
        private String generatorName;
        private String apiPackage;
        private String modelPackage;
        private String invokerPackage;
        private String packageName;
        private String apiNameSuffix;
        private String modelNamePrefix;
        private String modelNameSuffix;
        private String groupId;
        private String artifactId;
        private String artifactVersion;
        private String library;
        private Map<String, String> instantiationTypes = new HashMap<String, String>();
        private Map<String, String> typeMappings = new HashMap<String, String>();
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();
        private Map<String, String> importMappings = new HashMap<String, String>();
        private Map<String, String> schemaMappings = new HashMap<String, String>();
        private Map<String, String> inlineSchemaNameMappings = new HashMap<String, String>();
        private Map<String, String> inlineSchemaNameDefaults = new HashMap<String, String>();
        private Map<String, String> openapiNormalizer = new HashMap<String, String>();
        private Set<String> languageSpecificPrimitives = new HashSet<String>();
        private Map<String, String> reservedWordsMappings = new HashMap<String, String>();
        private Map<String, String> serverVariables = new HashMap<String, String>();
        private String gitHost = "github.com";
        private String gitUserId = "GIT_USER_ID";
        private String gitRepoId = "GIT_REPO_ID";
        private String releaseNote = "Minor update";
        private String httpUserAgent;

        public Builder withGeneratorName(String generatorName) {
            this.generatorName = generatorName;
            return this;
        }

        public Builder withApiPackage(String apiPackage) {
            this.apiPackage = apiPackage;
            return this;
        }

        public Builder withModelPackage(String modelPackage) {
            this.modelPackage = modelPackage;
            return this;
        }

        public Builder withInvokerPackage(String invokerPackage) {
            this.invokerPackage = invokerPackage;
            return this;
        }

        public Builder withPackageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public Builder withApiNameSuffix(String apiNameSuffix) {
            this.apiNameSuffix = apiNameSuffix;
            return this;
        }

        public Builder withModelNamePrefix(String modelNamePrefix) {
            this.modelNamePrefix = modelNamePrefix;
            return this;
        }

        public Builder withModelNameSuffix(String modelNameSuffix) {
            this.modelNameSuffix = modelNameSuffix;
            return this;
        }

        public Builder withGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder withArtifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Builder withArtifactVersion(String artifactVersion) {
            this.artifactVersion = artifactVersion;
            return this;
        }

        public Builder withLibrary(String library) {
            this.library = library;
            return this;
        }

        public Builder withInstantiationTypes(Map<String, String> instantiationTypes) {
            this.instantiationTypes = instantiationTypes;
            return this;
        }

        public Builder withInstantiationType(String key, String value) {
            if (this.instantiationTypes == null) {
                this.instantiationTypes = new HashMap<String, String>();
            }
            this.instantiationTypes.put(key, value);
            return this;
        }

        public Builder withServerVariables(Map<String, String> serverVariables) {
            this.serverVariables = serverVariables;
            return this;
        }

        public Builder withTypeMappings(Map<String, String> typeMappings) {
            this.typeMappings = typeMappings;
            return this;
        }

        public Builder withAdditionalProperties(Map<String, Object> additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder withAdditionalProperty(String key, Object value) {
            if (this.additionalProperties == null) {
                this.additionalProperties = new HashMap<String, Object>();
            }
            this.additionalProperties.put(key, value);
            return this;
        }

        public Builder withSchemaMappings(Map<String, String> schemaMappings) {
            this.schemaMappings = schemaMappings;
            return this;
        }

        public Builder withSchemaMapping(String key, String value) {
            if (this.schemaMappings == null) {
                this.schemaMappings = new HashMap<String, String>();
            }
            this.schemaMappings.put(key, value);
            return this;
        }

        public Builder withImportMappings(Map<String, String> importMappings) {
            this.importMappings = importMappings;
            return this;
        }

        public Builder withImportMapping(String key, String value) {
            if (this.importMappings == null) {
                this.importMappings = new HashMap<String, String>();
            }
            this.importMappings.put(key, value);
            return this;
        }

        public Builder withInlineSchemaNameDefaults(Map<String, String> inlineSchemaNameDefaults) {
            this.inlineSchemaNameDefaults = inlineSchemaNameDefaults;
            return this;
        }

        public Builder withInlineSchemaNameDefault(String key, String value) {
            if (this.inlineSchemaNameDefaults == null) {
                this.inlineSchemaNameDefaults = new HashMap<String, String>();
            }
            this.inlineSchemaNameDefaults.put(key, value);
            return this;
        }

        public Builder withInlineSchemaNameMappings(Map<String, String> inlineSchemaNameMappings) {
            this.inlineSchemaNameMappings = inlineSchemaNameMappings;
            return this;
        }

        public Builder withInlineSchemaNameMapping(String key, String value) {
            if (this.inlineSchemaNameMappings == null) {
                this.inlineSchemaNameMappings = new HashMap<String, String>();
            }
            this.inlineSchemaNameMappings.put(key, value);
            return this;
        }

        public Builder withOpenAPINormalizer(Map<String, String> openapiNormalizer) {
            this.openapiNormalizer = openapiNormalizer;
            return this;
        }

        public Builder withOpenAPINormalizer(String key, String value) {
            if (this.openapiNormalizer == null) {
                this.openapiNormalizer = new HashMap<String, String>();
            }
            this.openapiNormalizer.put(key, value);
            return this;
        }

        public Builder withLanguageSpecificPrimitives(Set<String> languageSpecificPrimitives) {
            this.languageSpecificPrimitives = languageSpecificPrimitives;
            return this;
        }

        public Builder withLanguageSpecificPrimitive(String value) {
            if (this.languageSpecificPrimitives == null) {
                this.languageSpecificPrimitives = new HashSet<String>();
            }
            this.languageSpecificPrimitives.add(value);
            return this;
        }

        public Builder withReservedWordsMappings(Map<String, String> reservedWordsMappings) {
            this.reservedWordsMappings = reservedWordsMappings;
            return this;
        }

        public Builder withReservedWordMapping(String key, String value) {
            if (this.reservedWordsMappings == null) {
                this.reservedWordsMappings = new HashMap<String, String>();
            }
            this.reservedWordsMappings.put(key, value);
            return this;
        }

        public Builder withServerVariable(String key, String value) {
            if (this.serverVariables == null) {
                this.serverVariables = new HashMap<String, String>();
            }
            this.serverVariables.put(key, value);
            return this;
        }

        public Builder withGitHost(String gitHost) {
            this.gitHost = gitHost;
            return this;
        }

        public Builder withGitUserId(String gitUserId) {
            this.gitUserId = gitUserId;
            return this;
        }

        public Builder withGitRepoId(String gitRepoId) {
            this.gitRepoId = gitRepoId;
            return this;
        }

        public Builder withReleaseNote(String releaseNote) {
            this.releaseNote = releaseNote;
            return this;
        }

        public Builder withHttpUserAgent(String httpUserAgent) {
            this.httpUserAgent = httpUserAgent;
            return this;
        }

        public GeneratorSettings build() {
            GeneratorSettings instance = new GeneratorSettings(this);
            LOGGER.debug("GeneratorSettings#build: %s", (Object)instance.toString());
            return instance;
        }
    }
}

