/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.validation;

import java.util.function.Function;
import org.openapitools.codegen.validation.Severity;

public class ValidationRule {
    private Severity severity;
    private String description;
    private String failureMessage;
    private Function<Object, Result> test;

    ValidationRule(Severity severity, String description, String failureMessage, Function<Object, Result> test) {
        this.severity = severity;
        this.description = description;
        this.failureMessage = failureMessage;
        this.test = test;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public Result evaluate(Object input) {
        return this.test.apply(input);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    static ValidationRule empty() {
        return new ValidationRule(Severity.ERROR, "empty", "failure message", i -> Fail.empty());
    }

    public static <T> ValidationRule create(Severity severity, String description, String failureMessage, Function<T, Result> fn) {
        return new ValidationRule(severity, description, failureMessage, fn);
    }

    public static <T> ValidationRule error(String failureMessage, Function<T, Result> fn) {
        return new ValidationRule(Severity.ERROR, null, failureMessage, fn);
    }

    public static <T> ValidationRule warn(String description, String failureMessage, Function<T, Result> fn) {
        return new ValidationRule(Severity.WARNING, description, failureMessage, fn);
    }

    public String toString() {
        return "ValidationRule{severity=" + this.severity + ", description='" + this.description + "', failureMessage='" + this.failureMessage + "'}";
    }

    public static final class Fail
    extends Result {
        public static Result empty() {
            return new Fail();
        }

        public Fail() {
        }

        public Fail(String details) {
            this();
            this.details = details;
        }

        public Fail(String details, Throwable throwable) {
            this();
            this.throwable = throwable;
            this.details = details;
        }

        @Override
        public boolean passed() {
            return false;
        }
    }

    public static final class Pass
    extends Result {
        public static Result empty() {
            return new Pass();
        }

        public Pass() {
        }

        public Pass(String details) {
            this();
            this.details = details;
        }

        @Override
        public boolean passed() {
            return true;
        }
    }

    public static abstract class Result {
        protected String details = null;
        protected Throwable throwable = null;

        public String getDetails() {
            return this.details;
        }

        public void setDetails(String details) {
            assert (this.details == null);
            this.details = details;
        }

        public abstract boolean passed();

        public final boolean failed() {
            return !this.passed();
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean thrown() {
            return this.throwable == null;
        }
    }
}

