/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;

public class GraphPathRecord {
    private final GraphPathRecord parent;
    private final String path;
    private final int depth;
    private final Object obj;
    private final long size;
    private final long address;
    private String toString;

    GraphPathRecord(GraphPathRecord parent, String path, int depth, Object obj) {
        this.parent = parent;
        this.path = path;
        this.obj = obj;
        this.depth = depth;
        this.size = VM.current().sizeOf(obj);
        this.address = VM.current().addressOf(obj);
    }

    Object obj() {
        return this.obj;
    }

    public String path() {
        if (this.parent != null) {
            return this.parent.path() + this.path;
        }
        return this.path;
    }

    public Class<?> klass() {
        return this.obj.getClass();
    }

    public long size() {
        return this.size;
    }

    public long address() {
        return this.address;
    }

    public String objToString() {
        String v = this.toString;
        if (v == null) {
            this.toString = v = ObjectUtils.safeToString(this.obj);
        }
        return v;
    }

    public int depth() {
        return this.depth;
    }
}

