/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.datatypes;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.LiteralUtilException;
import org.openrdf.rio.DatatypeHandler;

public class XMLSchemaDatatypeHandler
implements DatatypeHandler {
    public boolean isRecognizedDatatype(URI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return XMLDatatypeUtil.isBuiltInDatatype((URI)datatypeUri);
    }

    public boolean verifyDatatype(String literalValue, URI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return XMLDatatypeUtil.isValidValue((String)literalValue, (URI)datatypeUri);
        }
        throw new LiteralUtilException("Could not verify XMLSchema literal");
    }

    public Literal normalizeDatatype(String literalValue, URI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            try {
                return valueFactory.createLiteral(XMLDatatypeUtil.normalize((String)literalValue, (URI)datatypeUri), datatypeUri);
            }
            catch (IllegalArgumentException e) {
                throw new LiteralUtilException("Could not normalise XMLSchema literal", (Throwable)e);
            }
        }
        throw new LiteralUtilException("Could not normalise XMLSchema literal");
    }

    public String getKey() {
        return "org.openrdf.rio.datatypes.xmlschema";
    }
}

