/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.matchervisitors;

import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.AnyMatcher;
import org.parboiled.matchers.AnyOfMatcher;
import org.parboiled.matchers.CharIgnoreCaseMatcher;
import org.parboiled.matchers.CharMatcher;
import org.parboiled.matchers.CharRangeMatcher;
import org.parboiled.matchers.CustomMatcher;
import org.parboiled.matchers.EmptyMatcher;
import org.parboiled.matchers.FirstOfMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.NothingMatcher;
import org.parboiled.matchers.OneOrMoreMatcher;
import org.parboiled.matchers.OptionalMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.matchers.ZeroOrMoreMatcher;
import org.parboiled.matchervisitors.CanMatchEmptyVisitor;
import org.parboiled.matchervisitors.MatcherVisitor;

public class IsStarterCharVisitor
implements MatcherVisitor<Boolean> {
    private final CanMatchEmptyVisitor canMatchEmptyVisitor = new CanMatchEmptyVisitor();
    private final char starterChar;

    public IsStarterCharVisitor(char c) {
        this.starterChar = c;
    }

    @Override
    public Boolean visit(ActionMatcher actionMatcher) {
        return false;
    }

    @Override
    public Boolean visit(AnyMatcher anyMatcher) {
        return this.starterChar != '\uffff';
    }

    @Override
    public Boolean visit(CharIgnoreCaseMatcher charIgnoreCaseMatcher) {
        return charIgnoreCaseMatcher.charLow == this.starterChar || charIgnoreCaseMatcher.charUp == this.starterChar;
    }

    @Override
    public Boolean visit(CharMatcher charMatcher) {
        return charMatcher.character == this.starterChar;
    }

    @Override
    public Boolean visit(CharRangeMatcher charRangeMatcher) {
        return charRangeMatcher.cLow <= this.starterChar && this.starterChar <= charRangeMatcher.cHigh;
    }

    @Override
    public Boolean visit(AnyOfMatcher anyOfMatcher) {
        return anyOfMatcher.characters.contains(this.starterChar);
    }

    @Override
    public Boolean visit(CustomMatcher customMatcher) {
        return customMatcher.isStarterChar(this.starterChar);
    }

    @Override
    public Boolean visit(EmptyMatcher emptyMatcher) {
        return false;
    }

    @Override
    public Boolean visit(FirstOfMatcher firstOfMatcher) {
        for (Matcher matcher : firstOfMatcher.getChildren()) {
            if (!matcher.accept(this).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean visit(NothingMatcher nothingMatcher) {
        return false;
    }

    @Override
    public Boolean visit(OneOrMoreMatcher oneOrMoreMatcher) {
        return oneOrMoreMatcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(OptionalMatcher optionalMatcher) {
        return optionalMatcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(SequenceMatcher sequenceMatcher) {
        for (Matcher matcher : sequenceMatcher.getChildren()) {
            if (matcher.accept(this).booleanValue()) {
                return true;
            }
            if (matcher.accept(this.canMatchEmptyVisitor).booleanValue()) continue;
            break;
        }
        return false;
    }

    @Override
    public Boolean visit(TestMatcher testMatcher) {
        return testMatcher.subMatcher.accept(this);
    }

    @Override
    public Boolean visit(TestNotMatcher testNotMatcher) {
        return false;
    }

    @Override
    public Boolean visit(ZeroOrMoreMatcher zeroOrMoreMatcher) {
        return zeroOrMoreMatcher.subMatcher.accept(this);
    }
}

