/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassInfoBuilder;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.ClassPointer;
import org.pitest.classinfo.HierarchicalClassId;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo {
    private final ClassIdentifier id;
    private final int access;
    private final Set<Integer> codeLines;
    private final ClassPointer outerClass;
    private final ClassPointer superClass;
    private final Collection<ClassName> annotations;
    private final String sourceFile;
    private final Map<ClassName, Object> classAnnotationValues;

    public ClassInfo(ClassPointer superClass, ClassPointer outerClass, ClassInfoBuilder builder) {
        this.superClass = superClass;
        this.outerClass = outerClass;
        this.id = builder.id;
        this.access = builder.access;
        this.codeLines = builder.codeLines;
        this.annotations = FCollection.map(builder.annotations, ClassName.stringToClassName());
        this.sourceFile = builder.sourceFile;
        this.classAnnotationValues = builder.classAnnotationValues;
    }

    public int getNumberOfCodeLines() {
        return this.codeLines.size();
    }

    public boolean isCodeLine(int line) {
        return this.codeLines.contains(line);
    }

    public ClassIdentifier getId() {
        return this.id;
    }

    public ClassName getName() {
        return this.id.getName();
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.access & 0x400) != 0;
    }

    public boolean isTopLevelClass() {
        return this.getOuterClass().hasNone();
    }

    public Option<ClassInfo> getOuterClass() {
        return this.outerClass.fetch();
    }

    public Option<ClassInfo> getSuperClass() {
        return this.getParent();
    }

    public String getSourceFileName() {
        return this.sourceFile;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.hasAnnotation(new ClassName(annotation));
    }

    public boolean hasAnnotation(ClassName annotation) {
        return this.annotations.contains(annotation);
    }

    public Object getClassAnnotationValue(ClassName annotation) {
        return this.classAnnotationValues.get(annotation);
    }

    public boolean descendsFrom(Class<?> clazz) {
        return this.descendsFrom(new ClassName(clazz.getName()));
    }

    public HierarchicalClassId getHierarchicalId() {
        return new HierarchicalClassId(this.id, this.getDeepHash());
    }

    public BigInteger getDeepHash() {
        Option<ClassInfo> outer;
        BigInteger hash = this.getHash();
        Option<ClassInfo> parent = this.getParent();
        if (parent.hasSome()) {
            hash = hash.add(parent.value().getHash());
        }
        if ((outer = this.getOuterClass()).hasSome()) {
            hash = hash.add(outer.value().getHash());
        }
        return hash;
    }

    public BigInteger getHash() {
        return BigInteger.valueOf(this.id.getHash());
    }

    private Option<ClassInfo> getParent() {
        if (this.superClass == null) {
            return Option.none();
        }
        return this.superClass.fetch();
    }

    private boolean descendsFrom(ClassName clazz) {
        if (this.getSuperClass().hasNone()) {
            return false;
        }
        if (this.getSuperClass().value().getName().equals(clazz)) {
            return true;
        }
        return this.getSuperClass().value().descendsFrom(clazz);
    }

    public static F<ClassInfo, Boolean> matchIfAbstract() {
        return new F<ClassInfo, Boolean>(){

            @Override
            public Boolean apply(ClassInfo a) {
                return a.isAbstract();
            }
        };
    }

    public String toString() {
        return this.id.getName().asJavaName();
    }

    public static F<ClassInfo, ClassName> toClassName() {
        return new F<ClassInfo, ClassName>(){

            @Override
            public ClassName apply(ClassInfo a) {
                return a.getName();
            }
        };
    }

    public static F<ClassInfo, HierarchicalClassId> toFullClassId() {
        return new F<ClassInfo, HierarchicalClassId>(){

            @Override
            public HierarchicalClassId apply(ClassInfo a) {
                return a.getHierarchicalId();
            }
        };
    }
}

