/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.io.Serializable;
import org.pitest.functional.F;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassName
implements Serializable,
Comparable<ClassName> {
    private static final long serialVersionUID = 1L;
    private final String name;

    public ClassName(String name) {
        this.name = name.replace('.', '/').intern();
    }

    public ClassName(Class<?> clazz) {
        this(clazz.getName());
    }

    public static ClassName fromString(String clazz) {
        return new ClassName(clazz);
    }

    public static ClassName fromClass(Class<?> clazz) {
        return new ClassName(clazz);
    }

    public String asJavaName() {
        return this.name.replace('/', '.');
    }

    public String asInternalName() {
        return this.name;
    }

    public ClassName getNameWithoutPackage() {
        int lastSeparator = this.name.lastIndexOf(47);
        if (lastSeparator != -1) {
            return new ClassName(this.name.substring(lastSeparator + 1, this.name.length()));
        }
        return this;
    }

    public ClassName getPackage() {
        int lastSeparator = this.name.lastIndexOf(47);
        if (lastSeparator != -1) {
            return new ClassName(this.name.substring(0, lastSeparator));
        }
        return new ClassName("");
    }

    public ClassName withoutPrefixChars(int prefixLength) {
        String nameWithoutPackage = this.getNameWithoutPackage().asJavaName();
        return new ClassName(this.getPackage().asJavaName() + "/" + nameWithoutPackage.substring(prefixLength, nameWithoutPackage.length()));
    }

    public ClassName withoutSuffixChars(int suffixLength) {
        String nameWithoutPacakge = this.getNameWithoutPackage().asJavaName();
        return new ClassName(this.getPackage().asJavaName() + "/" + nameWithoutPacakge.substring(0, nameWithoutPacakge.length() - suffixLength));
    }

    public static F<String, ClassName> stringToClassName() {
        return new F<String, ClassName>(){

            @Override
            public ClassName apply(String clazz) {
                return ClassName.fromString(clazz);
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.asJavaName();
    }

    @Override
    public int compareTo(ClassName o) {
        return this.asJavaName().compareTo(o.asJavaName());
    }
}

