/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.math.BigInteger;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassName;

public class HierarchicalClassId {
    private final ClassIdentifier classId;
    private final String hierarchicalHash;

    public HierarchicalClassId(ClassIdentifier classId, String hierarchicalHash) {
        this.classId = classId;
        this.hierarchicalHash = hierarchicalHash;
    }

    public HierarchicalClassId(ClassIdentifier id, BigInteger deepHash) {
        this(id, deepHash.toString(16));
    }

    public HierarchicalClassId(long hash, ClassName name, String hierarchicalHash) {
        this(new ClassIdentifier(hash, name), hierarchicalHash);
    }

    public String getHierarchicalHash() {
        return this.hierarchicalHash;
    }

    public ClassName getName() {
        return this.classId.getName();
    }

    public ClassIdentifier getId() {
        return this.classId;
    }

    public String toString() {
        return "HierarchicalClassId [classId=" + this.classId + ", hierarchicalHash=" + this.hierarchicalHash + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classId == null ? 0 : this.classId.hashCode());
        result = 31 * result + (this.hierarchicalHash == null ? 0 : this.hierarchicalHash.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchicalClassId other = (HierarchicalClassId)obj;
        if (this.classId == null ? other.classId != null : !this.classId.equals(other.classId)) {
            return false;
        }
        return !(this.hierarchicalHash == null ? other.hierarchicalHash != null : !this.hierarchicalHash.equals(other.hierarchicalHash));
    }
}

